/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.store.RedissonPubSubStore;
import com.corundumstudio.socketio.store.RedissonStore;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.pubsub.BaseStoreFactory;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import java.util.Map;
import java.util.UUID;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;

public class RedissonStoreFactory
extends BaseStoreFactory {
    private final RedissonClient redisClient;
    private final RedissonClient redisPub;
    private final RedissonClient redisSub;
    private final PubSubStore pubSubStore;

    public RedissonStoreFactory() {
        this(Redisson.create());
    }

    public RedissonStoreFactory(RedissonClient redisson) {
        this.redisClient = redisson;
        this.redisPub = redisson;
        this.redisSub = redisson;
        this.pubSubStore = new RedissonPubSubStore(this.redisPub, this.redisSub, this.getNodeId());
    }

    public RedissonStoreFactory(Redisson redisClient, Redisson redisPub, Redisson redisSub) {
        this.redisClient = redisClient;
        this.redisPub = redisPub;
        this.redisSub = redisSub;
        this.pubSubStore = new RedissonPubSubStore((RedissonClient)redisPub, (RedissonClient)redisSub, this.getNodeId());
    }

    @Override
    public Store createStore(UUID sessionId) {
        return new RedissonStore(sessionId, this.redisClient);
    }

    @Override
    public PubSubStore pubSubStore() {
        return this.pubSubStore;
    }

    @Override
    public void shutdown() {
        this.redisClient.shutdown();
        this.redisPub.shutdown();
        this.redisSub.shutdown();
    }

    @Override
    public <K, V> Map<K, V> createMap(String name) {
        return this.redisClient.getMap(name);
    }
}

