/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import com.corundumstudio.socketio.protocol.PacketType;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Packet
implements Serializable {
    private static final long serialVersionUID = 4560159536486711426L;
    private PacketType type;
    private PacketType subType;
    private Long ackId;
    private String name;
    private String nsp = "";
    private Object data;
    private ByteBuf dataSource;
    private int attachmentsCount;
    private List<ByteBuf> attachments = Collections.emptyList();

    protected Packet() {
    }

    public Packet(PacketType type) {
        this.type = type;
    }

    public PacketType getSubType() {
        return this.subType;
    }

    public void setSubType(PacketType subType) {
        this.subType = subType;
    }

    public PacketType getType() {
        return this.type;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public Packet withNsp(String namespace) {
        if (this.nsp.equalsIgnoreCase(namespace)) {
            return this;
        }
        Packet newPacket = new Packet(this.type);
        newPacket.setAckId(this.ackId);
        newPacket.setData(this.data);
        newPacket.setDataSource(this.dataSource);
        newPacket.setName(this.name);
        newPacket.setSubType(this.subType);
        newPacket.setNsp(namespace);
        newPacket.attachments = this.attachments;
        newPacket.attachmentsCount = this.attachmentsCount;
        return newPacket;
    }

    public void setNsp(String endpoint) {
        this.nsp = endpoint;
    }

    public String getNsp() {
        return this.nsp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAckId() {
        return this.ackId;
    }

    public void setAckId(Long ackId) {
        this.ackId = ackId;
    }

    public boolean isAckRequested() {
        return this.getAckId() != null;
    }

    public void initAttachments(int attachmentsCount) {
        this.attachmentsCount = attachmentsCount;
        this.attachments = new ArrayList<ByteBuf>(attachmentsCount);
    }

    public void addAttachment(ByteBuf attachment) {
        if (this.attachments.size() < this.attachmentsCount) {
            this.attachments.add(attachment);
        }
    }

    public List<ByteBuf> getAttachments() {
        return this.attachments;
    }

    public boolean hasAttachments() {
        return this.attachmentsCount != 0;
    }

    public boolean isAttachmentsLoaded() {
        return this.attachments.size() == this.attachmentsCount;
    }

    public ByteBuf getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ByteBuf dataSource) {
        this.dataSource = dataSource;
    }

    public String toString() {
        return "Packet [type=" + (Object)((Object)this.type) + ", ackId=" + this.ackId + "]";
    }
}

