/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.async.AsyncFilterManager;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.async.AsyncRunnable;
import com.comphenix.protocol.async.NullPacketListener;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.scheduler.Task;
import com.comphenix.protocol.timing.TimingListenerType;
import com.comphenix.protocol.timing.TimingTrackerManager;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.plugin.Plugin;

public class AsyncListenerHandler {
    public static final ReportType REPORT_HANDLER_NOT_STARTED = new ReportType("Plugin %s did not start the asynchronous handler %s by calling start() or syncStart().");
    private static final PacketEvent INTERUPT_PACKET = new PacketEvent(new Object());
    private static final PacketEvent WAKEUP_PACKET = new PacketEvent(new Object());
    private static final int TICKS_PER_SECOND = 20;
    private static final AtomicInteger nextID = new AtomicInteger();
    private static final int DEFAULT_CAPACITY = 1024;
    private volatile boolean cancelled;
    private final AtomicInteger started = new AtomicInteger();
    private PacketListener listener;
    private AsyncFilterManager filterManager;
    private NullPacketListener nullPacketListener;
    private ArrayBlockingQueue<PacketEvent> queuedPackets = new ArrayBlockingQueue(1024);
    private final Set<Integer> stoppedTasks = new HashSet<Integer>();
    private final Object stopLock = new Object();
    private Task syncTask = null;
    private Thread mainThread;
    private Task warningTask;

    AsyncListenerHandler(Thread mainThread, AsyncFilterManager filterManager, PacketListener listener) {
        if (filterManager == null) {
            throw new IllegalArgumentException("filterManager cannot be NULL");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL");
        }
        this.mainThread = mainThread;
        this.filterManager = filterManager;
        this.listener = listener;
        this.startWarningTask();
    }

    private void startWarningTask() {
        this.warningTask = this.filterManager.getScheduler().scheduleSyncDelayedTask(() -> ProtocolLibrary.getErrorReporter().reportWarning((Object)this, Report.newBuilder(REPORT_HANDLER_NOT_STARTED).messageParam(this.listener.getPlugin(), this).build()), 40L);
    }

    private void stopWarningTask() {
        if (this.warningTask != null) {
            this.warningTask.cancel();
            this.warningTask = null;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public PacketListener getAsyncListener() {
        return this.listener;
    }

    void setNullPacketListener(NullPacketListener nullPacketListener) {
        this.nullPacketListener = nullPacketListener;
    }

    PacketListener getNullPacketListener() {
        return this.nullPacketListener;
    }

    public Plugin getPlugin() {
        return this.listener != null ? this.listener.getPlugin() : null;
    }

    public void cancel() {
        this.close();
    }

    public void enqueuePacket(PacketEvent packet) {
        if (packet == null) {
            throw new IllegalArgumentException("packet is NULL");
        }
        this.queuedPackets.add(packet);
    }

    public AsyncRunnable getListenerLoop() {
        return new AsyncRunnable(){
            private final AtomicBoolean firstRun = new AtomicBoolean();
            private final AtomicBoolean finished = new AtomicBoolean();
            private final int id = AsyncListenerHandler.access$000().incrementAndGet();

            @Override
            public int getID() {
                return this.id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.firstRun.compareAndSet(false, true)) {
                    AsyncListenerHandler.this.listenerLoop(this.id);
                    Object object = AsyncListenerHandler.this.stopLock;
                    synchronized (object) {
                        AsyncListenerHandler.this.stoppedTasks.remove(this.id);
                        AsyncListenerHandler.this.stopLock.notifyAll();
                        this.finished.set(true);
                    }
                } else {
                    if (this.finished.get()) {
                        throw new IllegalStateException("This listener has already been run. Create a new instead.");
                    }
                    throw new IllegalStateException("This listener loop has already been started. Create a new instead.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stop() throws InterruptedException {
                Object object = AsyncListenerHandler.this.stopLock;
                synchronized (object) {
                    if (!this.isRunning()) {
                        return false;
                    }
                    AsyncListenerHandler.this.stoppedTasks.add(this.id);
                    for (int i = 0; i < AsyncListenerHandler.this.getWorkers(); ++i) {
                        AsyncListenerHandler.this.queuedPackets.offer(WAKEUP_PACKET);
                    }
                    this.finished.set(true);
                    AsyncListenerHandler.this.waitForStops();
                    return true;
                }
            }

            @Override
            public boolean isRunning() {
                return this.firstRun.get() && !this.finished.get();
            }

            @Override
            public boolean isFinished() {
                return this.finished.get();
            }
        };
    }

    public synchronized void start() {
        if (this.listener.getPlugin() == null) {
            throw new IllegalArgumentException("Cannot start task without a valid plugin.");
        }
        if (this.cancelled) {
            throw new IllegalStateException("Cannot start a worker when the listener is closing.");
        }
        AsyncRunnable listenerLoop = this.getListenerLoop();
        this.stopWarningTask();
        this.scheduleAsync(() -> {
            Thread thread = Thread.currentThread();
            String previousName = thread.getName();
            String workerName = this.getFriendlyWorkerName(listenerLoop.getID());
            thread.setName(workerName);
            listenerLoop.run();
            thread.setName(previousName);
        });
    }

    public synchronized void start(Function<AsyncRunnable, Void> executor) {
        if (this.listener.getPlugin() == null) {
            throw new IllegalArgumentException("Cannot start task without a valid plugin.");
        }
        if (this.cancelled) {
            throw new IllegalStateException("Cannot start a worker when the listener is closing.");
        }
        AsyncRunnable listenerLoop = this.getListenerLoop();
        Function<AsyncRunnable, Void> delegateCopy = executor;
        this.scheduleAsync(() -> delegateCopy.apply((Object)listenerLoop));
    }

    private void scheduleAsync(Runnable runnable) {
        this.filterManager.getScheduler().runTaskAsync(runnable);
    }

    public String getFriendlyWorkerName(int id) {
        return String.format("Protocol Worker #%s - %s - [recv: %s, send: %s]", id, PacketAdapter.getPluginName(this.listener), this.fromWhitelist(this.listener.getReceivingWhitelist()), this.fromWhitelist(this.listener.getSendingWhitelist()));
    }

    private String fromWhitelist(ListeningWhitelist whitelist) {
        if (whitelist == null) {
            return "";
        }
        return Joiner.on((String)", ").join(whitelist.getTypes());
    }

    public synchronized boolean syncStart() {
        return this.syncStart(500L, TimeUnit.MICROSECONDS);
    }

    public synchronized boolean syncStart(long time, TimeUnit unit) {
        if (time <= 0L) {
            throw new IllegalArgumentException("Time must be greater than zero.");
        }
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be NULL.");
        }
        long tickDelay = 1L;
        int workerID = nextID.incrementAndGet();
        if (this.syncTask == null) {
            this.stopWarningTask();
            this.syncTask = this.filterManager.getScheduler().scheduleSyncRepeatingTask(() -> {
                long stopTime = System.nanoTime() + unit.convert(time, TimeUnit.NANOSECONDS);
                while (!this.cancelled) {
                    PacketEvent packet = this.queuedPackets.poll();
                    if (packet == INTERUPT_PACKET || packet == WAKEUP_PACKET) {
                        this.queuedPackets.add(packet);
                        break;
                    }
                    if (packet == null || packet.getAsyncMarker() == null) break;
                    this.processPacket(workerID, packet, "onSyncPacket()");
                    if (System.nanoTime() >= stopTime) continue;
                    break;
                }
            }, 1L, 1L);
            if (this.syncTask == null) {
                throw new IllegalStateException("Cannot start synchronous task.");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean syncStop() {
        if (this.syncTask != null) {
            this.syncTask.cancel();
            this.syncTask = null;
            return true;
        }
        return false;
    }

    public synchronized void start(int count) {
        for (int i = 0; i < count; ++i) {
            this.start();
        }
    }

    public synchronized void stop() {
        this.queuedPackets.add(INTERUPT_PACKET);
    }

    public synchronized void stop(int count) {
        for (int i = 0; i < count; ++i) {
            this.stop();
        }
    }

    public synchronized void setWorkers(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Number of workers cannot be less than zero.");
        }
        if (count > 1024) {
            throw new IllegalArgumentException("Cannot initiate more than 1024 workers");
        }
        if (this.cancelled && count > 0) {
            throw new IllegalArgumentException("Cannot add workers when the listener is closing.");
        }
        long time = System.currentTimeMillis();
        while (this.started.get() != count) {
            if (this.started.get() < count) {
                this.start();
            } else {
                this.stop();
            }
            if (System.currentTimeMillis() - time <= 50L) continue;
            throw new RuntimeException("Failed to set worker count.");
        }
    }

    public synchronized int getWorkers() {
        return this.started.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForStops() throws InterruptedException {
        Object object = this.stopLock;
        synchronized (object) {
            while (this.stoppedTasks.size() > 0 && !this.cancelled) {
                this.stopLock.wait();
            }
            return this.cancelled;
        }
    }

    /*
     * Exception decompiling
     */
    private void listenerLoop(int workerID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(int workerID, PacketEvent packet, String methodName) {
        AsyncMarker marker = packet.getAsyncMarker();
        try {
            Object object = marker.getProcessingLock();
            synchronized (object) {
                marker.setListenerHandler(this);
                marker.setWorkerID(workerID);
                TimingTrackerManager.get(this.listener, packet.isServerPacket() ? TimingListenerType.ASYNC_OUTBOUND : TimingListenerType.ASYNC_INBOUND).track(packet.getPacketType(), () -> {
                    if (packet.isServerPacket()) {
                        this.listener.onPacketSending(packet);
                    } else {
                        this.listener.onPacketReceiving(packet);
                    }
                });
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            this.filterManager.getErrorReporter().reportMinimal(this.listener.getPlugin(), methodName, e);
        }
        this.filterManager.signalPacketTransmission(packet);
    }

    private synchronized void close() {
        if (!this.cancelled) {
            this.filterManager.unregisterAsyncHandlerInternal(this);
            this.cancelled = true;
            this.syncStop();
            this.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads() {
        this.queuedPackets.clear();
        this.stop(this.started.get());
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return nextID;
    }
}

