/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.StructureCache;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedTeamParameters
extends AbstractWrapper {
    private final StructureModifier<Object> modifier;

    public static Class<?> getNmsClassOrThrow() {
        return MinecraftReflection.getTeamParametersClass().orElseThrow(() -> new IllegalStateException("Team parameters class doesn't exist on this server version"));
    }

    public static boolean isSupported() {
        return MinecraftReflection.getTeamParametersClass().isPresent();
    }

    public static Builder newBuilder() {
        return WrappedTeamParameters.newBuilder(null);
    }

    public static Builder newBuilder(@Nullable WrappedTeamParameters template) {
        return new Builder(template);
    }

    public WrappedTeamParameters(Object handle) {
        super(WrappedTeamParameters.getNmsClassOrThrow());
        this.setHandle(handle);
        this.modifier = new StructureModifier(WrappedTeamParameters.getNmsClassOrThrow()).withTarget(handle);
    }

    @NotNull
    public WrappedChatComponent getDisplayName() {
        return this.readComponent(0);
    }

    @NotNull
    public WrappedChatComponent getPrefix() {
        return this.readComponent(1);
    }

    @NotNull
    public WrappedChatComponent getSuffix() {
        return this.readComponent(2);
    }

    @NotNull
    public String getNametagVisibility() {
        return (String)this.modifier.withType(String.class).read(0);
    }

    @NotNull
    public String getCollisionRule() {
        return (String)this.modifier.withType(String.class).read(1);
    }

    @NotNull
    public EnumWrappers.ChatFormatting getColor() {
        Object handle = this.modifier.withType(EnumWrappers.getChatFormattingClass()).read(0);
        return EnumWrappers.getChatFormattingConverter().getSpecific(handle);
    }

    public int getOptions() {
        return (Integer)this.modifier.withType(Integer.TYPE).read(0);
    }

    private WrappedChatComponent readComponent(int index) {
        Object handle = this.modifier.withType(MinecraftReflection.getIChatBaseComponentClass()).read(index);
        return WrappedChatComponent.fromHandle(handle);
    }

    private void writeComponent(int index, WrappedChatComponent component) {
        this.modifier.withType(MinecraftReflection.getIChatBaseComponentClass()).write(index, component.getHandle());
    }

    public static class Builder {
        private WrappedChatComponent displayName;
        private WrappedChatComponent prefix;
        private WrappedChatComponent suffix;
        private String nametagVisibility;
        private String collisionRule;
        private EnumWrappers.ChatFormatting color;
        private int options;

        private Builder(@Nullable WrappedTeamParameters template) {
            if (template != null) {
                this.displayName = template.getDisplayName();
                this.prefix = template.getPrefix();
                this.suffix = template.getSuffix();
                this.nametagVisibility = template.getNametagVisibility();
                this.collisionRule = template.getCollisionRule();
                this.color = template.getColor();
                this.options = template.getOptions();
            }
        }

        public Builder displayName(@NotNull WrappedChatComponent displayName) {
            Preconditions.checkNotNull((Object)displayName);
            this.displayName = displayName;
            return this;
        }

        public Builder prefix(@NotNull WrappedChatComponent prefix) {
            Preconditions.checkNotNull((Object)prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(@NotNull WrappedChatComponent suffix) {
            Preconditions.checkNotNull((Object)suffix);
            this.suffix = suffix;
            return this;
        }

        public Builder nametagVisibility(@NotNull String nametagVisibility) {
            Preconditions.checkNotNull((Object)nametagVisibility);
            this.nametagVisibility = nametagVisibility;
            return this;
        }

        public Builder collisionRule(@NotNull String collisionRule) {
            Preconditions.checkNotNull((Object)collisionRule);
            this.collisionRule = collisionRule;
            return this;
        }

        public Builder color(@NotNull EnumWrappers.ChatFormatting color) {
            Preconditions.checkNotNull((Object)((Object)color));
            this.color = color;
            return this;
        }

        public Builder options(int options) {
            Preconditions.checkNotNull((Object)this.collisionRule);
            this.options = options;
            return this;
        }

        public WrappedTeamParameters build() {
            Preconditions.checkNotNull((Object)this.displayName, (Object)"Display name not set");
            Preconditions.checkNotNull((Object)this.prefix, (Object)"Prefix not set");
            Preconditions.checkNotNull((Object)this.suffix, (Object)"Suffix not set");
            Preconditions.checkNotNull((Object)this.nametagVisibility, (Object)"Nametag visibility not set");
            Preconditions.checkNotNull((Object)this.collisionRule, (Object)"Collision rule not set");
            Preconditions.checkNotNull((Object)((Object)this.color), (Object)"Color not set");
            Object handle = StructureCache.newInstance(WrappedTeamParameters.getNmsClassOrThrow());
            WrappedTeamParameters wrapped = new WrappedTeamParameters(handle);
            wrapped.writeComponent(0, this.displayName);
            wrapped.writeComponent(1, this.prefix);
            wrapped.writeComponent(2, this.suffix);
            wrapped.modifier.withType(String.class).write(0, this.nametagVisibility);
            wrapped.modifier.withType(String.class).write(1, this.collisionRule);
            wrapped.modifier.withType(EnumWrappers.getChatFormattingClass()).write(0, EnumWrappers.getChatFormattingConverter().getGeneric(this.color));
            wrapped.modifier.withType(Integer.TYPE).write(0, this.options);
            return wrapped;
        }
    }
}

