/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyClassContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedStreamCodec;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class PacketRegistry {
    private static volatile boolean INITIALIZED = false;
    protected static final Class<?> ENUM_PROTOCOL = MinecraftReflection.getEnumProtocolClass();
    protected static volatile Register REGISTER;
    private static final Object registryLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Object object = registryLock;
        synchronized (object) {
            INITIALIZED = false;
        }
    }

    public static synchronized void synchronize() {
        if (REGISTER.isOutdated()) {
            PacketRegistry.initialize();
        }
    }

    protected static synchronized Register createOldRegister() {
        ?[] protocols = ENUM_PROTOCOL.getEnumConstants();
        LinkedHashMap serverMaps = new LinkedHashMap();
        LinkedHashMap clientMaps = new LinkedHashMap();
        Register result = new Register();
        StructureModifier modifier = null;
        for (Object protocol : protocols) {
            if (modifier == null) {
                modifier = new StructureModifier(protocol.getClass().getSuperclass());
            }
            StructureModifier maps = modifier.withTarget(protocol).withType(Map.class);
            for (Map.Entry entry : ((Map)maps.read(0)).entrySet()) {
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, (Map)entry.getValue());
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, (Map)entry.getValue());
            }
        }
        for (Object map : serverMaps.values()) {
            result.addContainer(new MapContainer(map));
        }
        for (Object map : clientMaps.values()) {
            result.addContainer(new MapContainer(map));
        }
        for (Object protocol : protocols) {
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                PacketRegistry.associatePackets(result, (Map)serverMaps.get(protocol), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            PacketRegistry.associatePackets(result, (Map)clientMaps.get(protocol), equivalent, PacketType.Sender.CLIENT);
        }
        return result;
    }

    private static synchronized Register createRegisterV1_15_0() {
        ?[] protocols = ENUM_PROTOCOL.getEnumConstants();
        LinkedHashMap serverMaps = new LinkedHashMap();
        LinkedHashMap clientMaps = new LinkedHashMap();
        Register result = new Register();
        Field mainMapField = null;
        Field packetMapField = null;
        Field holderClassField = null;
        for (Object protocol : protocols) {
            Map directionMap;
            if (mainMapField == null) {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(protocol.getClass(), true);
                mainMapField = fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeDerivedOf(Map.class).build());
                mainMapField.setAccessible(true);
            }
            try {
                directionMap = (Map)mainMapField.get(protocol);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to access packet map", ex);
            }
            for (Map.Entry entry : directionMap.entrySet()) {
                Map packetMap;
                Object holder = entry.getValue();
                if (packetMapField == null) {
                    Class<?> packetHolderClass = holder.getClass();
                    if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
                        FuzzyReflection holderFuzzy = FuzzyReflection.fromClass(packetHolderClass, true);
                        holderClassField = holderFuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeMatches(FuzzyClassContract.newBuilder().method(FuzzyMethodContract.newBuilder().returnTypeExact(MinecraftReflection.getPacketClass()).parameterCount(2).parameterExactType(Integer.TYPE, 0).parameterExactType(MinecraftReflection.getPacketDataSerializerClass(), 1).build()).build()).build());
                        holderClassField.setAccessible(true);
                        packetHolderClass = holderClassField.getType();
                    }
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(packetHolderClass, true);
                    packetMapField = fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeDerivedOf(Map.class).build());
                    packetMapField.setAccessible(true);
                }
                Object holderInstance = holder;
                if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
                    try {
                        holderInstance = holderClassField.get(holder);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new RuntimeException("Failed to access packet map", ex);
                    }
                }
                try {
                    packetMap = (Map)packetMapField.get(holderInstance);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException("Failed to access packet map", ex);
                }
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, packetMap);
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, packetMap);
            }
        }
        for (Object protocol : protocols) {
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                PacketRegistry.associatePackets(result, PacketRegistry.reverse((Map)serverMaps.get(protocol)), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            PacketRegistry.associatePackets(result, PacketRegistry.reverse((Map)clientMaps.get(protocol)), equivalent, PacketType.Sender.CLIENT);
        }
        return result;
    }

    private static synchronized Register createRegisterV1_20_5() {
        ?[] protocols = ENUM_PROTOCOL.getEnumConstants();
        HashMap<Object, Class> packetTypeMap = new HashMap<Object, Class>();
        String[] packetTypesClassNames = new String[]{"common.CommonPacketTypes", "configuration.ConfigurationPacketTypes", "cookie.CookiePacketTypes", "game.GamePacketTypes", "handshake.HandshakePacketTypes", "login.LoginPacketTypes", "ping.PingPacketTypes", "status.StatusPacketTypes"};
        Class<?> packetTypeClass = MinecraftReflection.getMinecraftClass("network.protocol.PacketType");
        for (String packetTypesClassName : packetTypesClassNames) {
            Class packetTypesClass = MinecraftReflection.getOptionalNMS("network.protocol." + packetTypesClassName, new String[0]).orElse(null);
            if (packetTypesClass == null) {
                ProtocolLogger.debug("Can't find PacketType class: {0}, will skip it", packetTypesClassName);
                continue;
            }
            for (Field field : packetTypesClass.getDeclaredFields()) {
                try {
                    Type packet;
                    Object packetType;
                    if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !packetTypeClass.isInstance(packetType = field.get(null)) || !((packet = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    packetTypeMap.put(packetType, (Class)packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        LinkedHashMap serverMaps = new LinkedHashMap();
        LinkedHashMap clientMaps = new LinkedHashMap();
        Register result = new Register();
        String[] protocolClassNames = new String[]{"configuration.ConfigurationProtocols", "game.GameProtocols", "handshake.HandshakeProtocols", "login.LoginProtocols", "status.StatusProtocols"};
        Class<?> protocolInfoClass = MinecraftReflection.getProtocolInfoClass();
        Class<?> protocolInfoUnboundClass = MinecraftReflection.getProtocolInfoUnboundClass();
        Class<?> streamCodecClass = MinecraftReflection.getStreamCodecClass();
        Class<?> idCodecClass = MinecraftReflection.getMinecraftClass("network.codec.IdDispatchCodec");
        Class<?> idCodecEntryClass = MinecraftReflection.getMinecraftClass("network.codec.IdDispatchCodec$Entry", "network.codec.IdDispatchCodec$b");
        Class<?> protocolDirectionClass = MinecraftReflection.getPacketFlowClass();
        Function<Object, Object> emptyFunction = input -> input;
        FuzzyReflection protocolInfoReflection = FuzzyReflection.fromClass(protocolInfoClass);
        MethodAccessor protocolAccessor = Accessors.getMethodAccessor(protocolInfoReflection.getMethodByReturnTypeAndParameters("id", MinecraftReflection.getEnumProtocolClass(), new Class[0]));
        MethodAccessor directionAccessor = Accessors.getMethodAccessor(protocolInfoReflection.getMethodByReturnTypeAndParameters("flow", protocolDirectionClass, new Class[0]));
        MethodAccessor codecAccessor = Accessors.getMethodAccessor(protocolInfoReflection.getMethodByReturnTypeAndParameters("codec", streamCodecClass, new Class[0]));
        MethodAccessor bindAccessor = Accessors.getMethodAccessor(FuzzyReflection.fromClass(protocolInfoUnboundClass).getMethodByReturnTypeAndParameters("bind", protocolInfoClass, Function.class));
        FuzzyReflection idCodecReflection = FuzzyReflection.fromClass(idCodecClass, true);
        FieldAccessor byIdAccessor = Accessors.getFieldAccessor(idCodecReflection.getField(FuzzyFieldContract.newBuilder().typeDerivedOf(List.class).build()));
        FieldAccessor toIdAccessor = Accessors.getFieldAccessor(idCodecReflection.getField(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class).build()));
        FuzzyReflection idCodecEntryReflection = FuzzyReflection.fromClass(idCodecEntryClass, true);
        MethodAccessor idCodecEntryTypeAccessor = Accessors.getMethodAccessor(idCodecEntryReflection.getMethodByReturnTypeAndParameters("type", Object.class, new Class[0]));
        MethodAccessor idCodecEntrySerializerAccessor = Accessors.getMethodAccessor(idCodecEntryReflection.getMethodByReturnTypeAndParameters("serializer", streamCodecClass, new Class[0]));
        for (String protocolClassName : protocolClassNames) {
            Class protocolClass = MinecraftReflection.getOptionalNMS("network.protocol." + protocolClassName, new String[0]).orElse(null);
            if (protocolClass == null) {
                ProtocolLogger.debug("Can't find protocol class: {0}, will skip it", protocolClassName);
                continue;
            }
            for (Field field : protocolClass.getDeclaredFields()) {
                try {
                    Object codec;
                    if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                    Object protocolInfo = field.get(null);
                    if (protocolInfoUnboundClass.isInstance(protocolInfo)) {
                        protocolInfo = bindAccessor.invoke(protocolInfo, emptyFunction);
                    }
                    if (!protocolInfoClass.isInstance(protocolInfo) || !idCodecClass.isInstance(codec = codecAccessor.invoke(protocolInfo, new Object[0]))) continue;
                    HashMap<Class, Integer> packetMap = new HashMap<Class, Integer>();
                    List serializerList = (List)byIdAccessor.get(codec);
                    Map packetTypeIdMap = (Map)toIdAccessor.get(codec);
                    for (Map.Entry entry : packetTypeIdMap.entrySet()) {
                        Class packetClass = (Class)packetTypeMap.get(entry.getKey());
                        if (packetClass == null) {
                            throw new RuntimeException("packetType missing packet " + entry.getKey());
                        }
                        packetMap.put(packetClass, (Integer)entry.getValue());
                    }
                    for (Map.Entry entry : serializerList) {
                        Object packetType = idCodecEntryTypeAccessor.invoke(entry, new Object[0]);
                        Class packetClass = (Class)packetTypeMap.get(packetType);
                        if (packetClass == null) {
                            throw new RuntimeException("packetType missing packet " + packetType);
                        }
                        Object serializer = idCodecEntrySerializerAccessor.invoke(entry, new Object[0]);
                        result.classToCodec.put(packetClass, new WrappedStreamCodec(serializer));
                    }
                    Object protocol = protocolAccessor.invoke(protocolInfo, new Object[0]);
                    String direction = directionAccessor.invoke(protocolInfo, new Object[0]).toString();
                    if (direction.contains("CLIENTBOUND")) {
                        serverMaps.put(protocol, packetMap);
                        continue;
                    }
                    if (!direction.contains("SERVERBOUND")) continue;
                    clientMaps.put(protocol, packetMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (String protocol : protocols) {
            Enum enumProtocol = (Enum)((Object)protocol);
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                PacketRegistry.associatePackets(result, PacketRegistry.reverse((Map)serverMaps.get(protocol)), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            PacketRegistry.associatePackets(result, PacketRegistry.reverse((Map)clientMaps.get(protocol)), equivalent, PacketType.Sender.CLIENT);
        }
        return result;
    }

    private static <K, V> Map<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> newMap = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    protected static void associatePackets(Register register, Map<Integer, Class<?>> lookup, PacketType.Protocol protocol, PacketType.Sender sender) {
        for (Map.Entry<Integer, Class<?>> entry : lookup.entrySet()) {
            int packetId = entry.getKey();
            Class<?> packetClass = entry.getValue();
            PacketType type = PacketType.fromCurrent(protocol, sender, packetId, packetClass);
            try {
                register.registerPacket(type, packetClass, sender);
            }
            catch (Exception ex) {
                ProtocolLogger.debug("Encountered an exception associating packet " + type, ex);
            }
        }
    }

    private static void associate(PacketType type, Class<?> clazz) {
        if (clazz != null) {
            PacketRegistry.REGISTER.typeToClass.put(type, Optional.of(clazz));
            PacketRegistry.REGISTER.classToType.put(clazz, type);
        } else {
            PacketRegistry.REGISTER.typeToClass.put(type, Optional.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initialize() {
        if (INITIALIZED) {
            return;
        }
        Object object = registryLock;
        synchronized (object) {
            if (INITIALIZED) {
                return;
            }
            REGISTER = MinecraftVersion.v1_20_5.atOrAbove() ? PacketRegistry.createRegisterV1_20_5() : (MinecraftVersion.BEE_UPDATE.atOrAbove() ? PacketRegistry.createRegisterV1_15_0() : PacketRegistry.createOldRegister());
            INITIALIZED = true;
        }
    }

    @Nullable
    public static WrappedStreamCodec getStreamCodec(Class<?> packetClass) {
        PacketRegistry.initialize();
        return PacketRegistry.REGISTER.classToCodec.get(packetClass);
    }

    public static boolean isSupported(PacketType type) {
        PacketRegistry.initialize();
        return PacketRegistry.tryGetPacketClass(type).isPresent();
    }

    public static Set<PacketType> getServerPacketTypes() {
        PacketRegistry.initialize();
        PacketRegistry.synchronize();
        return Collections.unmodifiableSet(PacketRegistry.REGISTER.serverPackets);
    }

    public static Set<PacketType> getClientPacketTypes() {
        PacketRegistry.initialize();
        PacketRegistry.synchronize();
        return Collections.unmodifiableSet(PacketRegistry.REGISTER.clientPackets);
    }

    private static Class<?> searchForPacket(List<String> classNames) {
        for (String name : classNames) {
            try {
                Class<?> clazz = MinecraftReflection.getMinecraftClass(name);
                if (!MinecraftReflection.getPacketClass().isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                return clazz;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Deprecated
    public static Class<?> getPacketClassFromType(PacketType type, boolean forceVanilla) {
        return PacketRegistry.getPacketClassFromType(type);
    }

    public static Optional<Class<?>> tryGetPacketClass(PacketType type) {
        PacketRegistry.initialize();
        Optional<Class<?>> res = PacketRegistry.REGISTER.typeToClass.get(type);
        if (res != null) {
            if (res.isPresent() && MinecraftReflection.isBundleDelimiter(res.get())) {
                return MinecraftReflection.getPackedBundlePacketClass();
            }
            return res;
        }
        Class<?> clazz = PacketRegistry.searchForPacket(type.getClassNames());
        if (clazz != null) {
            ProtocolLogger.warnAbove(type.getCurrentVersion(), "Updating associated class for {0} to {1}", type.name(), clazz);
        }
        PacketRegistry.associate(type, clazz);
        if (clazz != null && MinecraftReflection.isBundleDelimiter(clazz)) {
            clazz = MinecraftReflection.getPackedBundlePacketClass().orElseThrow(() -> new IllegalStateException("Packet bundle class not found."));
        }
        return Optional.ofNullable(clazz);
    }

    public static Class<?> getPacketClassFromType(PacketType type) {
        return PacketRegistry.tryGetPacketClass(type).orElseThrow(() -> new IllegalArgumentException("Could not find packet for type " + type.name()));
    }

    @Deprecated
    public static PacketType getPacketType(Class<?> packet) {
        PacketRegistry.initialize();
        if (MinecraftReflection.isBundlePacket(packet)) {
            return PacketType.Play.Server.BUNDLE;
        }
        return PacketRegistry.REGISTER.classToType.get(packet);
    }

    public static PacketType getPacketType(PacketType.Protocol protocol, Class<?> packet) {
        PacketRegistry.initialize();
        if (MinecraftReflection.isBundlePacket(packet)) {
            return PacketType.Play.Server.BUNDLE;
        }
        if (!MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
            return PacketRegistry.getPacketType(packet);
        }
        Map<Class<?>, PacketType> classToTypesForProtocol = PacketRegistry.REGISTER.protocolClassToType.get((Object)protocol);
        return classToTypesForProtocol == null ? null : classToTypesForProtocol.get(packet);
    }

    @Deprecated
    public static PacketType getPacketType(Class<?> packet, PacketType.Sender sender) {
        return PacketRegistry.getPacketType(packet);
    }

    static {
        registryLock = new Object();
    }

    private static class Register {
        final Map<PacketType, Optional<Class<?>>> typeToClass = new ConcurrentHashMap();
        final Map<Class<?>, PacketType> classToType = new ConcurrentHashMap();
        final Map<Class<?>, WrappedStreamCodec> classToCodec = new ConcurrentHashMap();
        final Map<PacketType.Protocol, Map<Class<?>, PacketType>> protocolClassToType = new ConcurrentHashMap();
        volatile Set<PacketType> serverPackets = new HashSet<PacketType>();
        volatile Set<PacketType> clientPackets = new HashSet<PacketType>();
        final List<MapContainer> containers = new ArrayList<MapContainer>();

        public void registerPacket(PacketType type, Class<?> clazz, PacketType.Sender sender) {
            this.typeToClass.put(type, Optional.of(clazz));
            this.classToType.put(clazz, type);
            this.protocolClassToType.computeIfAbsent(type.getProtocol(), __ -> new ConcurrentHashMap()).put(clazz, type);
            if (sender == PacketType.Sender.CLIENT) {
                this.clientPackets.add(type);
            } else {
                this.serverPackets.add(type);
            }
        }

        public void addContainer(MapContainer container) {
            this.containers.add(container);
        }

        public boolean isOutdated() {
            for (MapContainer container : this.containers) {
                if (!container.hasChanged()) continue;
                return true;
            }
            return false;
        }
    }
}

