/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.ListenerManager;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.channel.EmptyInjector;
import com.comphenix.protocol.injector.netty.channel.NettyChannelInjector;
import com.comphenix.protocol.injector.temporary.TemporaryPlayerFactory;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.MapMaker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InjectionFactory {
    private final ConcurrentMap<String, Injector> nameLookup = new MapMaker().weakValues().makeMap();
    private final ConcurrentMap<Player, Injector> playerLookup = new MapMaker().weakKeys().weakValues().makeMap();
    private final Plugin plugin;
    private final ErrorReporter errorReporter;
    private final ListenerManager listenerManager;
    private boolean closed;

    public InjectionFactory(Plugin plugin, ErrorReporter errorReporter, ListenerManager listenerManager) {
        this.plugin = plugin;
        this.errorReporter = errorReporter;
        this.listenerManager = listenerManager;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public Injector fromPlayer(Player player) {
        if (this.closed) {
            return new EmptyInjector(player);
        }
        Injector injector = (Injector)this.playerLookup.get(player);
        if (injector == null) {
            injector = this.getTemporaryInjector(player);
        }
        if (injector != null && !injector.isClosed()) {
            return injector;
        }
        Object networkManager = MinecraftFields.getNetworkManager(player);
        if (networkManager == null) {
            return this.fromName(player.getName(), player);
        }
        Channel channel = FuzzyReflection.getFieldValue(networkManager, Channel.class, true);
        injector = NettyChannelInjector.findInjector(channel);
        if (injector != null) {
            if (injector.getPlayer() != player || !this.playerLookup.containsKey(player)) {
                this.playerLookup.remove(injector.getPlayer());
                this.cacheInjector(player, injector);
                injector.setPlayer(player);
            }
        } else {
            injector = new NettyChannelInjector(player, networkManager, channel, this.listenerManager, this, this.errorReporter);
            this.cacheInjector(player, injector);
        }
        return injector;
    }

    public Injector fromName(String name, Player player) {
        if (this.closed) {
            return new EmptyInjector(player);
        }
        Injector injector = (Injector)this.nameLookup.get(name);
        if (injector != null) {
            injector.setPlayer(player);
            return injector;
        }
        return new EmptyInjector(player);
    }

    @Nonnull
    public Injector fromChannel(Channel channel) {
        if (this.closed) {
            return EmptyInjector.WITHOUT_PLAYER;
        }
        Object networkManager = this.findNetworkManager(channel);
        Player temporaryPlayer = TemporaryPlayerFactory.createTemporaryPlayer();
        NettyChannelInjector injector = new NettyChannelInjector(temporaryPlayer, networkManager, channel, this.listenerManager, this, this.errorReporter);
        TemporaryPlayerFactory.setInjectorForPlayer(temporaryPlayer, injector);
        return injector;
    }

    public Injector invalidate(Player player, String name) {
        Injector injector = null;
        if (name != null) {
            injector = (Injector)this.nameLookup.remove(name);
        }
        if (player != null) {
            injector = (Injector)this.playerLookup.remove(player);
        }
        return injector;
    }

    public Injector cacheInjector(Player player, Injector injector) {
        this.nameLookup.put(player.getName(), injector);
        return this.playerLookup.put(player, injector);
    }

    public Injector cacheInjector(String name, Injector injector) {
        return this.nameLookup.put(name, injector);
    }

    private NettyChannelInjector getTemporaryInjector(Player player) {
        Injector injector = TemporaryPlayerFactory.getInjectorFromPlayer(player);
        if (injector instanceof NettyChannelInjector) {
            return (NettyChannelInjector)injector;
        }
        return null;
    }

    private Object findNetworkManager(Channel channel) {
        Class<?> networkManagerClass = MinecraftReflection.getNetworkManagerClass();
        for (Map.Entry entry : channel.pipeline()) {
            if (!networkManagerClass.isAssignableFrom(((ChannelHandler)entry.getValue()).getClass())) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Unable to find NetworkManager in " + channel);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (Injector injector : this.playerLookup.values()) {
                injector.close();
            }
            for (Injector injector : this.nameLookup.values()) {
                injector.close();
            }
        }
    }
}

