/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.CommandFilter;
import com.comphenix.protocol.CommandPacket;
import com.comphenix.protocol.CommandProtocol;
import com.comphenix.protocol.PacketLogging;
import com.comphenix.protocol.ProtocolConfig;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.async.AsyncFilterManager;
import com.comphenix.protocol.error.BasicErrorReporter;
import com.comphenix.protocol.error.DelegatedErrorReporter;
import com.comphenix.protocol.error.DetailedErrorReporter;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.InternalManager;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.metrics.Statistics;
import com.comphenix.protocol.scheduler.DefaultScheduler;
import com.comphenix.protocol.scheduler.FoliaScheduler;
import com.comphenix.protocol.scheduler.ProtocolScheduler;
import com.comphenix.protocol.scheduler.Task;
import com.comphenix.protocol.updater.Updater;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.ChatExtensions;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.utility.Util;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ProtocolLib
extends JavaPlugin {
    public static final ReportType REPORT_CANNOT_DELETE_CONFIG = new ReportType("Cannot delete old ProtocolLib configuration.");
    public static final ReportType REPORT_PLUGIN_LOAD_ERROR = new ReportType("Cannot load ProtocolLib.");
    public static final ReportType REPORT_CANNOT_LOAD_CONFIG = new ReportType("Cannot load configuration");
    public static final ReportType REPORT_PLUGIN_ENABLE_ERROR = new ReportType("Cannot enable ProtocolLib.");
    public static final ReportType REPORT_METRICS_IO_ERROR = new ReportType("Unable to enable metrics due to network problems.");
    public static final ReportType REPORT_METRICS_GENERIC_ERROR = new ReportType("Unable to enable metrics due to network problems.");
    public static final ReportType REPORT_CANNOT_PARSE_MINECRAFT_VERSION = new ReportType("Unable to retrieve current Minecraft version. Assuming %s");
    public static final ReportType REPORT_CANNOT_REGISTER_COMMAND = new ReportType("Cannot register command %s: %s");
    public static final ReportType REPORT_CANNOT_CREATE_TIMEOUT_TASK = new ReportType("Unable to create packet timeout task.");
    public static final ReportType REPORT_CANNOT_UPDATE_PLUGIN = new ReportType("Cannot perform automatic updates.");
    static final long MILLI_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final int ASYNC_MANAGER_DELAY = 1;
    private static final String PERMISSION_INFO = "protocol.info";
    private static Logger logger;
    private static ProtocolConfig config;
    private static InternalManager protocolManager;
    private static ErrorReporter reporter;
    private Statistics statistics;
    private Task packetTask = null;
    private int tickCounter = 0;
    private int configExpectedMod = -1;
    private Updater updater;
    private Handler redirectHandler;
    private ProtocolScheduler scheduler;
    private CommandProtocol commandProtocol;
    private CommandPacket commandPacket;
    private CommandFilter commandFilter;
    private PacketLogging packetLogging;
    private boolean skipDisable;

    public void onLoad() {
        logger = this.getLogger();
        ProtocolLogger.init(this);
        ByteBuddyFactory.getInstance().setClassLoader(this.getClassLoader());
        DetailedErrorReporter detailedReporter = new DetailedErrorReporter((Plugin)this);
        reporter = this.getFilteredReporter(detailedReporter);
        this.saveDefaultConfig();
        this.reloadConfig();
        try {
            config = new ProtocolConfig((Plugin)this);
        }
        catch (Exception exception) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_LOAD_CONFIG).error(exception));
            if (this.deleteConfig()) {
                config = new ProtocolConfig((Plugin)this);
            }
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_DELETE_CONFIG));
        }
        if (config.isDebug()) {
            logger.warning("Debug mode is enabled!");
        }
        if (config.isDetailedErrorReporting()) {
            detailedReporter.setDetailedReporting(true);
            logger.warning("Detailed error reporting enabled!");
        }
        try {
            this.scheduler = Util.isUsingFolia() ? new FoliaScheduler((Plugin)this) : new DefaultScheduler((Plugin)this);
            this.scanForOtherProtocolLibJars();
            MinecraftVersion version = this.verifyMinecraftVersion();
            this.updater = Updater.create((Plugin)this, 0, this.getFile(), Updater.UpdateType.NO_DOWNLOAD, true);
            protocolManager = PacketFilterManager.newBuilder().server(this.getServer()).library(this).minecraftVersion(version).reporter(reporter).build();
            ProtocolLibrary.init((Plugin)this, config, protocolManager, this.scheduler, reporter);
            detailedReporter.addGlobalParameter("manager", protocolManager);
            this.initializeCommands();
            this.setupBroadcastUsers(PERMISSION_INFO);
        }
        catch (Exception e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_PLUGIN_LOAD_ERROR).error(e).callerParam(protocolManager));
            this.disablePlugin();
        }
    }

    private void initializeCommands() {
        for (ProtocolCommand command : ProtocolCommand.values()) {
            try {
                switch (command.ordinal()) {
                    case 2: {
                        this.commandProtocol = new CommandProtocol(reporter, (Plugin)this, this.updater, config);
                        break;
                    }
                    case 0: {
                        this.commandFilter = new CommandFilter(reporter, (Plugin)this, config);
                        break;
                    }
                    case 1: {
                        this.commandPacket = new CommandPacket(reporter, (Plugin)this, logger, this.commandFilter, protocolManager);
                        break;
                    }
                    case 3: {
                        this.packetLogging = new PacketLogging((Plugin)this, protocolManager);
                    }
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (LinkageError e) {
                logger.warning("Failed to register command " + command.name() + ": " + e);
            }
            catch (Throwable e) {
                reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_REGISTER_COMMAND).messageParam(command.name(), e.getMessage()).error(e));
            }
        }
    }

    private ErrorReporter getFilteredReporter(ErrorReporter reporter) {
        return new DelegatedErrorReporter(reporter){
            private int lastModCount;
            private Set<String> reports;
            {
                this.lastModCount = -1;
                this.reports = new HashSet<String>();
            }

            @Override
            protected Report filterReport(Object sender, Report report, boolean detailed) {
                try {
                    String canonicalName = ReportType.getReportName(sender, report.getType());
                    String reportName = ((String)Iterables.getLast((Iterable)Splitter.on((String)"#").split((CharSequence)canonicalName))).toUpperCase();
                    if (config != null && config.getModificationCount() != this.lastModCount) {
                        this.reports = new HashSet<String>((Collection<String>)config.getSuppressedReports());
                        this.lastModCount = config.getModificationCount();
                    }
                    if (this.reports.contains(canonicalName) || this.reports.contains(reportName)) {
                        return null;
                    }
                }
                catch (Exception e) {
                    logger.warning("Error filtering reports: " + e);
                }
                return report;
            }
        };
    }

    private boolean deleteConfig() {
        return config.getFile().delete();
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (config != null) {
            config.reloadConfig();
        }
    }

    private void setupBroadcastUsers(final String permission) {
        if (this.redirectHandler != null) {
            return;
        }
        this.redirectHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                    ProtocolLib.this.commandPacket.broadcastMessageSilently(record.getMessage(), permission);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        logger.addHandler(this.redirectHandler);
    }

    private void highlyVisibleError(String ... lines) {
        Logger directLogging = Logger.getLogger("Minecraft");
        for (String line : ChatExtensions.toFlowerBox(lines, "*", 3, 1)) {
            directLogging.severe(line);
        }
    }

    public void onEnable() {
        try {
            Server server = this.getServer();
            PluginManager manager = server.getPluginManager();
            if (protocolManager == null) {
                this.highlyVisibleError(" ProtocolLib does not support plugin reloaders! ", " Please use the built-in reload command! ");
                this.disablePlugin();
                return;
            }
            this.registerCommand("protocol", this.commandProtocol);
            this.registerCommand("packet", this.commandPacket);
            this.registerCommand("filter", this.commandFilter);
            this.registerCommand("packetlog", this.packetLogging);
            protocolManager.registerEvents(manager, (Plugin)this);
            this.createPacketTask(server);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_PLUGIN_ENABLE_ERROR).error(e));
            this.disablePlugin();
            return;
        }
        try {
            if (config.isMetricsEnabled()) {
                this.statistics = new Statistics(this);
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (IOException e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_METRICS_IO_ERROR).error(e).callerParam(this.statistics));
        }
        catch (Throwable e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_METRICS_GENERIC_ERROR).error(e).callerParam(this.statistics));
        }
    }

    private MinecraftVersion verifyMinecraftVersion() {
        MinecraftVersion minimum = new MinecraftVersion("1.8");
        MinecraftVersion maximum = new MinecraftVersion("1.21.1");
        try {
            MinecraftVersion current = new MinecraftVersion(this.getServer());
            if (!config.getIgnoreVersionCheck().equals(current.getVersion())) {
                if (current.compareTo(minimum) < 0) {
                    logger.warning("Version " + current + " is lower than the minimum " + minimum);
                }
                if (current.compareTo(maximum) > 0) {
                    logger.warning("Version " + current + " has not yet been tested! Proceed with caution.");
                }
            }
            return current;
        }
        catch (Exception e) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_PARSE_MINECRAFT_VERSION).error(e).messageParam(maximum));
            return maximum;
        }
    }

    private void scanForOtherProtocolLibJars() {
        try {
            File loadedFile = this.getFile();
            File pluginFolder = this.getDataFolder().getParentFile();
            File[] candidates = pluginFolder.listFiles();
            if (candidates == null) {
                return;
            }
            String ourName = loadedFile.getName();
            ArrayList<String> others = new ArrayList<String>();
            for (File candidate : candidates) {
                String jarNameLower;
                String jarName;
                if (!candidate.isFile() || (jarName = candidate.getName()).equals(ourName) || !(jarNameLower = candidate.getName().toLowerCase()).startsWith("protocollib") || !jarNameLower.endsWith(".jar")) continue;
                others.add(jarName);
            }
            if (!others.isEmpty()) {
                this.highlyVisibleError(" Detected multiple ProtocolLib JAR files in the plugin directory! ", " You should remove all but one of them or there will likely be undesired behavior. ", " This JAR: " + loadedFile.getName(), " Other detected JARs: " + String.join((CharSequence)",", others));
            }
        }
        catch (Exception ex) {
            ProtocolLogger.debug("Failed to scan plugins directory for ProtocolLib jars", ex);
        }
    }

    private void registerCommand(String name, CommandExecutor executor) {
        try {
            if (executor == null) {
                return;
            }
            PluginCommand command = this.getCommand(name);
            if (command == null) {
                throw new RuntimeException("plugin.yml might be corrupt.");
            }
            command.setExecutor(executor);
        }
        catch (RuntimeException e) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_REGISTER_COMMAND).messageParam(name, e.getMessage()).error(e));
        }
    }

    private void disablePlugin() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    private void createPacketTask(Server server) {
        block4: {
            try {
                if (this.packetTask != null) {
                    throw new IllegalStateException("Packet task has already been created");
                }
                this.packetTask = this.scheduler.scheduleSyncRepeatingTask(() -> {
                    AsyncFilterManager manager = (AsyncFilterManager)protocolManager.getAsynchronousManager();
                    manager.sendProcessedPackets(this.tickCounter++, true);
                    this.updateConfiguration();
                    if (!ProtocolLibrary.updatesDisabled() && this.tickCounter % 20 == 0) {
                        this.checkUpdates();
                    }
                }, 1L, 1L);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                if (this.packetTask != null) break block4;
                reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_CREATE_TIMEOUT_TASK).error(e));
            }
        }
    }

    private void updateConfiguration() {
        if (config != null && config.getModificationCount() != this.configExpectedMod) {
            this.configExpectedMod = config.getModificationCount();
            protocolManager.setDebug(config.isDebug());
        }
    }

    private void checkUpdates() {
        long currentTime = System.currentTimeMillis() / MILLI_PER_SECOND;
        try {
            long updateTime = config.getAutoLastTime() + config.getAutoDelay();
            if (currentTime > updateTime && !this.updater.isChecking()) {
                if (config.isAutoDownload()) {
                    this.commandProtocol.updateVersion((CommandSender)this.getServer().getConsoleSender(), false);
                } else if (config.isAutoNotify()) {
                    this.commandProtocol.checkVersion((CommandSender)this.getServer().getConsoleSender(), false);
                } else {
                    this.commandProtocol.updateFinished();
                }
            }
        }
        catch (Exception e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_UPDATE_PLUGIN).error(e));
            ProtocolLibrary.disableUpdates();
        }
    }

    public void onDisable() {
        if (this.skipDisable) {
            return;
        }
        if (Util.isCurrentlyReloading()) {
            this.highlyVisibleError(" WARNING ", " RELOADING THE SERVER WHILE PROTOCOLLIB IS ENABLED MIGHT ", " LEAD TO UNEXPECTED ERRORS! ", " ", " Consider cleanly restarting your server if you encounter ", " any issues related to ProtocolLib before opening an issue ", " on GitHub! ");
        }
        if (this.packetTask != null) {
            this.packetTask.cancel();
            this.packetTask = null;
        }
        if (this.redirectHandler != null) {
            logger.removeHandler(this.redirectHandler);
        }
        if (protocolManager == null) {
            return;
        }
        protocolManager.close();
        protocolManager = null;
        this.statistics = null;
        reporter = new BasicErrorReporter();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public ProtocolConfig getProtocolConfig() {
        return config;
    }

    public ProtocolScheduler getScheduler() {
        return this.scheduler;
    }

    static {
        reporter = new BasicErrorReporter();
    }

    private static enum ProtocolCommand {
        FILTER,
        PACKET,
        PROTOCOL,
        LOGGING;

    }
}

