/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt.io;

import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.comphenix.protocol.wrappers.nbt.NbtVisitor;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class NbtConfigurationSerializer {
    public static final String TYPE_DELIMITER = "$";
    public static final NbtConfigurationSerializer DEFAULT = new NbtConfigurationSerializer();
    private String dataTypeDelimiter;

    public NbtConfigurationSerializer() {
        this.dataTypeDelimiter = TYPE_DELIMITER;
    }

    public NbtConfigurationSerializer(String dataTypeDelimiter) {
        this.dataTypeDelimiter = dataTypeDelimiter;
    }

    public String getDataTypeDelimiter() {
        return this.dataTypeDelimiter;
    }

    public <TType> void serialize(NbtBase<TType> value, final ConfigurationSection destination) {
        value.accept(new NbtVisitor(){
            private ConfigurationSection current;
            private List<Object> currentList;
            private Map<ConfigurationSection, Integer> workingIndex;
            {
                this.current = destination;
                this.workingIndex = new HashMap<ConfigurationSection, Integer>();
            }

            @Override
            public boolean visitEnter(NbtCompound compound) {
                this.current = this.current.createSection(compound.getName());
                return true;
            }

            @Override
            public boolean visitEnter(NbtList<?> list) {
                Integer listIndex = this.getNextIndex();
                String name = this.getEncodedName(list, listIndex);
                if (list.getElementType().isComposite()) {
                    this.current = this.current.createSection(name);
                    this.workingIndex.put(this.current, 0);
                } else {
                    this.currentList = new ArrayList<Object>();
                    this.current.set(name, this.currentList);
                }
                return true;
            }

            @Override
            public boolean visitLeave(NbtCompound compound) {
                this.current = this.current.getParent();
                return true;
            }

            @Override
            public boolean visitLeave(NbtList<?> list) {
                if (this.currentList != null) {
                    this.currentList = null;
                } else {
                    this.workingIndex.remove(this.current);
                    this.current = this.current.getParent();
                }
                return true;
            }

            @Override
            public boolean visit(NbtBase<?> node) {
                if (this.currentList == null) {
                    Integer listIndex = this.getNextIndex();
                    String name = this.getEncodedName(node, listIndex);
                    this.current.set(name, NbtConfigurationSerializer.this.fromNodeValue(node));
                } else {
                    this.currentList.add(NbtConfigurationSerializer.this.fromNodeValue(node));
                }
                return true;
            }

            private Integer getNextIndex() {
                Integer listIndex = this.workingIndex.get(this.current);
                if (listIndex != null) {
                    return this.workingIndex.put(this.current, listIndex + 1);
                }
                return null;
            }

            private String getEncodedName(NbtBase<?> node, Integer index) {
                if (index != null) {
                    return index + NbtConfigurationSerializer.this.dataTypeDelimiter + node.getType().getRawID();
                }
                return node.getName() + NbtConfigurationSerializer.this.dataTypeDelimiter + node.getType().getRawID();
            }

            private String getEncodedName(NbtList<?> node, Integer index) {
                if (index != null) {
                    return index + NbtConfigurationSerializer.this.dataTypeDelimiter + node.getElementType().getRawID();
                }
                return node.getName() + NbtConfigurationSerializer.this.dataTypeDelimiter + node.getElementType().getRawID();
            }
        });
    }

    public <TType> NbtWrapper<TType> deserialize(ConfigurationSection root, String nodeName) {
        return this.readNode(root, nodeName);
    }

    public NbtCompound deserializeCompound(YamlConfiguration root, String nodeName) {
        return (NbtCompound)((Object)this.readNode((ConfigurationSection)root, nodeName));
    }

    public <T> NbtList<T> deserializeList(YamlConfiguration root, String nodeName) {
        return (NbtList)((Object)this.readNode((ConfigurationSection)root, nodeName));
    }

    private NbtWrapper<?> readNode(ConfigurationSection parent, String name) {
        NbtList<Object> list;
        String[] decoded = NbtConfigurationSerializer.getDecodedName(name);
        Object node = parent.get(name);
        NbtType type = NbtType.TAG_END;
        if (node == null) {
            for (String key : parent.getKeys(false)) {
                decoded = NbtConfigurationSerializer.getDecodedName(key);
                if (!decoded[0].equals(name)) continue;
                node = parent.get(decoded[0]);
                break;
            }
            if (node == null) {
                throw new IllegalArgumentException("Unable to find node " + name + " in " + parent);
            }
        }
        if (decoded.length > 1) {
            type = NbtType.getTypeFromID(Integer.parseInt(decoded[1]));
        }
        if (node instanceof ConfigurationSection) {
            ConfigurationSection section;
            if (type != NbtType.TAG_END) {
                list = NbtFactory.ofList(decoded[0], new Object[0]);
                section = (ConfigurationSection)node;
                List<String> sorted = this.sortSet(section.getKeys(false));
                for (String key : sorted) {
                    NbtWrapper<?> base = this.readNode(section, key.toString());
                    base.setName("");
                    ((List)list.getValue()).add(base);
                }
                return (NbtWrapper)((Object)list);
            }
            NbtCompound compound = NbtFactory.ofCompound(decoded[0]);
            section = (ConfigurationSection)node;
            for (String key : section.getKeys(false)) {
                compound.put(this.readNode(section, key));
            }
            return (NbtWrapper)((Object)compound);
        }
        if (type == NbtType.TAG_END) {
            throw new IllegalArgumentException("Cannot find encoded type of " + decoded[0] + " in " + name);
        }
        if (node instanceof List) {
            list = NbtFactory.ofList(decoded[0], new Object[0]);
            list.setElementType(type);
            for (Object value : (List)node) {
                list.addClosest(this.toNodeValue(value, type));
            }
            return (NbtWrapper)((Object)list);
        }
        return NbtFactory.ofWrapper(type, decoded[0], this.toNodeValue(node, type));
    }

    private List<String> sortSet(Set<String> unsorted) {
        ArrayList<String> sorted = new ArrayList<String>(unsorted);
        sorted.sort((o1, o2) -> Ints.compare((int)Integer.parseInt(NbtConfigurationSerializer.getDecodedName(o1)[0]), (int)Integer.parseInt(NbtConfigurationSerializer.getDecodedName(o2)[0])));
        return sorted;
    }

    private Object fromNodeValue(NbtBase<?> base) {
        if (base.getType() == NbtType.TAG_INT_ARRAY) {
            return NbtConfigurationSerializer.toByteArray((int[])base.getValue());
        }
        return base.getValue();
    }

    public Object toNodeValue(Object value, NbtType type) {
        if (type == NbtType.TAG_INT_ARRAY) {
            return NbtConfigurationSerializer.toIntegerArray((byte[])value);
        }
        return value;
    }

    private static byte[] toByteArray(int[] data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(data);
        return byteBuffer.array();
    }

    private static int[] toIntegerArray(byte[] data) {
        IntBuffer source = ByteBuffer.wrap(data).asIntBuffer();
        IntBuffer copy = IntBuffer.allocate(source.capacity());
        copy.put(source);
        return copy.array();
    }

    private static String[] getDecodedName(String nodeName) {
        int delimiter = nodeName.lastIndexOf(36);
        if (delimiter > 0) {
            return new String[]{nodeName.substring(0, delimiter), nodeName.substring(delimiter + 1)};
        }
        return new String[]{nodeName};
    }
}

