/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import org.bukkit.block.BlockState;

class TileEntityAccessor<T extends BlockState> {
    private static final boolean BLOCK_DATA_INCL = MinecraftVersion.NETHER_UPDATE.atOrAbove() && !MinecraftVersion.CAVES_CLIFFS_1.atOrAbove();
    private static final TileEntityAccessor<BlockState> EMPTY_ACCESSOR = new TileEntityAccessor();
    private static final Map<Class<?>, TileEntityAccessor<?>> cachedAccessors = new HashMap();
    private static Constructor<?> nbtCompoundParserConstructor;
    private FieldAccessor tileEntityField;
    private MethodAccessor readCompound;
    private MethodAccessor writeCompound;

    TileEntityAccessor() {
    }

    private TileEntityAccessor(FieldAccessor tileEntityField, T state) {
        if (tileEntityField != null) {
            this.tileEntityField = tileEntityField;
            Class<?> type = tileEntityField.getField().getType();
            this.findMethods(type, state);
        }
    }

    public static <T extends BlockState> TileEntityAccessor<T> getAccessor(T state) {
        Class<?> craftBlockState = state.getClass();
        TileEntityAccessor<Object> accessor = cachedAccessors.get(craftBlockState);
        if (accessor == null) {
            TileEntityAccessor<Object> created = null;
            FieldAccessor field = null;
            try {
                field = Accessors.getFieldAccessor(craftBlockState, MinecraftReflection.getTileEntityClass(), true);
            }
            catch (Exception e) {
                created = EMPTY_ACCESSOR;
            }
            if (field != null) {
                created = new TileEntityAccessor<T>(field, state);
            }
            if ((accessor = cachedAccessors.putIfAbsent(craftBlockState, created)) == null) {
                accessor = created;
            }
        }
        return accessor != EMPTY_ACCESSOR ? accessor : null;
    }

    void findMethods(Class<?> type, T state) {
        if (BLOCK_DATA_INCL) {
            Class<?> tileEntityClass = MinecraftReflection.getTileEntityClass();
            Class<?> iBlockData = MinecraftReflection.getIBlockDataClass();
            Class<?> nbtCompound = MinecraftReflection.getNBTCompoundClass();
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(tileEntityClass, false);
            this.writeCompound = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterExactArray(iBlockData, nbtCompound).build()));
            this.readCompound = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(nbtCompound).parameterExactArray(nbtCompound).build()));
        }
        try {
            this.findMethodsUsingASM();
        }
        catch (IOException exception) {
            throw new RuntimeException("Cannot find read/write methods in " + type, exception);
        }
        if (this.readCompound == null) {
            throw new RuntimeException("Unable to find read method in " + type);
        }
        if (this.writeCompound == null) {
            throw new RuntimeException("Unable to find write method in " + type);
        }
    }

    private void findMethodsUsingASM() throws IOException {
        final Class<?> tileEntityClass = MinecraftReflection.getTileEntityClass();
        final Class<?> nbtCompoundClass = MinecraftReflection.getNBTCompoundClass();
        final String tagCompoundName = Type.getInternalName(nbtCompoundClass);
        final String expectedDesc = "(L" + tagCompoundName + ";)";
        ClassReader reader = new ClassReader(tileEntityClass.getCanonicalName());
        reader.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
                if (desc.startsWith(expectedDesc)) {
                    return new MethodVisitor(589824){
                        private int readMethods;
                        private int writeMethods;

                        public void visitMethodInsn(int opcode, String owner, String name2, String desc, boolean isInterface) {
                            if (opcode == 182 && tagCompoundName.equals(owner) && desc.startsWith("(Ljava/lang/String")) {
                                if (desc.endsWith(")V")) {
                                    ++this.writeMethods;
                                } else {
                                    ++this.readMethods;
                                }
                            }
                        }

                        public void visitEnd() {
                            if (this.readMethods > this.writeMethods) {
                                TileEntityAccessor.this.readCompound = Accessors.getMethodAccessor(tileEntityClass, name, nbtCompoundClass);
                            } else if (this.writeMethods > this.readMethods) {
                                TileEntityAccessor.this.writeCompound = Accessors.getMethodAccessor(tileEntityClass, name, nbtCompoundClass);
                            }
                            super.visitEnd();
                        }
                    };
                }
                return null;
            }
        }, 0);
    }

    public NbtCompound readBlockState(T state) {
        NbtCompound output = NbtFactory.ofCompound("");
        Object tileEntity = this.tileEntityField.get(state);
        this.writeCompound.invoke(tileEntity, NbtFactory.fromBase(output).getHandle());
        return output;
    }

    public void writeBlockState(T state, NbtCompound compound) {
        Object tileEntity = this.tileEntityField.get(state);
        if (BLOCK_DATA_INCL) {
            Object blockData = BukkitUnwrapper.getInstance().unwrapItem(state);
            this.readCompound.invoke(tileEntity, blockData, NbtFactory.fromBase(compound).getHandle());
        } else {
            this.readCompound.invoke(tileEntity, NbtFactory.fromBase(compound).getHandle());
        }
    }
}

