/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.Util;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SchedulerUtil {
    private Object foliaScheduler;
    private MethodAccessor runAtFixedRate;
    private MethodAccessor cancelTasks;
    private MethodAccessor execute;

    private static SchedulerUtil getInstance() {
        return Holder.INSTANCE;
    }

    private SchedulerUtil() {
        if (Util.isUsingFolia()) {
            MethodAccessor getScheduler = Accessors.getMethodAccessor(Bukkit.getServer().getClass(), "getGlobalRegionScheduler", new Class[0]);
            this.foliaScheduler = getScheduler.invoke(Bukkit.getServer(), new Object[0]);
            this.runAtFixedRate = Accessors.getMethodAccessor(this.foliaScheduler.getClass(), "runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
            this.cancelTasks = Accessors.getMethodAccessor(this.foliaScheduler.getClass(), "cancelTasks", Plugin.class);
            this.execute = Accessors.getMethodAccessor(this.foliaScheduler.getClass(), "execute", Plugin.class, Runnable.class);
        }
    }

    public static int scheduleSyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        return SchedulerUtil.getInstance().doScheduleSyncRepeatingTask(plugin, runnable, delay, period);
    }

    private int doScheduleSyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        if (Util.isUsingFolia()) {
            this.runAtFixedRate.invoke(this.foliaScheduler, plugin, task -> runnable.run(), delay, period);
            return 1;
        }
        return plugin.getServer().getScheduler().scheduleSyncRepeatingTask(plugin, runnable, delay, period);
    }

    private void doCancelTask(Plugin plugin, int id) {
        if (Util.isUsingFolia()) {
            this.cancelTasks.invoke(this.foliaScheduler, plugin);
        } else {
            plugin.getServer().getScheduler().cancelTask(id);
        }
    }

    public static void cancelTask(Plugin plugin, int id) {
        SchedulerUtil.getInstance().doCancelTask(plugin, id);
    }

    private void doExecute(Plugin plugin, Runnable runnable) {
        if (Util.isUsingFolia()) {
            this.execute.invoke(this.foliaScheduler, plugin, runnable);
        } else {
            plugin.getServer().getScheduler().scheduleSyncDelayedTask(plugin, runnable);
        }
    }

    public static void execute(Plugin plugin, Runnable runnable) {
        SchedulerUtil.getInstance().doExecute(plugin, runnable);
    }

    private static class Holder {
        private static final SchedulerUtil INSTANCE = new SchedulerUtil();

        private Holder() {
        }
    }
}

