/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.ProtocolConfig;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.error.BasicErrorReporter;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.scheduler.ProtocolScheduler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;

public class ProtocolLibrary {
    public static final String MINIMUM_MINECRAFT_VERSION = "1.8";
    public static final String MAXIMUM_MINECRAFT_VERSION = "1.20.1";
    public static final String MINECRAFT_LAST_RELEASE_DATE = "2023-06-12";
    public static final List<String> INCOMPATIBLE = ImmutableList.of((Object)"TagAPI");
    private static Plugin plugin;
    private static ProtocolConfig config;
    private static ProtocolManager manager;
    private static ProtocolScheduler scheduler;
    private static ErrorReporter reporter;
    private static boolean updatesDisabled;
    private static boolean initialized;

    protected static void init(Plugin plugin, ProtocolConfig config, ProtocolManager manager, ProtocolScheduler scheduler, ErrorReporter reporter) {
        Validate.isTrue((!initialized ? 1 : 0) != 0, (String)"ProtocolLib has already been initialized.");
        ProtocolLibrary.plugin = plugin;
        ProtocolLibrary.config = config;
        ProtocolLibrary.manager = manager;
        ProtocolLibrary.reporter = reporter;
        ProtocolLibrary.scheduler = scheduler;
        initialized = true;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static ProtocolConfig getConfig() {
        return config;
    }

    public static ProtocolManager getProtocolManager() {
        return manager;
    }

    public static ProtocolScheduler getScheduler() {
        return scheduler;
    }

    public static ErrorReporter getErrorReporter() {
        return reporter;
    }

    public static void disableUpdates() {
        updatesDisabled = true;
    }

    public static boolean updatesDisabled() {
        return updatesDisabled;
    }

    static {
        reporter = new BasicErrorReporter();
    }
}

