/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ExactMatchConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

class MultipleLinesPrompt
extends StringPrompt {
    private static final String KEY = "multiple_lines_prompt";
    private static final String KEY_LAST = "multiple_lines_prompt.last_line";
    private static final String KEY_LINES = "multiple_lines_prompt.linecount";
    private final MultipleConversationCanceller endMarker;
    private final String initialPrompt;

    public String removeAccumulatedInput(ConversationContext context) {
        Object result = context.getSessionData((Object)KEY);
        if (result instanceof StringBuilder) {
            context.setSessionData((Object)KEY, null);
            context.setSessionData((Object)KEY_LINES, null);
            return ((StringBuilder)result).toString();
        }
        return null;
    }

    public MultipleLinesPrompt(String endMarker, String initialPrompt) {
        this((ConversationCanceller)new ExactMatchConversationCanceller(endMarker), initialPrompt);
    }

    public MultipleLinesPrompt(ConversationCanceller endMarker, String initialPrompt) {
        this.endMarker = new MultipleWrapper(endMarker);
        this.initialPrompt = initialPrompt;
    }

    public MultipleLinesPrompt(MultipleConversationCanceller endMarker, String initialPrompt) {
        this.endMarker = endMarker;
        this.initialPrompt = initialPrompt;
    }

    public Prompt acceptInput(ConversationContext context, String in) {
        StringBuilder result = (StringBuilder)context.getSessionData((Object)KEY);
        Integer count = (Integer)context.getSessionData((Object)KEY_LINES);
        if (result == null) {
            result = new StringBuilder();
            context.setSessionData((Object)KEY, (Object)result);
        }
        if (count == null) {
            count = 0;
        }
        context.setSessionData((Object)KEY_LAST, (Object)in);
        count = count + 1;
        context.setSessionData((Object)KEY_LINES, (Object)count);
        result.append(in + "\n");
        if (this.endMarker.cancelBasedOnInput(context, in, result, count)) {
            return Prompt.END_OF_CONVERSATION;
        }
        return this;
    }

    public String getPromptText(ConversationContext context) {
        Object last = context.getSessionData((Object)KEY_LAST);
        if (last instanceof String) {
            return (String)last;
        }
        return this.initialPrompt;
    }

    private static class MultipleWrapper
    implements MultipleConversationCanceller {
        private ConversationCanceller canceller;

        public MultipleWrapper(ConversationCanceller canceller) {
            this.canceller = canceller;
        }

        @Override
        public boolean cancelBasedOnInput(ConversationContext context, String currentLine) {
            return this.canceller.cancelBasedOnInput(context, currentLine);
        }

        @Override
        public boolean cancelBasedOnInput(ConversationContext context, String currentLine, StringBuilder lines, int lineCount) {
            return this.cancelBasedOnInput(context, currentLine);
        }

        public void setConversation(Conversation conversation) {
            this.canceller.setConversation(conversation);
        }

        public MultipleWrapper clone() {
            return new MultipleWrapper(this.canceller.clone());
        }
    }

    public static interface MultipleConversationCanceller
    extends ConversationCanceller {
        public boolean cancelBasedOnInput(ConversationContext var1, String var2);

        public boolean cancelBasedOnInput(ConversationContext var1, String var2, StringBuilder var3, int var4);
    }
}

