/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedIntHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

class EntityUtilities {
    private static final EntityUtilities INSTANCE = new EntityUtilities();
    private static final boolean NEW_TRACKER = MinecraftVersion.VILLAGE_UPDATE.atOrAbove();
    private final Map<Class<?>, MethodAccessor> scanPlayersMethods = new ConcurrentHashMap();
    private final Map<Class<?>, FieldAccessor> trackedEntityFields = new ConcurrentHashMap();
    private FieldAccessor chunkMapField;
    private FieldAccessor entityTrackerField;
    private FieldAccessor trackedPlayersField;
    private FieldAccessor trackedEntitiesField;
    private MethodAccessor getEntity;
    private MethodAccessor getChunkProvider;

    private EntityUtilities() {
    }

    public static EntityUtilities getInstance() {
        return INSTANCE;
    }

    public void updateEntity(Entity entity, List<Player> observers) {
        if (entity == null || !entity.isValid()) {
            return;
        }
        Collection<Object> trackedPlayers = this.getTrackedPlayers(entity);
        List<Object> nmsPlayers = this.unwrapBukkit(observers);
        List<Object> removingEntries = MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() ? this.getPlayerConnections(nmsPlayers) : nmsPlayers;
        trackedPlayers.removeAll(removingEntries);
        Object trackerEntry = this.getEntityTrackerEntry(entity.getWorld(), entity.getEntityId());
        this.scanPlayersMethods.computeIfAbsent(trackerEntry.getClass(), this::findScanPlayers).invoke(trackerEntry, nmsPlayers);
    }

    public Entity getEntity(World world, int id) {
        if (NEW_TRACKER) {
            Object level = BukkitUnwrapper.getInstance().unwrapItem(world);
            if (this.getEntity == null) {
                Method entityGetter = FuzzyReflection.fromObject(level).getMethodByReturnTypeAndParameters("getEntity", MinecraftReflection.getEntityClass(), Integer.TYPE);
                this.getEntity = Accessors.getMethodAccessor(entityGetter);
            }
            Object entity = this.getEntity.invoke(level, id);
            return (Entity)MinecraftReflection.getBukkitEntity(entity);
        }
        Object trackerEntry = this.getEntityTrackerEntry(world, id);
        if (trackerEntry == null) {
            return null;
        }
        FieldAccessor trackedEntityAccessor = this.trackedEntityFields.computeIfAbsent(trackerEntry.getClass(), clz -> {
            try {
                Field entityField = FuzzyReflection.fromClass(clz, true).getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getEntityClass()).build());
                return Accessors.getFieldAccessor(entityField);
            }
            catch (IllegalArgumentException exception) {
                Class<?> trackerClass = MinecraftReflection.getEntityTrackerClass();
                Field entityField = FuzzyReflection.fromClass(trackerClass, true).getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getEntityClass()).build());
                return Accessors.getFieldAccessor(entityField);
            }
        });
        Object entity = trackedEntityAccessor.get(trackerEntry);
        return (Entity)MinecraftReflection.getBukkitEntity(entity);
    }

    private MethodAccessor findScanPlayers(Class<?> trackerClass) {
        MethodAccessor candidate = Accessors.getMethodAccessorOrNull(trackerClass, "scanPlayers", new Class[0]);
        if (candidate != null) {
            return candidate;
        }
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(trackerClass, true);
        return Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().returnTypeVoid().parameterExactArray(List.class).build()));
    }

    public List<Player> getEntityTrackers(Entity entity) {
        if (entity == null || !entity.isValid()) {
            return new ArrayList<Player>();
        }
        ArrayList<Player> result = new ArrayList<Player>();
        Collection<?> trackedPlayers = this.getTrackedPlayers(entity);
        for (Object tracker : trackedPlayers) {
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() && MinecraftReflection.isServerHandler(tracker)) {
                result.add(MinecraftReflection.getBukkitPlayerFromConnection(tracker));
                continue;
            }
            if (!MinecraftReflection.isMinecraftPlayer(tracker)) continue;
            result.add((Player)MinecraftReflection.getBukkitEntity(tracker));
        }
        return result;
    }

    private Collection<?> getTrackedPlayers(Entity entity) {
        Validate.notNull((Object)entity, (String)"entity cannot be null");
        Object trackerEntry = this.getEntityTrackerEntry(entity.getWorld(), entity.getEntityId());
        if (trackerEntry == null) {
            throw new IllegalArgumentException("Could not find entity trackers for " + entity);
        }
        if (this.trackedPlayersField == null) {
            this.trackedPlayersField = Accessors.getFieldAccessor(FuzzyReflection.fromObject(trackerEntry).getFieldByType("java\\.util\\..*"));
        }
        Validate.notNull((Object)this.trackedPlayersField, (String)"Could not find trackedPlayers field");
        Object value = this.trackedPlayersField.get(trackerEntry);
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Map) {
            return ((Map)value).keySet();
        }
        throw new IllegalStateException("trackedPlayers field was an unknown type: expected Collection or Map, but got " + value.getClass());
    }

    private Object getNewEntityTracker(Object worldServer, int entityId) {
        if (this.getChunkProvider == null) {
            Class<?> chunkProviderClass = MinecraftReflection.getChunkProviderServer();
            this.getChunkProvider = Accessors.getMethodAccessor(FuzzyReflection.fromClass(worldServer.getClass(), false).getMethod(FuzzyMethodContract.newBuilder().parameterCount(0).returnTypeExact(chunkProviderClass).build()));
        }
        Object chunkProvider = this.getChunkProvider.invoke(worldServer, new Object[0]);
        if (this.chunkMapField == null) {
            Class<?> chunkMapClass = MinecraftReflection.getPlayerChunkMap();
            this.chunkMapField = Accessors.getFieldAccessor(FuzzyReflection.fromClass(chunkProvider.getClass(), false).getField(FuzzyFieldContract.newBuilder().typeExact(chunkMapClass).build()));
        }
        Object playerChunkMap = this.chunkMapField.get(chunkProvider);
        if (this.trackedEntitiesField == null) {
            this.trackedEntitiesField = MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() ? Accessors.getFieldAccessor(FuzzyReflection.fromClass(playerChunkMap.getClass(), true).getField(FuzzyFieldContract.newBuilder().banModifier(8).requirePublic().typeExact(MinecraftReflection.getInt2ObjectMapClass()).build())) : Accessors.getFieldAccessor(FuzzyReflection.fromClass(playerChunkMap.getClass(), false).getField(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class).nameExact("trackedEntities").build()));
        }
        Map trackedEntities = (Map)this.trackedEntitiesField.get(playerChunkMap);
        return trackedEntities.get(entityId);
    }

    private Object getEntityTrackerEntry(World world, int entityID) {
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        Object worldServer = unwrapper.unwrapItem(world);
        if (NEW_TRACKER) {
            return this.getNewEntityTracker(worldServer, entityID);
        }
        if (this.entityTrackerField == null) {
            this.entityTrackerField = Accessors.getFieldAccessor(FuzzyReflection.fromObject(worldServer).getFieldByType("tracker", MinecraftReflection.getEntityTrackerClass()));
        }
        Object tracker = this.entityTrackerField.get(worldServer);
        if (this.trackedEntitiesField == null) {
            this.trackedEntitiesField = Accessors.getFieldAccessor(FuzzyReflection.fromObject(tracker, false).getFieldByType("trackedEntities", MinecraftReflection.getIntHashMapClass()));
        }
        Object trackedEntities = this.trackedEntitiesField.get(tracker);
        return WrappedIntHashMap.fromHandle(trackedEntities).get(entityID);
    }

    private List<Object> getPlayerConnections(List<Object> nmsPlayers) {
        ArrayList<Object> connections = new ArrayList<Object>(nmsPlayers.size());
        nmsPlayers.forEach(nmsPlayer -> connections.add(MinecraftFields.getPlayerConnection(nmsPlayer)));
        return connections;
    }

    private List<Object> unwrapBukkit(List<Player> players) {
        ArrayList<Object> output = new ArrayList<Object>();
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        for (Player player : players) {
            Object result = unwrapper.unwrapItem(player);
            if (result != null) {
                output.add(result);
                continue;
            }
            throw new IllegalArgumentException("Cannot unwrap item " + player);
        }
        return output;
    }
}

