/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.collections;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class IntegerMap<T> {
    private T[] array;
    private int size;

    public IntegerMap() {
        this(8);
    }

    public IntegerMap(int initialCapacity) {
        Object[] backingArray = new Object[initialCapacity];
        this.array = backingArray;
        this.size = 0;
    }

    public T put(int key, T value) {
        this.ensureCapacity(key);
        T old = this.array[key];
        this.array[key] = Preconditions.checkNotNull(value, (Object)"value cannot be NULL");
        if (old == null) {
            ++this.size;
        }
        return old;
    }

    public T remove(int key) {
        T old = this.array[key];
        this.array[key] = null;
        if (old != null) {
            --this.size;
        }
        return old;
    }

    protected void ensureCapacity(int key) {
        int newLength = this.array.length;
        if (key < 0) {
            throw new IllegalArgumentException("Negative key values are not permitted.");
        }
        if (key < newLength) {
            return;
        }
        while (newLength <= key) {
            int next = newLength * 2;
            newLength = next > newLength ? next : Integer.MAX_VALUE;
        }
        this.array = Arrays.copyOf(this.array, newLength);
    }

    public int size() {
        return this.size;
    }

    public T get(int key) {
        if (key >= 0 && key < this.array.length) {
            return this.array[key];
        }
        return null;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public Map<Integer, Object> toMap() {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            map.put(i, this.array[i]);
        }
        return map;
    }
}

