/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.concurrency.AbstractConcurrentListenerMultimap;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.PrioritizedListener;
import com.comphenix.protocol.timing.TimedListenerManager;
import com.comphenix.protocol.timing.TimedTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;

public final class SortedPacketListenerList
extends AbstractConcurrentListenerMultimap<PacketListener> {
    private TimedListenerManager timedManager = TimedListenerManager.getInstance();

    public void invokePacketRecieving(ErrorReporter reporter, PacketEvent event) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_CLIENT_SIDE);
                long token = tracker.beginTracking();
                this.invokeReceivingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                this.invokeReceivingListener(reporter, event, prioritizedListener);
            }
        }
    }

    public void invokePacketRecieving(ErrorReporter reporter, PacketEvent event, ListenerPriority priorityFilter) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (prioritizedListener.getPriority() != priorityFilter) continue;
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_CLIENT_SIDE);
                long token = tracker.beginTracking();
                this.invokeReceivingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (prioritizedListener.getPriority() != priorityFilter) continue;
                this.invokeReceivingListener(reporter, event, prioritizedListener);
            }
        }
    }

    private void invokeReceivingListener(ErrorReporter reporter, PacketEvent event, PrioritizedListener<PacketListener> element) {
        try {
            event.setReadOnly(element.getPriority() == ListenerPriority.MONITOR);
            element.getListener().onPacketReceiving(event);
        }
        catch (OutOfMemoryError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportMinimal(element.getListener().getPlugin(), "onPacketReceiving(PacketEvent)", e, event.getPacket().getHandle());
        }
    }

    public void invokePacketSending(ErrorReporter reporter, PacketEvent event) {
        this.invokePacketSending(reporter, event, null);
    }

    public void invokePacketSending(ErrorReporter reporter, PacketEvent event, @javax.annotation.Nullable ListenerPriority priorityFilter) {
        this.invokeUnpackedPacketSending(reporter, event, priorityFilter);
        if (event.getPacketType() == PacketType.Play.Server.BUNDLE && !event.isCancelled()) {
            Iterable<PacketContainer> packets = event.getPacket().getPacketBundles().read(0);
            ArrayList<PacketContainer> outPackets = new ArrayList<PacketContainer>();
            for (PacketContainer subPacket : packets) {
                if (subPacket == null) {
                    ProtocolLibrary.getPlugin().getLogger().log(Level.WARNING, "Failed to invoke packet event " + (priorityFilter == null ? "" : "with priority " + (Object)((Object)priorityFilter)) + " in bundle because bundle contains null packet: " + packets, new Throwable());
                    continue;
                }
                PacketEvent subPacketEvent = PacketEvent.fromServer(this, subPacket, event.getNetworkMarker(), event.getPlayer());
                this.invokeUnpackedPacketSending(reporter, subPacketEvent, priorityFilter);
                if (subPacketEvent.isCancelled()) continue;
                PacketContainer packet = subPacketEvent.getPacket();
                if (packet == null) {
                    ProtocolLibrary.getPlugin().getLogger().log(Level.WARNING, "null packet container returned for " + subPacketEvent, new Throwable());
                    continue;
                }
                if (packet.getHandle() == null) {
                    ProtocolLibrary.getPlugin().getLogger().log(Level.WARNING, "null packet handle returned for " + subPacketEvent, new Throwable());
                    continue;
                }
                outPackets.add(packet);
            }
            if (packets.iterator().hasNext()) {
                event.getPacket().getPacketBundles().write(0, outPackets);
            } else {
                event.setCancelled(true);
            }
        }
    }

    private void invokeUnpackedPacketSending(ErrorReporter reporter, PacketEvent event, @Nullable ListenerPriority priorityFilter) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (priorityFilter != null && prioritizedListener.getPriority() != priorityFilter) continue;
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_SERVER_SIDE);
                long token = tracker.beginTracking();
                this.invokeSendingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (priorityFilter != null && prioritizedListener.getPriority() != priorityFilter) continue;
                this.invokeSendingListener(reporter, event, prioritizedListener);
            }
        }
    }

    private void invokeSendingListener(ErrorReporter reporter, PacketEvent event, PrioritizedListener<PacketListener> element) {
        try {
            event.setReadOnly(element.getPriority() == ListenerPriority.MONITOR);
            element.getListener().onPacketSending(event);
        }
        catch (OutOfMemoryError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportMinimal(element.getListener().getPlugin(), "onPacketSending(PacketEvent)", e, event.getPacket().getHandle());
        }
    }
}

