/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.instances;

import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.instances.InstanceProvider;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BukkitConverters;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class MinecraftGenerator {
    public static final UUID SYS_UUID;
    public static final Object AIR_ITEM_STACK;
    private static Object DEFAULT_ENTITY_TYPES;
    private static final MethodAccessor NON_NULL_LIST_CREATE;
    private static final Map<Class<?>, Constructor<?>> FAST_MAP_CONSTRUCTORS;
    public static final InstanceProvider INSTANCE;

    static {
        try {
            SYS_UUID = new UUID(0L, 0L);
            AIR_ITEM_STACK = BukkitConverters.getItemStackConverter().getGeneric(new ItemStack(Material.AIR));
            FAST_MAP_CONSTRUCTORS = new ConcurrentHashMap();
            NON_NULL_LIST_CREATE = MinecraftReflection.getNonNullListCreateAccessor();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to create static fields in MinecraftGenerator", ex);
        }
        INSTANCE = type -> {
            if (type != null) {
                if (type == UUID.class) {
                    return SYS_UUID;
                }
                if (type.isEnum()) {
                    return type.getEnumConstants()[0];
                }
                if (type == MinecraftReflection.getItemStackClass()) {
                    return AIR_ITEM_STACK;
                }
                if (type == MinecraftReflection.getEntityTypes()) {
                    if (DEFAULT_ENTITY_TYPES == null) {
                        try {
                            DEFAULT_ENTITY_TYPES = BukkitConverters.getEntityTypeConverter().getGeneric(EntityType.AREA_EFFECT_CLOUD);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return DEFAULT_ENTITY_TYPES;
                }
                if (type.isAssignableFrom(Map.class)) {
                    Constructor ctor = FAST_MAP_CONSTRUCTORS.computeIfAbsent(type, __ -> {
                        try {
                            String name = type.getCanonicalName();
                            if (name != null && name.contains("it.unimi.fastutils")) {
                                return Class.forName(name.substring(name.length() - 3) + "OpenHashMap").getConstructor(new Class[0]);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    });
                    if (ctor != null) {
                        try {
                            return ctor.newInstance(new Object[0]);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {}
                    }
                } else if (NON_NULL_LIST_CREATE != null && type == MinecraftReflection.getNonNullListClass()) {
                    return NON_NULL_LIST_CREATE.invoke(null, new Object[0]);
                }
            }
            return null;
        };
    }
}

