/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.compiler;

import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.compiler.CompileListener;
import com.comphenix.protocol.reflect.compiler.StructureCompiler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BackgroundCompiler {
    public static final ReportType REPORT_CANNOT_COMPILE_STRUCTURE_MODIFIER = new ReportType("Cannot compile structure. Disabing compiler.");
    public static final ReportType REPORT_CANNOT_SCHEDULE_COMPILATION = new ReportType("Unable to schedule compilation task.");
    public static final String THREAD_FORMAT = "ProtocolLib-StructureCompiler %s";
    public static final int SHUTDOWN_DELAY_MS = 2000;
    public static final double DEFAULT_DISABLE_AT_PERM_GEN = 0.65;
    private static BackgroundCompiler backgroundCompiler;
    private Map<StructureCompiler.StructureKey, List<CompileListener<?>>> listeners = Maps.newHashMap();
    private Object listenerLock = new Object();
    private StructureCompiler compiler;
    private boolean enabled;
    private boolean shuttingDown;
    private ExecutorService executor;
    private ErrorReporter reporter;
    private final Object unknownPermGenBean;
    private Object permGenBean = this.unknownPermGenBean = new Object();
    private double disablePermGenFraction = 0.65;

    public static BackgroundCompiler getInstance() {
        return backgroundCompiler;
    }

    public static void setInstance(BackgroundCompiler backgroundCompiler) {
        BackgroundCompiler.backgroundCompiler = backgroundCompiler;
    }

    public BackgroundCompiler(ClassLoader loader, ErrorReporter reporter) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(THREAD_FORMAT).build();
        this.initializeCompiler(loader, reporter, Executors.newSingleThreadExecutor(factory));
    }

    public BackgroundCompiler(ClassLoader loader, ErrorReporter reporter, ExecutorService executor) {
        this.initializeCompiler(loader, reporter, executor);
    }

    private void initializeCompiler(ClassLoader loader, ErrorReporter reporter, ExecutorService executor) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be NULL");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be NULL");
        }
        if (reporter == null) {
            throw new IllegalArgumentException("reporter cannot be NULL.");
        }
        this.compiler = new StructureCompiler(loader);
        this.reporter = reporter;
        this.executor = executor;
        this.enabled = true;
    }

    public void scheduleCompilation(final Map<Class, StructureModifier> cache, final Class key) {
        StructureModifier uncompiled = cache.get(key);
        if (uncompiled != null) {
            this.scheduleCompilation(uncompiled, new CompileListener<Object>(){

                @Override
                public void onCompiled(StructureModifier<Object> compiledModifier) {
                    cache.put(key, compiledModifier);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TKey> void scheduleCompilation(final StructureModifier<TKey> uncompiled, CompileListener<TKey> listener) {
        if (this.enabled && !this.shuttingDown) {
            if (this.getPermGenUsage() > this.disablePermGenFraction) {
                return;
            }
            if (this.executor == null || this.executor.isShutdown()) {
                return;
            }
            final StructureCompiler.StructureKey key = new StructureCompiler.StructureKey(uncompiled);
            Object object = this.listenerLock;
            synchronized (object) {
                List<CompileListener<?>> list = this.listeners.get(key);
                if (this.listeners.containsKey(key)) {
                    list.add(listener);
                    return;
                }
                this.listeners.put(key, Lists.newArrayList((Object[])new CompileListener[]{listener}));
            }
            Callable<Object> worker = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    StructureModifier modifier;
                    block12: {
                        modifier = uncompiled;
                        List list = null;
                        try {
                            modifier = BackgroundCompiler.this.compiler.compile(modifier);
                            Object object = BackgroundCompiler.this.listenerLock;
                            synchronized (object) {
                                list = (List)BackgroundCompiler.this.listeners.get(key);
                                if (list != null) {
                                    list = Lists.newArrayList((Iterable)list);
                                }
                            }
                            if (list == null) break block12;
                            for (Object compileListener : list) {
                                ((CompileListener)compileListener).onCompiled(modifier);
                            }
                            object = BackgroundCompiler.this.listenerLock;
                            synchronized (object) {
                                list = (List)BackgroundCompiler.this.listeners.remove(key);
                            }
                        }
                        catch (OutOfMemoryError e) {
                            BackgroundCompiler.this.setEnabled(false);
                            throw e;
                        }
                        catch (ThreadDeath e) {
                            BackgroundCompiler.this.setEnabled(false);
                            throw e;
                        }
                        catch (Throwable e) {
                            BackgroundCompiler.this.setEnabled(false);
                            BackgroundCompiler.this.reporter.reportDetailed((Object)BackgroundCompiler.this, Report.newBuilder(REPORT_CANNOT_COMPILE_STRUCTURE_MODIFIER).callerParam(uncompiled).error(e));
                        }
                    }
                    return modifier;
                }
            };
            try {
                if (this.compiler.lookupClassLoader(uncompiled)) {
                    try {
                        worker.call();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.executor.submit(worker);
                }
            }
            catch (RejectedExecutionException e) {
                this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_SCHEDULE_COMPILATION).error(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TKey> void addListener(StructureModifier<TKey> uncompiled, CompileListener<TKey> listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            StructureCompiler.StructureKey key = new StructureCompiler.StructureKey(uncompiled);
            List<CompileListener<?>> list = this.listeners.get(key);
            if (list != null) {
                list.add(listener);
            }
        }
    }

    private double getPermGenUsage() {
        Object permGenBean = this.permGenBean;
        if (permGenBean == this.unknownPermGenBean) {
            for (MemoryPoolMXBean item : ManagementFactory.getMemoryPoolMXBeans()) {
                if (!item.getName().contains("Perm Gen")) continue;
                permGenBean = this.permGenBean = item;
                break;
            }
            if (permGenBean == this.unknownPermGenBean) {
                this.permGenBean = null;
                permGenBean = null;
            }
        }
        if (permGenBean != null) {
            MemoryUsage usage = ((MemoryPoolMXBean)permGenBean).getUsage();
            return (double)usage.getUsed() / (double)usage.getCommitted();
        }
        return 0.0;
    }

    public void shutdownAll() {
        this.shutdownAll(2000L, TimeUnit.MILLISECONDS);
    }

    public void shutdownAll(long timeout, TimeUnit unit) {
        this.setEnabled(false);
        this.shuttingDown = true;
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getDisablePermGenFraction() {
        return this.disablePermGenFraction;
    }

    public void setDisablePermGenFraction(double fraction) {
        this.disablePermGenFraction = fraction;
    }

    public StructureCompiler getCompiler() {
        return this.compiler;
    }
}

