/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public abstract class MonitorAdapter
implements PacketListener {
    private Plugin plugin;
    private ListeningWhitelist sending = ListeningWhitelist.EMPTY_WHITELIST;
    private ListeningWhitelist receiving = ListeningWhitelist.EMPTY_WHITELIST;

    public MonitorAdapter(Plugin plugin, ConnectionSide side) {
        this.initialize(plugin, side, this.getLogger(plugin));
    }

    public MonitorAdapter(Plugin plugin, ConnectionSide side, Logger logger) {
        this.initialize(plugin, side, logger);
    }

    private void initialize(Plugin plugin, ConnectionSide side, Logger logger) {
        this.plugin = plugin;
        if (side.isForServer()) {
            this.sending = ListeningWhitelist.newBuilder().monitor().types(PacketRegistry.getServerPacketTypes()).gamePhaseBoth().build();
        }
        if (side.isForClient()) {
            this.receiving = ListeningWhitelist.newBuilder().monitor().types(PacketRegistry.getClientPacketTypes()).gamePhaseBoth().build();
        }
    }

    private Logger getLogger(Plugin plugin) {
        try {
            return plugin.getLogger();
        }
        catch (NoSuchMethodError e) {
            return Logger.getLogger("Minecraft");
        }
    }

    @Override
    public ListeningWhitelist getSendingWhitelist() {
        return this.sending;
    }

    @Override
    public ListeningWhitelist getReceivingWhitelist() {
        return this.receiving;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }
}

