/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.netty.WirePacket;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PacketLogging
implements CommandExecutor,
PacketListener {
    public static final String NAME = "packetlog";
    private static MethodAccessor HEX_DUMP;
    private List<PacketType> sendingTypes = new ArrayList<PacketType>();
    private List<PacketType> receivingTypes = new ArrayList<PacketType>();
    private ListeningWhitelist sendingWhitelist;
    private ListeningWhitelist receivingWhitelist;
    private Logger fileLogger;
    private LogLocation location = LogLocation.FILE;
    private final ProtocolManager manager;
    private final Plugin plugin;

    PacketLogging(Plugin plugin, ProtocolManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        PacketType type = null;
        try {
            if (args.length > 2) {
                PacketType.Sender pSender;
                PacketType.Protocol protocol;
                try {
                    protocol = PacketType.Protocol.valueOf(args[0].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    sender.sendMessage(ChatColor.RED + "Unknown protocol " + args[0]);
                    return true;
                }
                try {
                    pSender = PacketType.Sender.valueOf(args[1].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    sender.sendMessage(ChatColor.RED + "Unknown sender: " + args[1]);
                    return true;
                }
                try {
                    try {
                        int id = Integer.parseInt(args[2]);
                        type = PacketType.findCurrent(protocol, pSender, id);
                    }
                    catch (NumberFormatException ex) {
                        String name = args[2];
                        block10: for (PacketType packet : PacketType.values()) {
                            if (packet.getProtocol() != protocol || packet.getSender() != pSender) continue;
                            if (packet.name().equalsIgnoreCase(name)) {
                                type = packet;
                                break;
                            }
                            for (String className : packet.getClassNames()) {
                                if (!className.equalsIgnoreCase(name)) continue;
                                type = packet;
                                continue block10;
                            }
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    type = null;
                }
                if (type == null) {
                    sender.sendMessage(ChatColor.RED + "Unknown packet: " + args[2]);
                    return true;
                }
                if (args.length > 3) {
                    this.location = args[3].equalsIgnoreCase("console") ? LogLocation.CONSOLE : LogLocation.FILE;
                }
                if (pSender == PacketType.Sender.CLIENT) {
                    if (this.receivingTypes.contains(type)) {
                        this.receivingTypes.remove(type);
                    } else {
                        this.receivingTypes.add(type);
                    }
                } else if (this.sendingTypes.contains(type)) {
                    this.sendingTypes.remove(type);
                } else {
                    this.sendingTypes.add(type);
                }
                this.startLogging();
                sender.sendMessage(ChatColor.GREEN + "Now logging " + type.getPacketClass().getSimpleName());
                return true;
            }
            sender.sendMessage(ChatColor.RED + "Invalid syntax: /packetlog <protocol> <sender> <packet> [location]");
            return true;
        }
        catch (Throwable ex) {
            sender.sendMessage(ChatColor.RED + "Failed to parse command: " + ex.toString());
            return true;
        }
    }

    private void startLogging() {
        this.manager.removePacketListener(this);
        if (this.sendingTypes.isEmpty() && this.receivingTypes.isEmpty()) {
            return;
        }
        this.sendingWhitelist = ListeningWhitelist.newBuilder().types(this.sendingTypes).build();
        this.receivingWhitelist = ListeningWhitelist.newBuilder().types(this.receivingTypes).build();
        if (this.location == LogLocation.FILE && this.fileLogger == null) {
            this.fileLogger = Logger.getLogger("ProtocolLib-FileLogging");
            for (Handler handler : this.fileLogger.getHandlers()) {
                this.fileLogger.removeHandler(handler);
            }
            this.fileLogger.setUseParentHandlers(false);
            try {
                File logFile = new File(this.plugin.getDataFolder(), "log.log");
                FileHandler handler = new FileHandler(logFile.getAbsolutePath(), true);
                handler.setFormatter(new LogFormatter());
                this.fileLogger.addHandler(handler);
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to obtain log file:", ex);
                return;
            }
        }
        this.manager.addPacketListener(this);
    }

    @Override
    public void onPacketSending(PacketEvent event) {
        this.log(event);
    }

    @Override
    public void onPacketReceiving(PacketEvent event) {
        this.log(event);
    }

    private static String hexDump(byte[] bytes) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            if (HEX_DUMP == null) {
                Class<?> hexDumpClass = MinecraftReflection.getLibraryClass("org.apache.commons.io.HexDump");
                HEX_DUMP = Accessors.getMethodAccessor(FuzzyReflection.fromClass(hexDumpClass).getMethodByParameters("dump", byte[].class, Long.TYPE, OutputStream.class, Integer.TYPE));
            }
            HEX_DUMP.invoke(null, bytes, 0, output, 0);
            String string = new String(output.toByteArray(), Charsets.UTF_8);
            return string;
        }
    }

    private void log(PacketEvent event) {
        try {
            byte[] bytes = WirePacket.bytesFromPacket(event.getPacket());
            String hexDump = PacketLogging.hexDump(bytes);
            if (this.location == LogLocation.FILE) {
                this.fileLogger.log(Level.INFO, event.getPacketType() + ":");
                this.fileLogger.log(Level.INFO, hexDump);
                this.fileLogger.log(Level.INFO, "");
            } else {
                System.out.println(event.getPacketType() + ":");
                System.out.println(hexDump);
                System.out.println();
            }
        }
        catch (Throwable ex) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to log packet " + event.getPacketType() + ":", ex);
            this.plugin.getLogger().log(Level.WARNING, "Clearing packet logger...");
            this.sendingTypes.clear();
            this.receivingTypes.clear();
            this.startLogging();
        }
    }

    @Override
    public ListeningWhitelist getSendingWhitelist() {
        return this.sendingWhitelist;
    }

    @Override
    public ListeningWhitelist getReceivingWhitelist() {
        return this.receivingWhitelist;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    private static enum LogLocation {
        CONSOLE,
        FILE;

    }

    private static class LogFormatter
    extends Formatter {
        private static final SimpleDateFormat DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private static final String FORMAT = "[{0}] {1}";

        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String string = this.formatMessage(record);
            if (string.isEmpty()) {
                return LINE_SEPARATOR;
            }
            StringBuilder message = new StringBuilder();
            message.append(MessageFormat.format(FORMAT, DATE.format(record.getMillis()), string));
            message.append(LINE_SEPARATOR);
            return message.toString();
        }
    }
}

