/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.ProtocolLibrary;
import io.netty.util.Version;
import java.util.Map;

public class NettyVersion {
    private static final String NETTY_ARTIFACT_ID = "netty-common";
    private static NettyVersion version;
    private boolean valid = false;
    private int major;
    private int minor;
    private int revision;

    public static NettyVersion getVersion() {
        if (version == null) {
            version = NettyVersion.detectVersion();
        }
        return version;
    }

    private static NettyVersion detectVersion() {
        Map nettyArtifacts = Version.identify();
        Version version = (Version)nettyArtifacts.get(NETTY_ARTIFACT_ID);
        if (version != null) {
            return new NettyVersion(version.artifactVersion());
        }
        return new NettyVersion(null);
    }

    public NettyVersion(String s) {
        if (s == null) {
            return;
        }
        String[] split = s.split("\\.");
        try {
            this.major = Integer.parseInt(split[0]);
            this.minor = Integer.parseInt(split[1]);
            this.revision = Integer.parseInt(split[2]);
            this.valid = true;
        }
        catch (Throwable t) {
            ProtocolLibrary.getPlugin().getLogger().warning("Could not detect netty version: '" + s + "'");
        }
    }

    public String toString() {
        if (!this.valid) {
            return "(invalid)";
        }
        return this.major + "." + this.minor + "." + this.revision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NettyVersion)) {
            return false;
        }
        NettyVersion v = (NettyVersion)obj;
        return v.major == this.major && v.minor == this.minor && v.revision == this.revision;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isGreaterThan(int major, int minor, int rev) {
        return this.major > major || this.minor > minor || this.revision > rev;
    }
}

