/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.updater;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.updater.Updater;
import com.comphenix.protocol.utility.Closer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.plugin.Plugin;

public final class SpigotUpdater
extends Updater {
    private String remoteVersion;
    private static final String RESOURCE_URL = "https://www.spigotmc.org/resources/protocollib.1997/";
    private static final String UPDATE_URL = "https://api.spigotmc.org/legacy/update.php?resource=1997";
    private static final String ACTION = "GET";

    public SpigotUpdater(Plugin plugin, Updater.UpdateType type, boolean announce) {
        super(plugin, type, announce);
    }

    @Override
    public void start(Updater.UpdateType type) {
        this.waitForThread();
        this.type = type;
        this.thread = new Thread(new SpigotUpdateRunnable());
        this.thread.start();
    }

    @Override
    public String getResult() {
        this.waitForThread();
        return String.format(this.result.toString(), this.remoteVersion, this.plugin.getDescription().getVersion(), RESOURCE_URL);
    }

    public String getSpigotVersion() throws IOException {
        try (Closer closer = Closer.create();){
            HttpURLConnection con = (HttpURLConnection)new URL(UPDATE_URL).openConnection();
            con.setDoOutput(true);
            con.setRequestMethod(ACTION);
            InputStreamReader isr = closer.register(new InputStreamReader(con.getInputStream()));
            BufferedReader br = closer.register(new BufferedReader(isr));
            String string = br.readLine();
            return string;
        }
    }

    @Override
    public String getRemoteVersion() {
        return this.remoteVersion;
    }

    private class SpigotUpdateRunnable
    implements Runnable {
        private SpigotUpdateRunnable() {
        }

        @Override
        public void run() {
            try {
                String version = SpigotUpdater.this.getSpigotVersion();
                SpigotUpdater.this.remoteVersion = version;
                SpigotUpdater.this.result = SpigotUpdater.this.versionCheck(version) ? Updater.UpdateResult.SPIGOT_UPDATE_AVAILABLE : Updater.UpdateResult.NO_UPDATE;
            }
            catch (Throwable ex) {
                if (ProtocolLibrary.getConfig().isDebug()) {
                    ProtocolLibrary.getErrorReporter().reportDetailed((Object)SpigotUpdater.this, Report.newBuilder(Updater.REPORT_CANNOT_UPDATE_PLUGIN).error(ex).callerParam(this));
                }
                ProtocolLibrary.disableUpdates();
            }
            finally {
                for (Runnable listener : SpigotUpdater.this.listeners) {
                    SpigotUpdater.this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(SpigotUpdater.this.plugin, listener);
                }
            }
        }
    }
}

