/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.implementation.InvocationHandlerAdapter;
import com.comphenix.net.bytebuddy.jar.asm.ClassReader;
import com.comphenix.net.bytebuddy.jar.asm.ClassVisitor;
import com.comphenix.net.bytebuddy.jar.asm.MethodVisitor;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.block.BlockState;

class TileEntityAccessor<T extends BlockState> {
    private static final boolean BLOCK_DATA_INCL = MinecraftVersion.NETHER_UPDATE.atOrAbove();
    private static final TileEntityAccessor<BlockState> EMPTY_ACCESSOR = new TileEntityAccessor();
    private static final ConcurrentMap<Class<?>, TileEntityAccessor<?>> cachedAccessors = Maps.newConcurrentMap();
    private static Constructor<?> nbtCompoundParserConstructor;
    private FieldAccessor tileEntityField;
    private MethodAccessor readCompound;
    private MethodAccessor writeCompound;

    TileEntityAccessor() {
    }

    private TileEntityAccessor(FieldAccessor tileEntityField, T state) {
        if (tileEntityField != null) {
            this.tileEntityField = tileEntityField;
            Class<?> type = tileEntityField.getField().getType();
            this.findMethods(type, state);
        }
    }

    void findMethods(Class<?> type, T state) {
        if (BLOCK_DATA_INCL) {
            Class<?> tileEntityClass = MinecraftReflection.getTileEntityClass();
            Class<?> iBlockData = MinecraftReflection.getIBlockDataClass();
            Class<?> nbtCompound = MinecraftReflection.getNBTCompoundClass();
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(tileEntityClass, false);
            this.writeCompound = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeVoid().parameterExactArray(iBlockData, nbtCompound).build()));
            this.readCompound = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(nbtCompound).parameterExactArray(nbtCompound).build()));
        }
        try {
            this.findMethodsUsingASM();
        }
        catch (IOException ex1) {
            try {
                this.findMethodUsingByteBuddy(state);
            }
            catch (Exception ex2) {
                throw new RuntimeException("Cannot find read/write methods in " + type, ex2);
            }
        }
        if (this.readCompound == null) {
            throw new RuntimeException("Unable to find read method in " + type);
        }
        if (this.writeCompound == null) {
            throw new RuntimeException("Unable to find write method in " + type);
        }
    }

    private void findMethodsUsingASM() throws IOException {
        final Class<?> nbtCompoundClass = MinecraftReflection.getNBTCompoundClass();
        final Class<?> tileEntityClass = MinecraftReflection.getTileEntityClass();
        ClassReader reader = new ClassReader(tileEntityClass.getCanonicalName());
        final String tagCompoundName = TileEntityAccessor.getJarName(MinecraftReflection.getNBTCompoundClass());
        final String expectedDesc = "(L" + tagCompoundName + ";)";
        reader.accept(new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final String methodName = name;
                if (desc.startsWith(expectedDesc)) {
                    return new MethodVisitor(327680){
                        private int readMethods;
                        private int writeMethods;

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
                            if (opcode == 182 && tagCompoundName.equals(owner) && desc.startsWith("(Ljava/lang/String")) {
                                if (desc.endsWith(")V")) {
                                    ++this.writeMethods;
                                } else {
                                    ++this.readMethods;
                                }
                            }
                        }

                        @Override
                        public void visitEnd() {
                            if (this.readMethods > this.writeMethods) {
                                TileEntityAccessor.this.readCompound = Accessors.getMethodAccessor(tileEntityClass, methodName, nbtCompoundClass);
                            } else if (this.writeMethods > this.readMethods) {
                                TileEntityAccessor.this.writeCompound = Accessors.getMethodAccessor(tileEntityClass, methodName, nbtCompoundClass);
                            }
                            super.visitEnd();
                        }
                    };
                }
                return null;
            }
        }, 0);
    }

    private static Constructor<?> setupNBTCompoundParserConstructor() {
        Class<?> nbtCompoundClass = MinecraftReflection.getNBTCompoundClass();
        try {
            return ByteBuddyFactory.getInstance().createSubclass(nbtCompoundClass).name(MinecraftMethods.class.getPackage().getName() + ".NBTInvocationHandler").method(ElementMatchers.not(ElementMatchers.isDeclaredBy(Object.class))).intercept(InvocationHandlerAdapter.of((obj, method, args) -> {
                if (method.getReturnType().equals(Void.TYPE)) {
                    throw new WriteMethodException();
                }
                throw new ReadMethodException();
            })).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find NBTCompound constructor.");
        }
    }

    private void findMethodUsingByteBuddy(T blockState) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (nbtCompoundParserConstructor == null) {
            nbtCompoundParserConstructor = TileEntityAccessor.setupNBTCompoundParserConstructor();
        }
        Class<?> nbtCompoundClass = MinecraftReflection.getNBTCompoundClass();
        Object compound = nbtCompoundParserConstructor.newInstance(new Object[0]);
        Object tileEntity = this.tileEntityField.get(blockState);
        for (Method method : FuzzyReflection.fromObject(tileEntity, true).getMethodListByParameters(Void.TYPE, new Class[]{nbtCompoundClass})) {
            try {
                method.invoke(tileEntity, compound);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ReadMethodException) {
                    this.readCompound = Accessors.getMethodAccessor(method, true);
                    continue;
                }
                if (!(e.getCause() instanceof WriteMethodException)) continue;
                this.writeCompound = Accessors.getMethodAccessor(method, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Generic reflection error.", e);
            }
        }
    }

    private static String getJarName(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '/');
    }

    public NbtCompound readBlockState(T state) {
        NbtCompound output = NbtFactory.ofCompound("");
        Object tileEntity = this.tileEntityField.get(state);
        this.writeCompound.invoke(tileEntity, NbtFactory.fromBase(output).getHandle());
        return output;
    }

    public void writeBlockState(T state, NbtCompound compound) {
        Object tileEntity = this.tileEntityField.get(state);
        if (BLOCK_DATA_INCL) {
            Object blockData = BukkitUnwrapper.getInstance().unwrapItem(state);
            this.readCompound.invoke(tileEntity, blockData, NbtFactory.fromBase(compound).getHandle());
        } else {
            this.readCompound.invoke(tileEntity, NbtFactory.fromBase(compound).getHandle());
        }
    }

    public static <T extends BlockState> TileEntityAccessor<T> getAccessor(T state) {
        Class<?> craftBlockState = state.getClass();
        TileEntityAccessor<BlockState> accessor = (TileEntityAccessor<BlockState>)cachedAccessors.get(craftBlockState);
        if (accessor == null) {
            TileEntityAccessor<Object> created = null;
            FieldAccessor field = null;
            try {
                field = Accessors.getFieldAccessor(craftBlockState, MinecraftReflection.getTileEntityClass(), true);
            }
            catch (Exception e) {
                created = EMPTY_ACCESSOR;
            }
            if (field != null) {
                created = new TileEntityAccessor<T>(field, state);
            }
            if ((accessor = cachedAccessors.putIfAbsent(craftBlockState, created)) == null) {
                accessor = created;
            }
        }
        return accessor != EMPTY_ACCESSOR ? accessor : null;
    }

    private static class ReadMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReadMethodException() {
            super("A read method was executed.");
        }
    }

    private static class WriteMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WriteMethodException() {
            super("A write method was executed.");
        }
    }
}

