/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.server;

import com.comphenix.net.bytebuddy.description.modifier.Visibility;
import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import com.comphenix.net.bytebuddy.implementation.FieldAccessor;
import com.comphenix.net.bytebuddy.implementation.MethodCall;
import com.comphenix.net.bytebuddy.implementation.MethodDelegation;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.FieldValue;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.Origin;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import com.comphenix.net.bytebuddy.implementation.bind.annotation.This;
import com.comphenix.net.bytebuddy.matcher.ElementMatcher;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.injector.server.TemporaryPlayer;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.ChatExtensions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class TemporaryPlayerFactory {
    private static final Constructor<? extends Player> temporaryPlayerConstructor = TemporaryPlayerFactory.setupProxyPlayerConstructor();

    public static SocketInjector getInjectorFromPlayer(Player player) {
        if (player instanceof TemporaryPlayer) {
            return ((TemporaryPlayer)player).getInjector();
        }
        return null;
    }

    public static void setInjectorInPlayer(Player player, SocketInjector injector) {
        ((TemporaryPlayer)player).setInjector(injector);
    }

    public Player createTemporaryPlayer(Server server) {
        try {
            return temporaryPlayerConstructor.newInstance(server);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access reflection.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate object.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error in invocation.", e);
        }
    }

    private static Constructor<? extends Player> setupProxyPlayerConstructor() {
        MethodDelegation implementation = MethodDelegation.to(new Object(){

            @RuntimeType
            public Object delegate(@This Object obj, @Origin Method method, @FieldValue(value="server") Server server, Object ... args) throws Throwable {
                String methodName = method.getName();
                SocketInjector injector = ((TemporaryPlayer)obj).getInjector();
                if (injector == null) {
                    throw new IllegalStateException("Unable to find injector.");
                }
                if (methodName.equals("getPlayer")) {
                    return injector.getUpdatedPlayer();
                }
                if (methodName.equals("getAddress")) {
                    return injector.getAddress();
                }
                if (methodName.equals("getServer")) {
                    return server;
                }
                if (methodName.equals("chat") || methodName.equals("sendMessage")) {
                    try {
                        Object argument = args[0];
                        if (argument instanceof String) {
                            return TemporaryPlayerFactory.sendMessage(injector, (String)argument);
                        }
                        if (argument instanceof String[]) {
                            for (String message : (String[])argument) {
                                TemporaryPlayerFactory.sendMessage(injector, message);
                            }
                            return null;
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                if (methodName.equals("kickPlayer")) {
                    injector.disconnect((String)args[0]);
                    return null;
                }
                Player updated = injector.getUpdatedPlayer();
                if (updated != obj && updated != null) {
                    return method.invoke((Object)updated, args);
                }
                if (methodName.equals("isOnline")) {
                    return injector.getSocket() != null && injector.getSocket().isConnected();
                }
                if (methodName.equals("getName")) {
                    return "UNKNOWN[" + injector.getSocket().getRemoteSocketAddress() + "]";
                }
                throw new UnsupportedOperationException("The method " + method.getName() + " is not supported for temporary players.");
            }
        });
        ElementMatcher.Junction callbackFilter = ElementMatchers.not(ElementMatchers.isDeclaredBy(Object.class).or(ElementMatchers.isDeclaredBy(TemporaryPlayer.class)));
        try {
            Constructor constructor = ByteBuddyFactory.getInstance().createSubclass(TemporaryPlayer.class, ConstructorStrategy.Default.NO_CONSTRUCTORS).name(TemporaryPlayerFactory.class.getPackage().getName() + ".TemporaryPlayerInvocationHandler").implement(new Type[]{Player.class}).defineField("server", (Type)((Object)Server.class), Visibility.PRIVATE).defineConstructor(Visibility.PUBLIC).withParameters(new Type[]{Server.class}).intercept(MethodCall.invoke(TemporaryPlayer.class.getDeclaredConstructor(new Class[0])).andThen(FieldAccessor.ofField("server").setsArgumentAt(0))).method(callbackFilter).intercept(implementation).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(Server.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find Temporary Player constructor!", e);
        }
    }

    public Player createTemporaryPlayer(Server server, SocketInjector injector) {
        Player temporary = this.createTemporaryPlayer(server);
        ((TemporaryPlayer)temporary).setInjector(injector);
        return temporary;
    }

    private static Object sendMessage(SocketInjector injector, String message) throws InvocationTargetException, FieldAccessException {
        for (PacketContainer packet : ChatExtensions.createChatPackets(message)) {
            injector.sendServerPacket(packet.getHandle(), null, false);
        }
        return null;
    }
}

