/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.netty.NettyProtocolRegistry;
import com.comphenix.protocol.injector.netty.ProtocolRegistry;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class PacketRegistry {
    private static volatile ProtocolRegistry NETTY;
    private static volatile boolean INITIALIZED;

    private static void initialize() {
        if (INITIALIZED) {
            if (NETTY == null) {
                throw new IllegalStateException("Failed to initialize packet registry.");
            }
            return;
        }
        NETTY = new NettyProtocolRegistry();
        INITIALIZED = true;
    }

    public static boolean isSupported(PacketType type) {
        PacketRegistry.initialize();
        return NETTY.getPacketTypeLookup().containsKey(type);
    }

    @Deprecated
    public static Map<Class, Integer> getPacketToID() {
        PacketRegistry.initialize();
        Map result = Maps.transformValues(NETTY.getPacketClassLookup(), PacketType::getCurrentId);
        return result;
    }

    public static Map<Class, PacketType> getPacketToType() {
        PacketRegistry.initialize();
        Map<Class, PacketType> result = NETTY.getPacketClassLookup();
        return result;
    }

    public static Set<PacketType> getServerPacketTypes() {
        PacketRegistry.initialize();
        NETTY.synchronize();
        return NETTY.getServerPackets();
    }

    public static Set<PacketType> getClientPacketTypes() {
        PacketRegistry.initialize();
        NETTY.synchronize();
        return NETTY.getClientPackets();
    }

    @Deprecated
    public static Class getPacketClassFromID(int packetID) {
        PacketRegistry.initialize();
        return NETTY.getPacketTypeLookup().get(PacketType.findLegacy(packetID));
    }

    public static Class getPacketClassFromType(PacketType type) {
        return PacketRegistry.getPacketClassFromType(type, false);
    }

    public static Class getPacketClassFromType(PacketType type, boolean forceVanilla) {
        PacketRegistry.initialize();
        Class<?> clazz = NETTY.getPacketTypeLookup().get(type);
        if (clazz != null) {
            return clazz;
        }
        for (String name : type.getClassNames()) {
            try {
                clazz = MinecraftReflection.getMinecraftClass(name);
                break;
            }
            catch (Exception exception) {
            }
        }
        return clazz;
    }

    @Deprecated
    public static Class getPacketClassFromID(int packetID, boolean forceVanilla) {
        PacketRegistry.initialize();
        return PacketRegistry.getPacketClassFromID(packetID);
    }

    @Deprecated
    public static int getPacketID(Class<?> packet) {
        PacketRegistry.initialize();
        return NETTY.getPacketClassLookup().get(packet).getCurrentId();
    }

    public static PacketType getPacketType(Class<?> packet) {
        return PacketRegistry.getPacketType(packet, null);
    }

    public static PacketType getPacketType(Class<?> packet, PacketType.Sender sender) {
        PacketRegistry.initialize();
        return NETTY.getPacketClassLookup().get(packet);
    }

    static {
        INITIALIZED = false;
    }
}

