/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.instances;

import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.reflect.instances.CollectionGenerator;
import com.comphenix.protocol.reflect.instances.InstanceProvider;
import com.comphenix.protocol.reflect.instances.NotConstructableException;
import com.comphenix.protocol.reflect.instances.PrimitiveGenerator;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class DefaultInstances
implements InstanceProvider {
    public static final InstanceProvider UUID_GENERATOR = type -> type == UUID.class ? new UUID(0L, 0L) : null;
    public static final DefaultInstances DEFAULT = DefaultInstances.fromArray(PrimitiveGenerator.INSTANCE, CollectionGenerator.INSTANCE, UUID_GENERATOR);
    private int maximumRecursion = 20;
    private ImmutableList<InstanceProvider> registered;
    private boolean nonNull;

    public DefaultInstances(ImmutableList<InstanceProvider> registered) {
        this.registered = registered;
    }

    public DefaultInstances(DefaultInstances other) {
        this.nonNull = other.nonNull;
        this.maximumRecursion = other.maximumRecursion;
        this.registered = other.registered;
    }

    public DefaultInstances(InstanceProvider ... instaceProviders) {
        this((ImmutableList<InstanceProvider>)ImmutableList.copyOf((Object[])instaceProviders));
    }

    public static DefaultInstances fromArray(InstanceProvider ... instanceProviders) {
        return new DefaultInstances((ImmutableList<InstanceProvider>)ImmutableList.copyOf((Object[])instanceProviders));
    }

    public static DefaultInstances fromCollection(Collection<InstanceProvider> instanceProviders) {
        return new DefaultInstances((ImmutableList<InstanceProvider>)ImmutableList.copyOf(instanceProviders));
    }

    public ImmutableList<InstanceProvider> getRegistered() {
        return this.registered;
    }

    public boolean isNonNull() {
        return this.nonNull;
    }

    public void setNonNull(boolean nonNull) {
        this.nonNull = nonNull;
    }

    public int getMaximumRecursion() {
        return this.maximumRecursion;
    }

    public void setMaximumRecursion(int maximumRecursion) {
        if (maximumRecursion < 1) {
            throw new IllegalArgumentException("Maxmimum recursion height must be one or higher.");
        }
        this.maximumRecursion = maximumRecursion;
    }

    public <T> T getDefault(Class<T> type) {
        return this.getDefaultInternal(type, (List<InstanceProvider>)this.registered, 0);
    }

    public <T> Constructor<T> getMinimumConstructor(Class<T> type) {
        return this.getMinimumConstructor(type, (List<InstanceProvider>)this.registered, 0);
    }

    private <T> Constructor<T> getMinimumConstructor(Class<T> type, List<InstanceProvider> providers, int recursionLevel) {
        Constructor<?> minimum = null;
        int lastCount = Integer.MAX_VALUE;
        for (Constructor<?> candidate : type.getConstructors()) {
            Class<?>[] types = candidate.getParameterTypes();
            if (types.length >= lastCount || this.contains(types, type) || this.nonNull && this.isAnyNull(types, providers, recursionLevel)) continue;
            minimum = candidate;
            lastCount = types.length;
            if (lastCount == 0) break;
        }
        return minimum;
    }

    private boolean isAnyNull(Class<?>[] types, List<InstanceProvider> providers, int recursionLevel) {
        for (Class<?> type : types) {
            if (this.getDefaultInternal(type, providers, recursionLevel) != null) continue;
            return true;
        }
        return false;
    }

    public <T> T getDefault(Class<T> type, List<InstanceProvider> providers) {
        return this.getDefaultInternal(type, providers, 0);
    }

    private <T> T getDefaultInternal(Class<T> type, List<InstanceProvider> providers, int recursionLevel) {
        try {
            for (InstanceProvider generator : providers) {
                Object value = generator.create(type);
                if (value == null) continue;
                return (T)value;
            }
        }
        catch (NotConstructableException e) {
            return null;
        }
        if (recursionLevel >= this.maximumRecursion) {
            return null;
        }
        Constructor<T> minimum = this.getMinimumConstructor(type, providers, recursionLevel + 1);
        try {
            if (minimum != null) {
                int parameterCount = minimum.getParameterTypes().length;
                Object[] params = new Object[parameterCount];
                Class<?>[] types = minimum.getParameterTypes();
                for (int i = 0; i < parameterCount; ++i) {
                    params[i] = this.getDefaultInternal(types[i], providers, recursionLevel + 1);
                    if (params[i] != null || !this.nonNull) continue;
                    ProtocolLogger.log(Level.WARNING, "Nonnull contract broken.", new Object[0]);
                    return null;
                }
                return this.createInstance(type, minimum, types, params);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DefaultInstances forEnhancer(Enhancer enhancer) {
        final Enhancer ex = enhancer;
        return new DefaultInstances(this){

            @Override
            protected <T> T createInstance(Class<T> type, Constructor<T> constructor, Class<?>[] types, Object[] params) {
                return (T)ex.create(types, params);
            }
        };
    }

    protected <T> T createInstance(Class<T> type, Constructor<T> constructor, Class<?>[] types, Object[] params) {
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected <T> boolean contains(T[] elements, T elementToFind) {
        for (T element : elements) {
            if (!Objects.equal(elementToFind, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object create(@Nullable Class<?> type) {
        return this.getDefault(type);
    }
}

