/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.EnumWrappers;

public class WrappedVillagerData
extends AbstractWrapper
implements ClonableWrapper {
    private static final Class<?> NMS_CLASS = MinecraftReflection.getNullableNMS("VillagerData");
    private static final Class<?> TYPE_CLASS = MinecraftReflection.getNullableNMS("VillagerType");
    private static final Class<?> PROF_CLASS = MinecraftReflection.getNullableNMS("VillagerProfession");
    private static EquivalentConverter<Type> TYPE_CONVERTER;
    private static EquivalentConverter<Profession> PROF_CONVERTER;
    private StructureModifier<Object> modifier;
    private static ConstructorAccessor CONSTRUCTOR;

    private WrappedVillagerData(Object handle) {
        super(NMS_CLASS);
        this.setHandle(handle);
        this.modifier = new StructureModifier(NMS_CLASS).withTarget(handle);
    }

    public static WrappedVillagerData fromHandle(Object handle) {
        return new WrappedVillagerData(handle);
    }

    public static WrappedVillagerData fromValues(Type type, Profession profession, int level) {
        Object genericType = TYPE_CONVERTER.getGeneric(type);
        Object genericProf = PROF_CONVERTER.getGeneric(profession);
        if (CONSTRUCTOR == null) {
            CONSTRUCTOR = Accessors.getConstructorAccessor(NMS_CLASS, TYPE_CLASS, PROF_CLASS, Integer.TYPE);
        }
        Object handle = CONSTRUCTOR.invoke(genericType, genericProf, level);
        return WrappedVillagerData.fromHandle(handle);
    }

    public static Class<?> getNmsClass() {
        return NMS_CLASS;
    }

    public int getLevel() {
        return (Integer)this.modifier.withType(Integer.TYPE).read(0);
    }

    public Type getType() {
        return this.modifier.withType(TYPE_CLASS, TYPE_CONVERTER).read(0);
    }

    public Profession getProfession() {
        return this.modifier.withType(PROF_CLASS, PROF_CONVERTER).read(0);
    }

    @Override
    public WrappedVillagerData deepClone() {
        return WrappedVillagerData.fromValues(this.getType(), this.getProfession(), this.getLevel());
    }

    static {
        if (NMS_CLASS != null) {
            TYPE_CONVERTER = new EnumWrappers.FauxEnumConverter<Type>(Type.class, TYPE_CLASS);
            PROF_CONVERTER = new EnumWrappers.FauxEnumConverter<Profession>(Profession.class, PROF_CLASS);
        }
    }

    public static enum Profession {
        NONE,
        ARMORER,
        BUTCHER,
        CARTOGRAPHER,
        CLERIC,
        FARMER,
        FISHERMAN,
        FLETCHER,
        LEATHERWORKER,
        LIBRARIAN,
        MASON,
        NITWIT,
        SHEPHERD,
        TOOLSMITH,
        WEAPONSMITH;

    }

    public static enum Type {
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

    }
}

