/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import org.bukkit.Material;

public abstract class WrappedBlockData
extends AbstractWrapper
implements ClonableWrapper {
    private static final Class<?> MAGIC_NUMBERS = MinecraftReflection.getCraftBukkitClass("util.CraftMagicNumbers");
    private static final Class<?> IBLOCK_DATA = MinecraftReflection.getIBlockDataClass();
    private static final Class<?> BLOCK = MinecraftReflection.getBlockClass();

    public WrappedBlockData(Object handle) {
        super(IBLOCK_DATA);
        this.setHandle(handle);
    }

    public abstract Material getType();

    @Deprecated
    public abstract int getData();

    public abstract void setType(Material var1);

    @Deprecated
    public abstract void setData(int var1);

    @Deprecated
    public abstract void setTypeAndData(Material var1, int var2);

    @Override
    public abstract WrappedBlockData deepClone();

    public static WrappedBlockData createData(Material type) {
        return MinecraftVersion.atOrAbove(MinecraftVersion.AQUATIC_UPDATE) ? NewBlockData.createNewData(type) : OldBlockData.createOldData(type);
    }

    @Deprecated
    public static WrappedBlockData createData(Material type, int data) {
        return MinecraftVersion.atOrAbove(MinecraftVersion.AQUATIC_UPDATE) ? NewBlockData.createNewData(type, data) : OldBlockData.createOldData(type, data);
    }

    public static WrappedBlockData fromHandle(Object handle) {
        return MinecraftVersion.atOrAbove(MinecraftVersion.AQUATIC_UPDATE) ? new NewBlockData(handle) : new OldBlockData(handle);
    }

    public static WrappedBlockData createData(Object data) {
        return NewBlockData.createNewData(data);
    }

    @Override
    public String toString() {
        return "WrappedBlockData[handle=" + this.handle + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.getData();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WrappedBlockData) {
            WrappedBlockData that = (WrappedBlockData)o;
            return this.handle.equals(that.handle) || this.getType() == that.getType() && this.getData() == that.getData();
        }
        return false;
    }

    private static class OldBlockData
    extends WrappedBlockData {
        private static MethodAccessor FROM_LEGACY_DATA;
        private static MethodAccessor TO_LEGACY_DATA;
        private static MethodAccessor GET_NMS_BLOCK;
        private static MethodAccessor GET_BLOCK;

        private OldBlockData(Object handle) {
            super(handle);
        }

        @Override
        public Material getType() {
            Object block = GET_BLOCK.invoke(this.handle, new Object[0]);
            return BukkitConverters.getBlockConverter().getSpecific(block);
        }

        @Override
        public int getData() {
            Object block = GET_BLOCK.invoke(this.handle, new Object[0]);
            return (Integer)TO_LEGACY_DATA.invoke(block, this.handle);
        }

        @Override
        public void setType(Material type) {
            this.setTypeAndData(type, 0);
        }

        @Override
        public void setData(int data) {
            this.setTypeAndData(this.getType(), data);
        }

        @Override
        public void setTypeAndData(Material type, int data) {
            Object nmsBlock = GET_NMS_BLOCK.invoke(null, type);
            Object blockData = FROM_LEGACY_DATA.invoke(nmsBlock, data);
            this.setHandle(blockData);
        }

        @Override
        public WrappedBlockData deepClone() {
            return WrappedBlockData.createData(this.getType(), this.getData());
        }

        private static WrappedBlockData createOldData(Material type) {
            return OldBlockData.createOldData(type, 0);
        }

        private static WrappedBlockData createOldData(Material type, int data) {
            Object nmsBlock = GET_NMS_BLOCK.invoke(null, type);
            Object blockData = FROM_LEGACY_DATA.invoke(nmsBlock, data);
            return new OldBlockData(blockData);
        }

        static {
            if (!MinecraftVersion.atOrAbove(MinecraftVersion.AQUATIC_UPDATE)) {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(BLOCK);
                FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).parameterExactArray(Integer.TYPE).returnTypeExact(IBLOCK_DATA).build();
                FROM_LEGACY_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                contract = FuzzyMethodContract.newBuilder().banModifier(8).parameterExactArray(IBLOCK_DATA).returnTypeExact(Integer.TYPE).build();
                TO_LEGACY_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract, "toLegacyData"));
                fuzzy = FuzzyReflection.fromClass(MAGIC_NUMBERS);
                GET_NMS_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getBlock", (Class<?>)BLOCK, (Class<?>[])new Class[]{Material.class}));
                fuzzy = FuzzyReflection.fromClass(IBLOCK_DATA);
                GET_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getBlock", (Class<?>)BLOCK, (Class<?>[])new Class[0]));
            }
        }
    }

    private static class NewBlockData
    extends WrappedBlockData {
        private static MethodAccessor MATERIAL_FROM_BLOCK;
        private static MethodAccessor TO_LEGACY_DATA;
        private static MethodAccessor GET_BLOCK;
        private static MethodAccessor BLOCK_FROM_MATERIAL;
        private static MethodAccessor GET_BLOCK_DATA;
        private static MethodAccessor FROM_LEGACY_DATA;
        private static MethodAccessor GET_HANDLE;

        private NewBlockData(Object handle) {
            super(handle);
        }

        @Override
        public Material getType() {
            Object block = GET_BLOCK.invoke(this.handle, new Object[0]);
            return (Material)MATERIAL_FROM_BLOCK.invoke(null, block);
        }

        @Override
        public int getData() {
            return ((Number)TO_LEGACY_DATA.invoke(null, this.handle)).intValue();
        }

        @Override
        public void setType(Material material) {
            Object block = BLOCK_FROM_MATERIAL.invoke(null, material);
            this.setHandle(GET_BLOCK_DATA.invoke(block, new Object[0]));
        }

        @Override
        public void setData(int data) {
            this.setTypeAndData(this.getType(), data);
        }

        @Override
        public void setTypeAndData(Material material, int data) {
            this.setHandle(TO_LEGACY_DATA.invoke(null, material, (byte)data));
        }

        @Override
        public WrappedBlockData deepClone() {
            return new NewBlockData(this.handle);
        }

        private static WrappedBlockData createNewData(Material material) {
            Object block = BLOCK_FROM_MATERIAL.invoke(null, material);
            return new NewBlockData(GET_BLOCK_DATA.invoke(block, new Object[0]));
        }

        private static WrappedBlockData createNewData(Material material, int data) {
            return new NewBlockData(FROM_LEGACY_DATA.invoke(null, material, (byte)data));
        }

        private static WrappedBlockData createNewData(Object data) {
            return new NewBlockData(GET_HANDLE.invoke(data, new Object[0]));
        }

        static {
            if (MinecraftVersion.atOrAbove(MinecraftVersion.AQUATIC_UPDATE)) {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(MAGIC_NUMBERS);
                FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(Material.class).parameterExactArray(BLOCK).build();
                MATERIAL_FROM_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                contract = FuzzyMethodContract.newBuilder().requireModifier(8).parameterExactArray(Material.class).returnTypeExact(BLOCK).build();
                BLOCK_FROM_MATERIAL = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                contract = FuzzyMethodContract.newBuilder().requireModifier(8).parameterExactArray(IBLOCK_DATA).returnTypeExact(Byte.TYPE).build();
                TO_LEGACY_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                contract = FuzzyMethodContract.newBuilder().requireModifier(8).parameterExactArray(Material.class, Byte.TYPE).returnTypeExact(IBLOCK_DATA).build();
                FROM_LEGACY_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                fuzzy = FuzzyReflection.fromClass(IBLOCK_DATA);
                contract = FuzzyMethodContract.newBuilder().banModifier(8).returnTypeExact(BLOCK).parameterCount(0).build();
                GET_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                fuzzy = FuzzyReflection.fromClass(BLOCK);
                contract = FuzzyMethodContract.newBuilder().banModifier(8).parameterCount(0).returnTypeExact(IBLOCK_DATA).build();
                GET_BLOCK_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
                fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("block.data.CraftBlockData"));
                contract = FuzzyMethodContract.newBuilder().banModifier(8).parameterCount(0).returnTypeExact(IBLOCK_DATA).build();
                GET_HANDLE = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
            }
        }
    }
}

