/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class WrappedAttributeModifier
extends AbstractWrapper {
    private static final boolean OPERATION_ENUM = MinecraftVersion.atOrAbove(MinecraftVersion.VILLAGE_UPDATE);
    private static final Class<?> OPERATION_CLASS = OPERATION_ENUM ? MinecraftReflection.getMinecraftClass("AttributeModifier$Operation") : null;
    private static final EquivalentConverter<Operation> OPERATION_CONVERTER = OPERATION_ENUM ? new IndexedEnumConverter(Operation.class, OPERATION_CLASS) : null;
    private static StructureModifier<Object> BASE_MODIFIER;
    private static Constructor<?> ATTRIBUTE_MODIFIER_CONSTRUCTOR;
    protected StructureModifier<Object> modifier;
    private final UUID uuid;
    private final Supplier<String> name;
    private final Operation operation;
    private final double amount;

    protected WrappedAttributeModifier(UUID uuid, String name, double amount, Operation operation) {
        super(MinecraftReflection.getAttributeModifierClass());
        this.uuid = uuid;
        this.name = () -> name;
        this.amount = amount;
        this.operation = operation;
    }

    protected WrappedAttributeModifier(@Nonnull Object handle) {
        super(MinecraftReflection.getAttributeModifierClass());
        Supplier<Object> supplier;
        this.setHandle(handle);
        this.initializeModifier(handle);
        this.uuid = (UUID)this.modifier.withType(UUID.class).read(0);
        StructureModifier stringMod = this.modifier.withType(String.class);
        this.name = stringMod.size() == 0 ? (supplier = (Supplier<Object>)this.modifier.withType(Supplier.class).read(0)) : () -> (String)stringMod.read(0);
        this.amount = (Double)this.modifier.withType(Double.TYPE).read(0);
        this.operation = OPERATION_ENUM ? this.modifier.withType(OPERATION_CLASS, OPERATION_CONVERTER).readSafely(0) : Operation.fromId((Integer)this.modifier.withType(Integer.TYPE).readSafely(0));
    }

    protected WrappedAttributeModifier(@Nonnull Object handle, UUID uuid, String name, double amount, Operation operation) {
        this(uuid, name, amount, operation);
        this.setHandle(handle);
        this.initializeModifier(handle);
    }

    public static Builder newBuilder() {
        return new Builder(null).uuid(UUID.randomUUID());
    }

    public static Builder newBuilder(UUID id) {
        return new Builder(null).uuid(id);
    }

    public static Builder newBuilder(@Nonnull WrappedAttributeModifier template) {
        return new Builder((WrappedAttributeModifier)Preconditions.checkNotNull((Object)template, (Object)"template cannot be NULL."));
    }

    public static WrappedAttributeModifier fromHandle(@Nonnull Object handle) {
        return new WrappedAttributeModifier(handle);
    }

    private void initializeModifier(@Nonnull Object handle) {
        if (BASE_MODIFIER == null) {
            BASE_MODIFIER = new StructureModifier(MinecraftReflection.getAttributeModifierClass());
        }
        this.modifier = BASE_MODIFIER.withTarget(handle);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name.get();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public double getAmount() {
        return this.amount;
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }

    public void setPendingSynchronization(boolean pending) {
        this.modifier.withType(Boolean.TYPE).write(0, pending);
    }

    public boolean isPendingSynchronization() {
        return (Boolean)this.modifier.withType(Boolean.TYPE).read(0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedAttributeModifier) {
            WrappedAttributeModifier other = (WrappedAttributeModifier)obj;
            return Objects.equal((Object)this.uuid, (Object)other.getUUID());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "[amount=" + this.amount + ", operation=" + (Object)((Object)this.operation) + ", name='" + this.name + "', id=" + this.uuid + ", serialize=" + this.isPendingSynchronization() + "]";
    }

    private static Object getOperationParam(Operation operation) {
        return OPERATION_ENUM ? OPERATION_CONVERTER.getGeneric(operation) : Integer.valueOf(operation.getId());
    }

    private static Constructor<?> getConstructor() {
        FuzzyMethodContract.Builder builder = FuzzyMethodContract.newBuilder().parameterCount(4).parameterDerivedOf(UUID.class, 0).parameterExactType(String.class, 1).parameterExactType(Double.TYPE, 2);
        builder = OPERATION_ENUM ? builder.parameterExactType(OPERATION_CLASS, 3) : builder.parameterExactType(Integer.TYPE, 3);
        Constructor<?> ret = FuzzyReflection.fromClass(MinecraftReflection.getAttributeModifierClass(), true).getConstructor(builder.build());
        ret.setAccessible(true);
        return ret;
    }

    public static class Builder {
        private Operation operation = Operation.ADD_NUMBER;
        private String name = "Unknown";
        private double amount;
        private UUID uuid;

        private Builder(WrappedAttributeModifier template) {
            if (template != null) {
                this.operation = template.getOperation();
                this.name = template.getName();
                this.amount = template.getAmount();
                this.uuid = template.getUUID();
            }
        }

        public Builder uuid(@Nonnull UUID uuid) {
            this.uuid = (UUID)Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be NULL.");
            return this;
        }

        public Builder operation(@Nonnull Operation operation) {
            this.operation = (Operation)((Object)Preconditions.checkNotNull((Object)((Object)operation), (Object)"operation cannot be NULL."));
            return this;
        }

        public Builder name(@Nonnull String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be NULL.");
            return this;
        }

        public Builder amount(double amount) {
            this.amount = WrappedAttribute.checkDouble(amount);
            return this;
        }

        public WrappedAttributeModifier build() {
            Preconditions.checkNotNull((Object)this.uuid, (Object)"uuid cannot be NULL.");
            if (ATTRIBUTE_MODIFIER_CONSTRUCTOR == null) {
                ATTRIBUTE_MODIFIER_CONSTRUCTOR = WrappedAttributeModifier.getConstructor();
            }
            try {
                return new WrappedAttributeModifier(ATTRIBUTE_MODIFIER_CONSTRUCTOR.newInstance(this.uuid, this.name, this.amount, WrappedAttributeModifier.getOperationParam(this.operation)), this.uuid, this.name, this.amount, this.operation);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot construct AttributeModifier.", e);
            }
        }
    }

    public static enum Operation {
        ADD_NUMBER(0),
        MULTIPLY_PERCENTAGE(1),
        ADD_PERCENTAGE(2);

        private int id;

        private Operation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Operation fromId(int id) {
            for (Operation op : Operation.values()) {
                if (op.getId() != id) continue;
                return op;
            }
            throw new IllegalArgumentException("Corrupt operation ID " + id + " detected.");
        }
    }

    private static class IndexedEnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<T> specificClass;
        private Class<?> genericClass;

        private IndexedEnumConverter(Class<T> specificClass, Class<?> genericClass) {
            this.specificClass = specificClass;
            this.genericClass = genericClass;
        }

        @Override
        public Object getGeneric(T specific) {
            int ordinal = ((Enum)specific).ordinal();
            for (Object elem : this.genericClass.getEnumConstants()) {
                if (((Enum)elem).ordinal() != ordinal) continue;
                return elem;
            }
            return null;
        }

        @Override
        public T getSpecific(Object generic) {
            int ordinal = ((Enum)generic).ordinal();
            for (Enum elem : (Enum[])this.specificClass.getEnumConstants()) {
                if (elem.ordinal() != ordinal) continue;
                return (T)elem;
            }
            return null;
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificClass;
        }
    }
}

