/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;

public abstract class EnumWrappers {
    private static Class<?> PROTOCOL_CLASS = null;
    private static Class<?> CLIENT_COMMAND_CLASS = null;
    private static Class<?> CHAT_VISIBILITY_CLASS = null;
    private static Class<?> DIFFICULTY_CLASS = null;
    private static Class<?> ENTITY_USE_ACTION_CLASS = null;
    private static Class<?> GAMEMODE_CLASS = null;
    private static Class<?> RESOURCE_PACK_STATUS_CLASS = null;
    private static Class<?> PLAYER_INFO_ACTION_CLASS = null;
    private static Class<?> TITLE_ACTION_CLASS = null;
    private static Class<?> WORLD_BORDER_ACTION_CLASS = null;
    private static Class<?> COMBAT_EVENT_TYPE_CLASS = null;
    private static Class<?> PLAYER_DIG_TYPE_CLASS = null;
    private static Class<?> PLAYER_ACTION_CLASS = null;
    private static Class<?> SCOREBOARD_ACTION_CLASS = null;
    private static Class<?> PARTICLE_CLASS = null;
    private static Class<?> SOUND_CATEGORY_CLASS = null;
    private static Class<?> ITEM_SLOT_CLASS = null;
    private static Class<?> HAND_CLASS = null;
    private static Class<?> DIRECTION_CLASS = null;
    private static Class<?> CHAT_TYPE_CLASS = null;
    private static boolean INITIALIZED = false;
    private static Map<Class<?>, EquivalentConverter<?>> FROM_NATIVE = Maps.newHashMap();
    private static Map<Class<?>, EquivalentConverter<?>> FROM_WRAPPER = Maps.newHashMap();

    private static void initialize() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalArgumentException("Not supported on 1.6.4 and earlier.");
        }
        if (INITIALIZED) {
            return;
        }
        INITIALIZED = true;
        PROTOCOL_CLASS = EnumWrappers.getEnum(PacketType.Handshake.Client.SET_PROTOCOL.getPacketClass(), 0);
        CLIENT_COMMAND_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.CLIENT_COMMAND.getPacketClass(), 0);
        CHAT_VISIBILITY_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.SETTINGS.getPacketClass(), 0);
        try {
            DIFFICULTY_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.SERVER_DIFFICULTY.getPacketClass(), 0);
        }
        catch (Exception ex) {
            DIFFICULTY_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.LOGIN.getPacketClass(), 1);
        }
        ENTITY_USE_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.USE_ENTITY.getPacketClass(), 0);
        GAMEMODE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.LOGIN.getPacketClass(), 0);
        RESOURCE_PACK_STATUS_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.RESOURCE_PACK_STATUS.getPacketClass(), 0);
        PLAYER_INFO_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.PLAYER_INFO.getPacketClass(), 0);
        TITLE_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.TITLE.getPacketClass(), 0);
        WORLD_BORDER_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.WORLD_BORDER.getPacketClass(), 0);
        COMBAT_EVENT_TYPE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.COMBAT_EVENT.getPacketClass(), 0);
        PLAYER_DIG_TYPE_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.BLOCK_DIG.getPacketClass(), 1);
        PLAYER_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.ENTITY_ACTION.getPacketClass(), 0);
        SCOREBOARD_ACTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.SCOREBOARD_SCORE.getPacketClass(), 0);
        PARTICLE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.WORLD_PARTICLES.getPacketClass(), 0);
        SOUND_CATEGORY_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.CUSTOM_SOUND_EFFECT.getPacketClass(), 0);
        ITEM_SLOT_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.ENTITY_EQUIPMENT.getPacketClass(), 0);
        HAND_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.USE_ENTITY.getPacketClass(), 1);
        DIRECTION_CLASS = EnumWrappers.getEnum(PacketType.Play.Client.USE_ITEM.getPacketClass(), 0);
        CHAT_TYPE_CLASS = EnumWrappers.getEnum(PacketType.Play.Server.CHAT.getPacketClass(), 0);
        EnumWrappers.associate(PROTOCOL_CLASS, PacketType.Protocol.class, EnumWrappers.getClientCommandConverter());
        EnumWrappers.associate(CLIENT_COMMAND_CLASS, ClientCommand.class, EnumWrappers.getClientCommandConverter());
        EnumWrappers.associate(CHAT_VISIBILITY_CLASS, ChatVisibility.class, EnumWrappers.getChatVisibilityConverter());
        EnumWrappers.associate(DIFFICULTY_CLASS, Difficulty.class, EnumWrappers.getDifficultyConverter());
        EnumWrappers.associate(ENTITY_USE_ACTION_CLASS, EntityUseAction.class, EnumWrappers.getEntityUseActionConverter());
        EnumWrappers.associate(GAMEMODE_CLASS, NativeGameMode.class, EnumWrappers.getGameModeConverter());
        EnumWrappers.associate(RESOURCE_PACK_STATUS_CLASS, ResourcePackStatus.class, EnumWrappers.getResourcePackStatusConverter());
        EnumWrappers.associate(PLAYER_INFO_ACTION_CLASS, PlayerInfoAction.class, EnumWrappers.getPlayerInfoActionConverter());
        EnumWrappers.associate(TITLE_ACTION_CLASS, TitleAction.class, EnumWrappers.getTitleActionConverter());
        EnumWrappers.associate(WORLD_BORDER_ACTION_CLASS, WorldBorderAction.class, EnumWrappers.getWorldBorderActionConverter());
        EnumWrappers.associate(COMBAT_EVENT_TYPE_CLASS, CombatEventType.class, EnumWrappers.getCombatEventTypeConverter());
        EnumWrappers.associate(PLAYER_DIG_TYPE_CLASS, PlayerDigType.class, EnumWrappers.getPlayerDiggingActionConverter());
        EnumWrappers.associate(PLAYER_ACTION_CLASS, PlayerAction.class, EnumWrappers.getEntityActionConverter());
        EnumWrappers.associate(SCOREBOARD_ACTION_CLASS, ScoreboardAction.class, EnumWrappers.getUpdateScoreActionConverter());
        EnumWrappers.associate(PARTICLE_CLASS, Particle.class, EnumWrappers.getParticleConverter());
        EnumWrappers.associate(SOUND_CATEGORY_CLASS, SoundCategory.class, EnumWrappers.getSoundCategoryConverter());
        EnumWrappers.associate(ITEM_SLOT_CLASS, ItemSlot.class, EnumWrappers.getItemSlotConverter());
        EnumWrappers.associate(HAND_CLASS, Hand.class, EnumWrappers.getHandConverter());
        EnumWrappers.associate(DIRECTION_CLASS, Direction.class, EnumWrappers.getDirectionConverter());
        EnumWrappers.associate(CHAT_TYPE_CLASS, ChatType.class, EnumWrappers.getChatTypeConverter());
        INITIALIZED = true;
    }

    private static void associate(Class<?> nativeClass, Class<?> wrapperClass, EquivalentConverter<?> converter) {
        if (nativeClass != null) {
            FROM_NATIVE.put(nativeClass, converter);
            FROM_WRAPPER.put(wrapperClass, converter);
        }
    }

    private static Class<?> getEnum(Class<?> clazz, int index) {
        try {
            return FuzzyReflection.fromClass(clazz, true).getFieldListByType(Enum.class).get(index).getType();
        }
        catch (Throwable ex) {
            ProtocolLogger.debug("Exception getting enum from " + clazz + " at index " + index, ex);
            return null;
        }
    }

    public static Map<Class<?>, EquivalentConverter<?>> getFromNativeMap() {
        return FROM_NATIVE;
    }

    public static Map<Class<?>, EquivalentConverter<?>> getFromWrapperMap() {
        return FROM_WRAPPER;
    }

    public static Class<?> getProtocolClass() {
        EnumWrappers.initialize();
        return PROTOCOL_CLASS;
    }

    public static Class<?> getClientCommandClass() {
        EnumWrappers.initialize();
        return CLIENT_COMMAND_CLASS;
    }

    public static Class<?> getChatVisibilityClass() {
        EnumWrappers.initialize();
        return CHAT_VISIBILITY_CLASS;
    }

    public static Class<?> getDifficultyClass() {
        EnumWrappers.initialize();
        return DIFFICULTY_CLASS;
    }

    public static Class<?> getEntityUseActionClass() {
        EnumWrappers.initialize();
        return ENTITY_USE_ACTION_CLASS;
    }

    public static Class<?> getGameModeClass() {
        EnumWrappers.initialize();
        return GAMEMODE_CLASS;
    }

    public static Class<?> getResourcePackStatusClass() {
        EnumWrappers.initialize();
        return RESOURCE_PACK_STATUS_CLASS;
    }

    public static Class<?> getPlayerInfoActionClass() {
        EnumWrappers.initialize();
        return PLAYER_INFO_ACTION_CLASS;
    }

    public static Class<?> getTitleActionClass() {
        EnumWrappers.initialize();
        return TITLE_ACTION_CLASS;
    }

    public static Class<?> getWorldBorderActionClass() {
        EnumWrappers.initialize();
        return WORLD_BORDER_ACTION_CLASS;
    }

    public static Class<?> getCombatEventTypeClass() {
        EnumWrappers.initialize();
        return COMBAT_EVENT_TYPE_CLASS;
    }

    public static Class<?> getPlayerDigTypeClass() {
        EnumWrappers.initialize();
        return PLAYER_DIG_TYPE_CLASS;
    }

    public static Class<?> getPlayerActionClass() {
        EnumWrappers.initialize();
        return PLAYER_ACTION_CLASS;
    }

    public static Class<?> getScoreboardActionClass() {
        EnumWrappers.initialize();
        return SCOREBOARD_ACTION_CLASS;
    }

    public static Class<?> getParticleClass() {
        EnumWrappers.initialize();
        return PARTICLE_CLASS;
    }

    public static Class<?> getSoundCategoryClass() {
        EnumWrappers.initialize();
        return SOUND_CATEGORY_CLASS;
    }

    public static Class<?> getItemSlotClass() {
        EnumWrappers.initialize();
        return ITEM_SLOT_CLASS;
    }

    public static Class<?> getHandClass() {
        EnumWrappers.initialize();
        return HAND_CLASS;
    }

    public static Class<?> getDirectionClass() {
        EnumWrappers.initialize();
        return DIRECTION_CLASS;
    }

    public static Class<?> getChatTypeClass() {
        EnumWrappers.initialize();
        return CHAT_TYPE_CLASS;
    }

    public static EquivalentConverter<PacketType.Protocol> getProtocolConverter() {
        return new EnumConverter<PacketType.Protocol>(EnumWrappers.getProtocolClass(), PacketType.Protocol.class);
    }

    public static EquivalentConverter<ClientCommand> getClientCommandConverter() {
        return new EnumConverter<ClientCommand>(EnumWrappers.getClientCommandClass(), ClientCommand.class);
    }

    public static EquivalentConverter<ChatVisibility> getChatVisibilityConverter() {
        return new EnumConverter<ChatVisibility>(EnumWrappers.getChatVisibilityClass(), ChatVisibility.class);
    }

    public static EquivalentConverter<Difficulty> getDifficultyConverter() {
        return new EnumConverter<Difficulty>(EnumWrappers.getDifficultyClass(), Difficulty.class);
    }

    public static EquivalentConverter<EntityUseAction> getEntityUseActionConverter() {
        return new EnumConverter<EntityUseAction>(EnumWrappers.getEntityUseActionClass(), EntityUseAction.class);
    }

    public static EquivalentConverter<NativeGameMode> getGameModeConverter() {
        return new EnumConverter<NativeGameMode>(EnumWrappers.getGameModeClass(), NativeGameMode.class);
    }

    public static EquivalentConverter<ResourcePackStatus> getResourcePackStatusConverter() {
        return new EnumConverter<ResourcePackStatus>(EnumWrappers.getResourcePackStatusClass(), ResourcePackStatus.class);
    }

    public static EquivalentConverter<PlayerInfoAction> getPlayerInfoActionConverter() {
        return new EnumConverter<PlayerInfoAction>(EnumWrappers.getPlayerInfoActionClass(), PlayerInfoAction.class);
    }

    public static EquivalentConverter<TitleAction> getTitleActionConverter() {
        return new EnumConverter<TitleAction>(EnumWrappers.getTitleActionClass(), TitleAction.class);
    }

    public static EquivalentConverter<WorldBorderAction> getWorldBorderActionConverter() {
        return new EnumConverter<WorldBorderAction>(EnumWrappers.getWorldBorderActionClass(), WorldBorderAction.class);
    }

    public static EquivalentConverter<CombatEventType> getCombatEventTypeConverter() {
        return new EnumConverter<CombatEventType>(EnumWrappers.getCombatEventTypeClass(), CombatEventType.class);
    }

    public static EquivalentConverter<PlayerDigType> getPlayerDiggingActionConverter() {
        return new EnumConverter<PlayerDigType>(EnumWrappers.getPlayerDigTypeClass(), PlayerDigType.class);
    }

    public static EquivalentConverter<PlayerAction> getEntityActionConverter() {
        return new AliasedEnumConverter<PlayerAction>(EnumWrappers.getPlayerActionClass(), PlayerAction.class);
    }

    public static EquivalentConverter<ScoreboardAction> getUpdateScoreActionConverter() {
        return new EnumConverter<ScoreboardAction>(EnumWrappers.getScoreboardActionClass(), ScoreboardAction.class);
    }

    public static EquivalentConverter<Particle> getParticleConverter() {
        return new EnumConverter<Particle>(EnumWrappers.getParticleClass(), Particle.class);
    }

    public static EquivalentConverter<SoundCategory> getSoundCategoryConverter() {
        return new EnumConverter<SoundCategory>(EnumWrappers.getSoundCategoryClass(), SoundCategory.class);
    }

    public static EquivalentConverter<ItemSlot> getItemSlotConverter() {
        return new EnumConverter<ItemSlot>(EnumWrappers.getItemSlotClass(), ItemSlot.class);
    }

    public static EquivalentConverter<Hand> getHandConverter() {
        return new EnumConverter<Hand>(EnumWrappers.getHandClass(), Hand.class);
    }

    public static EquivalentConverter<Direction> getDirectionConverter() {
        return new EnumConverter<Direction>(EnumWrappers.getDirectionClass(), Direction.class);
    }

    public static EquivalentConverter<ChatType> getChatTypeConverter() {
        return new EnumConverter<ChatType>(EnumWrappers.getChatTypeClass(), ChatType.class);
    }

    public static <T extends Enum<T>> EquivalentConverter<T> getGenericConverter(Class<?> genericClass, Class<T> specificType) {
        return new EnumConverter<T>(genericClass, specificType);
    }

    @Deprecated
    public static <T extends Enum<T>> EquivalentConverter<T> getGenericConverter(Class<T> specificType) {
        return new EnumConverter<T>(null, specificType);
    }

    public static class IndexedEnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<T> specificClass;
        private Class<?> genericClass;

        public IndexedEnumConverter(Class<T> specificClass, Class<?> genericClass) {
            this.specificClass = specificClass;
            this.genericClass = genericClass;
        }

        @Override
        public Object getGeneric(T specific) {
            int ordinal = ((Enum)specific).ordinal();
            for (Object elem : this.genericClass.getEnumConstants()) {
                if (((Enum)elem).ordinal() != ordinal) continue;
                return elem;
            }
            return null;
        }

        @Override
        public T getSpecific(Object generic) {
            int ordinal = ((Enum)generic).ordinal();
            for (Enum elem : (Enum[])this.specificClass.getEnumConstants()) {
                if (elem.ordinal() != ordinal) continue;
                return (T)elem;
            }
            return null;
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificClass;
        }
    }

    public static class FauxEnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private final Class<T> specificClass;
        private final Class<?> genericClass;
        private final Map<Object, T> lookup;

        public FauxEnumConverter(Class<T> specific, Class<?> generic) {
            Validate.notNull(specific, (String)"specific class cannot be null");
            Validate.notNull(generic, (String)"generic class cannot be null");
            this.specificClass = specific;
            this.genericClass = generic;
            this.lookup = new HashMap<Object, T>();
        }

        @Override
        public Object getGeneric(T specific) {
            Validate.notNull(specific, (String)"specific object cannot be null");
            return Accessors.getFieldAccessor(this.genericClass, ((Enum)specific).name(), false).get(null);
        }

        @Override
        public T getSpecific(Object generic) {
            Validate.notNull((Object)generic, (String)"generic object cannot be null");
            return (T)this.lookup.computeIfAbsent(generic, x -> {
                for (Field field : this.genericClass.getFields()) {
                    try {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        if (field.get(null) != generic) continue;
                        return Enum.valueOf(this.specificClass, field.getName().toUpperCase());
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Could not find ProtocolLib wrapper for " + generic);
            });
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificClass;
        }
    }

    public static class AliasedEnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<?> genericType;
        private Class<T> specificType;
        private Map<T, Object> genericMap = new ConcurrentHashMap<T, Object>();
        private Map<Object, T> specificMap = new ConcurrentHashMap<Object, T>();

        public AliasedEnumConverter(Class<?> genericType, Class<T> specificType) {
            this.genericType = genericType;
            this.specificType = specificType;
        }

        @Override
        public T getSpecific(Object generic) {
            return (T)this.specificMap.computeIfAbsent(generic, x -> {
                String name = ((Enum)generic).name();
                try {
                    return Enum.valueOf(this.specificType, name);
                }
                catch (Exception ex) {
                    for (Enum elem : (Enum[])this.specificType.getEnumConstants()) {
                        for (String alias : ((AliasedEnum)((Object)elem)).getAliases()) {
                            if (!alias.equals(name)) continue;
                            return elem;
                        }
                    }
                    throw new IllegalArgumentException("Unknown enum constant " + name);
                }
            });
        }

        @Override
        public Object getGeneric(T specific) {
            return this.genericMap.computeIfAbsent(specific, x -> {
                String name = specific.name();
                try {
                    return Enum.valueOf(this.genericType, specific.name());
                }
                catch (Exception ex) {
                    for (Object rawElem : this.genericType.getEnumConstants()) {
                        Enum elem = (Enum)rawElem;
                        for (String alias : ((AliasedEnum)((Object)specific)).getAliases()) {
                            if (!alias.equals(elem.name())) continue;
                            return elem;
                        }
                    }
                    throw new IllegalArgumentException("Unknown enum constant " + name);
                }
            });
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificType;
        }
    }

    public static interface AliasedEnum {
        public String[] getAliases();
    }

    public static class EnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<?> genericType;
        private Class<T> specificType;

        public EnumConverter(Class<?> genericType, Class<T> specificType) {
            this.genericType = genericType;
            this.specificType = specificType;
        }

        @Override
        public T getSpecific(Object generic) {
            return Enum.valueOf(this.specificType, ((Enum)generic).name());
        }

        @Override
        public Object getGeneric(T specific) {
            return Enum.valueOf(this.genericType, ((Enum)specific).name());
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificType;
        }

        void setGenericType(Class<?> genericType) {
            this.genericType = genericType;
        }
    }

    public static enum ChatType {
        CHAT,
        SYSTEM,
        GAME_INFO;


        public byte getId() {
            return (byte)this.ordinal();
        }
    }

    public static enum Direction {
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;

    }

    public static enum Hand {
        MAIN_HAND,
        OFF_HAND;

    }

    public static enum ItemSlot {
        MAINHAND,
        OFFHAND,
        FEET,
        LEGS,
        CHEST,
        HEAD;

    }

    public static enum SoundCategory {
        MASTER("master"),
        MUSIC("music"),
        RECORDS("record"),
        WEATHER("weather"),
        BLOCKS("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYERS("player"),
        AMBIENT("ambient"),
        VOICE("voice");

        private static final Map<String, SoundCategory> LOOKUP;
        private final String key;

        private SoundCategory(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static SoundCategory getByKey(String key) {
            return LOOKUP.get(key.toLowerCase(Locale.ENGLISH));
        }

        static {
            LOOKUP = new HashMap<String, SoundCategory>();
            for (SoundCategory category : SoundCategory.values()) {
                LOOKUP.put(category.key, category);
            }
        }
    }

    public static enum Particle {
        EXPLOSION_NORMAL("explode", 0, true),
        EXPLOSION_LARGE("largeexplode", 1, true),
        EXPLOSION_HUGE("hugeexplosion", 2, true),
        FIREWORKS_SPARK("fireworksSpark", 3, false),
        WATER_BUBBLE("bubble", 4, false),
        WATER_SPLASH("splash", 5, false),
        WATER_WAKE("wake", 6, false),
        SUSPENDED("suspended", 7, false),
        SUSPENDED_DEPTH("depthsuspend", 8, false),
        CRIT("crit", 9, false),
        CRIT_MAGIC("magicCrit", 10, false),
        SMOKE_NORMAL("smoke", 11, false),
        SMOKE_LARGE("largesmoke", 12, false),
        SPELL("spell", 13, false),
        SPELL_INSTANT("instantSpell", 14, false),
        SPELL_MOB("mobSpell", 15, false),
        SPELL_MOB_AMBIENT("mobSpellAmbient", 16, false),
        SPELL_WITCH("witchMagic", 17, false),
        DRIP_WATER("dripWater", 18, false),
        DRIP_LAVA("dripLava", 19, false),
        VILLAGER_ANGRY("angryVillager", 20, false),
        VILLAGER_HAPPY("happyVillager", 21, false),
        TOWN_AURA("townaura", 22, false),
        NOTE("note", 23, false),
        PORTAL("portal", 24, false),
        ENCHANTMENT_TABLE("enchantmenttable", 25, false),
        FLAME("flame", 26, false),
        LAVA("lava", 27, false),
        FOOTSTEP("footstep", 28, false),
        CLOUD("cloud", 29, false),
        REDSTONE("reddust", 30, false),
        SNOWBALL("snowballpoof", 31, false),
        SNOW_SHOVEL("snowshovel", 32, false),
        SLIME("slime", 33, false),
        HEART("heart", 34, false),
        BARRIER("barrier", 35, false),
        ITEM_CRACK("iconcrack", 36, false, 2),
        BLOCK_CRACK("blockcrack", 37, false, 1),
        BLOCK_DUST("blockdust", 38, false, 1),
        WATER_DROP("droplet", 39, false),
        ITEM_TAKE("take", 40, false),
        MOB_APPEARANCE("mobappearance", 41, true),
        DRAGON_BREATH("dragonbreath", 42, false),
        END_ROD("endRod", 43, false),
        DAMAGE_INDICATOR("damageIndicator", 44, true),
        SWEEP_ATTACK("sweepAttack", 45, true),
        FALLING_DUST("fallingdust", 46, false, 1),
        TOTEM("totem", 47, false),
        SPIT("spit", 48, true);

        private static final Map<String, Particle> BY_NAME;
        private static final Map<Integer, Particle> BY_ID;
        private final String name;
        private final int id;
        private final boolean longDistance;
        private final int dataLength;

        private Particle(String name, int id, boolean longDistance) {
            this(name, id, longDistance, 0);
        }

        private Particle(String name, int id, boolean longDistance, int dataLength) {
            this.name = name;
            this.id = id;
            this.longDistance = longDistance;
            this.dataLength = dataLength;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public boolean isLongDistance() {
            return this.longDistance;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public static Particle getByName(String name) {
            return BY_NAME.get(name.toLowerCase(Locale.ENGLISH));
        }

        public static Particle getById(int id) {
            return BY_ID.get(id);
        }

        static {
            BY_ID = new HashMap<Integer, Particle>();
            BY_NAME = new HashMap<String, Particle>();
            for (Particle particle : Particle.values()) {
                BY_NAME.put(particle.getName().toLowerCase(Locale.ENGLISH), particle);
                BY_ID.put(particle.getId(), particle);
            }
        }
    }

    public static enum ScoreboardAction {
        CHANGE,
        REMOVE;

    }

    public static enum PlayerAction implements AliasedEnum
    {
        START_SNEAKING("PRESS_SHIFT_KEY"),
        STOP_SNEAKING("RELEASE_SHIFT_KEY"),
        STOP_SLEEPING(new String[0]),
        START_SPRINTING(new String[0]),
        STOP_SPRINTING(new String[0]),
        START_RIDING_JUMP(new String[0]),
        STOP_RIDING_JUMP(new String[0]),
        OPEN_INVENTORY(new String[0]),
        START_FALL_FLYING(new String[0]);

        String[] aliases;

        private PlayerAction(String ... aliases) {
            this.aliases = aliases;
        }

        @Override
        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static enum PlayerDigType {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        DROP_ALL_ITEMS,
        DROP_ITEM,
        RELEASE_USE_ITEM,
        SWAP_HELD_ITEMS;

    }

    public static enum CombatEventType {
        ENTER_COMBAT,
        END_COMBAT,
        ENTITY_DIED;

    }

    public static enum WorldBorderAction {
        SET_SIZE,
        LERP_SIZE,
        SET_CENTER,
        INITIALIZE,
        SET_WARNING_TIME,
        SET_WARNING_BLOCKS;

    }

    public static enum TitleAction {
        TITLE,
        SUBTITLE,
        ACTIONBAR,
        TIMES,
        CLEAR,
        RESET;

    }

    public static enum PlayerInfoAction {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    public static enum ResourcePackStatus {
        SUCCESSFULLY_LOADED,
        DECLINED,
        FAILED_DOWNLOAD,
        ACCEPTED;

    }

    public static enum NativeGameMode {
        NOT_SET,
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        SPECTATOR,
        NONE;


        public GameMode toBukkit() {
            switch (this) {
                case ADVENTURE: {
                    return GameMode.ADVENTURE;
                }
                case CREATIVE: {
                    return GameMode.CREATIVE;
                }
                case SPECTATOR: {
                    return GameMode.SPECTATOR;
                }
                case SURVIVAL: {
                    return GameMode.SURVIVAL;
                }
            }
            return null;
        }

        public static NativeGameMode fromBukkit(GameMode mode) {
            switch (mode) {
                case ADVENTURE: {
                    return ADVENTURE;
                }
                case CREATIVE: {
                    return CREATIVE;
                }
                case SPECTATOR: {
                    return SPECTATOR;
                }
                case SURVIVAL: {
                    return SURVIVAL;
                }
            }
            return null;
        }
    }

    public static enum EntityUseAction {
        INTERACT,
        ATTACK,
        INTERACT_AT;

    }

    public static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

    }

    public static enum ChatVisibility {
        FULL,
        SYSTEM,
        HIDDEN;

    }

    public static enum ClientCommand {
        PERFORM_RESPAWN,
        REQUEST_STATS,
        OPEN_INVENTORY_ACHIEVEMENT;

    }
}

