/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public class ProtocolLogger {
    private static boolean debugEnabled = false;
    private static Logger logger = Logger.getLogger("Minecraft");

    protected static void init(Plugin plugin) {
        logger = plugin.getLogger();
        try {
            debugEnabled = plugin.getConfig().getBoolean("global.debug", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void log(Level level, String message, Object ... args) {
        logger.log(level, MessageFormat.format(message, args));
    }

    public static void log(String message, Object ... args) {
        ProtocolLogger.log(Level.INFO, message, args);
    }

    public static void log(Level level, String message, Throwable ex) {
        logger.log(level, message, ex);
    }

    public static void debug(String message, Object ... args) {
        if (debugEnabled) {
            ProtocolLogger.log("[Debug] " + message, args);
        }
    }

    public static void debug(String message, Throwable ex) {
        if (debugEnabled) {
            logger.log(Level.WARNING, "[Debug] " + message, ex);
        }
    }
}

