/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.primitives.Primitives;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.PublicKey;
import java.util.Locale;
import java.util.UUID;
import javax.crypto.SecretKey;

public class ImmutableDetector
implements Cloner {
    private static final Class<?>[] immutableClasses = new Class[]{StackTraceElement.class, BigDecimal.class, BigInteger.class, Locale.class, UUID.class, URL.class, URI.class, Inet4Address.class, Inet6Address.class, InetSocketAddress.class, SecretKey.class, PublicKey.class};

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        return ImmutableDetector.isImmutable(source.getClass());
    }

    public static boolean isImmutable(Class<?> type) {
        if (type.isArray()) {
            return false;
        }
        if (Primitives.isWrapperType(type) || String.class.equals(type)) {
            return true;
        }
        if (ImmutableDetector.isEnumWorkaround(type)) {
            return true;
        }
        for (Class<?> clazz : immutableClasses) {
            if (!clazz.equals(type)) continue;
            return true;
        }
        if (MinecraftReflection.isUsingNetty() && type.equals(MinecraftReflection.getGameProfileClass())) {
            return true;
        }
        if (MinecraftReflection.watcherObjectExists() && (type.equals(MinecraftReflection.getDataWatcherSerializerClass()) || type.equals(MinecraftReflection.getMinecraftClass("SoundEffect")))) {
            return true;
        }
        if (MinecraftReflection.is(MinecraftReflection.getBlockClass(), type) || MinecraftReflection.is(MinecraftReflection.getItemClass(), type) || MinecraftReflection.is(MinecraftReflection.getFluidTypeClass(), type)) {
            return true;
        }
        return type.getName().contains("$$Lambda$");
    }

    private static boolean isEnumWorkaround(Class<?> enumClass) {
        while (enumClass != null) {
            if (enumClass.isEnum()) {
                return true;
            }
            enumClass = enumClass.getSuperclass();
        }
        return false;
    }

    @Override
    public Object clone(Object source) {
        return source;
    }
}

