/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class DefaultConstrutorAccessor
implements ConstructorAccessor {
    private final Constructor<?> constructor;

    public DefaultConstrutorAccessor(Constructor<?> method) {
        this.constructor = method;
    }

    @Override
    public Object invoke(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot use reflection.", e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An internal error occured.", e.getCause());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate object.", e);
        }
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public int hashCode() {
        return this.constructor != null ? this.constructor.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConstrutorAccessor) {
            DefaultConstrutorAccessor other = (DefaultConstrutorAccessor)obj;
            return other.constructor == this.constructor;
        }
        return true;
    }

    public String toString() {
        return "DefaultConstrutorAccessor [constructor=" + this.constructor + "]";
    }
}

