/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.net.sf.cglib.proxy.Factory;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.NetworkProcessor;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.ChannelProxy;
import com.comphenix.protocol.injector.netty.InjectionFactory;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.NettyNetworkMarker;
import com.comphenix.protocol.injector.netty.PipelineProxy;
import com.comphenix.protocol.injector.netty.SocketAdapter;
import com.comphenix.protocol.injector.netty.WirePacket;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.VolatileField;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftProtocolVersion;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.TypeParameterMatcher;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ChannelInjector
extends ByteToMessageDecoder
implements Injector {
    public static final ReportType REPORT_CANNOT_INTERCEPT_SERVER_PACKET = new ReportType("Unable to intercept a written server packet.");
    public static final ReportType REPORT_CANNOT_INTERCEPT_CLIENT_PACKET = new ReportType("Unable to intercept a read client packet.");
    public static final ReportType REPORT_CANNOT_EXECUTE_IN_CHANNEL_THREAD = new ReportType("Cannot execute code in channel thread.");
    public static final ReportType REPORT_CANNOT_FIND_GET_VERSION = new ReportType("Cannot find getVersion() in NetworkMananger");
    public static final ReportType REPORT_CANNOT_SEND_PACKET = new ReportType("Unable to send packet %s to %s");
    private static final PacketEvent BYPASSED_PACKET = new PacketEvent(ChannelInjector.class);
    private static Class<?> PACKET_LOGIN_CLIENT = null;
    private static FieldAccessor LOGIN_GAME_PROFILE = null;
    private static Class<?> PACKET_SET_PROTOCOL = null;
    private static AtomicInteger keyId = new AtomicInteger();
    private static AttributeKey<Integer> PROTOCOL_KEY;
    private static MethodAccessor DECODE_BUFFER;
    private static MethodAccessor ENCODE_BUFFER;
    private static FieldAccessor ENCODER_TYPE_MATCHER;
    private static FieldAccessor PROTOCOL_ACCESSOR;
    private InjectionFactory factory;
    private Player player;
    private Player updated;
    private String playerName;
    private Object playerConnection;
    private final Object networkManager;
    private final Channel originalChannel;
    private VolatileField channelField;
    private ConcurrentMap<Object, NetworkMarker> packetMarker = new MapMaker().weakKeys().makeMap();
    private PacketEvent currentEvent;
    private PacketEvent finalEvent;
    private final ThreadLocal<Boolean> scheduleProcessPackets = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private ByteToMessageDecoder vanillaDecoder;
    private MessageToByteEncoder<Object> vanillaEncoder;
    private Deque<PacketEvent> finishQueue = new ArrayDeque<PacketEvent>();
    private ChannelListener channelListener;
    private NetworkProcessor processor;
    private boolean injected;
    private boolean closed;

    public ChannelInjector(Player player, Object networkManager, Channel channel, ChannelListener channelListener, InjectionFactory factory) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player cannot be NULL");
        this.networkManager = Preconditions.checkNotNull((Object)networkManager, (Object)"networkMananger cannot be NULL");
        this.originalChannel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel cannot be NULL");
        this.channelListener = (ChannelListener)Preconditions.checkNotNull((Object)channelListener, (Object)"channelListener cannot be NULL");
        this.factory = (InjectionFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory cannot be NULL");
        this.processor = new NetworkProcessor(ProtocolLibrary.getErrorReporter());
        this.channelField = new VolatileField(FuzzyReflection.fromObject(networkManager, true).getFieldByType("channel", Channel.class), networkManager, true);
    }

    @Override
    public int getProtocolVersion() {
        Integer value = (Integer)this.originalChannel.attr(PROTOCOL_KEY).get();
        return value != null ? value : MinecraftProtocolVersion.getCurrentVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inject() {
        Object object = this.networkManager;
        synchronized (object) {
            if (this.closed) {
                return false;
            }
            if (this.originalChannel instanceof Factory) {
                return false;
            }
            if (!this.originalChannel.isActive()) {
                return false;
            }
            if (Bukkit.isPrimaryThread()) {
                this.executeInChannelThread(new Runnable(){

                    @Override
                    public void run() {
                        ChannelInjector.this.inject();
                    }
                });
                return false;
            }
            if (ChannelInjector.findChannelHandler(this.originalChannel, ChannelInjector.class) != null) {
                return false;
            }
            this.vanillaDecoder = (ByteToMessageDecoder)this.originalChannel.pipeline().get("decoder");
            this.vanillaEncoder = (MessageToByteEncoder)this.originalChannel.pipeline().get("encoder");
            if (this.vanillaDecoder == null) {
                throw new IllegalArgumentException("Unable to find vanilla decoder in " + this.originalChannel.pipeline());
            }
            if (this.vanillaEncoder == null) {
                throw new IllegalArgumentException("Unable to find vanilla encoder in " + this.originalChannel.pipeline());
            }
            this.patchEncoder(this.vanillaEncoder);
            if (DECODE_BUFFER == null) {
                DECODE_BUFFER = Accessors.getMethodAccessor(this.vanillaDecoder.getClass(), "decode", ChannelHandlerContext.class, ByteBuf.class, List.class);
            }
            if (ENCODE_BUFFER == null) {
                ENCODE_BUFFER = Accessors.getMethodAccessor(this.vanillaEncoder.getClass(), "encode", ChannelHandlerContext.class, Object.class, ByteBuf.class);
            }
            MessageToByteEncoder<Object> protocolEncoder = new MessageToByteEncoder<Object>(){

                protected void encode(ChannelHandlerContext ctx, Object packet, ByteBuf output) throws Exception {
                    if (packet instanceof WirePacket) {
                        ChannelInjector.this.encodeWirePacket((WirePacket)packet, output);
                    } else {
                        ChannelInjector.this.encode(ctx, packet, output);
                    }
                }

                public void write(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) throws Exception {
                    super.write(ctx, packet, promise);
                    ChannelInjector.this.finalWrite(ctx, packet, promise);
                }
            };
            ChannelInboundHandlerAdapter finishHandler = new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    ctx.fireChannelRead(msg);
                    ChannelInjector.this.finishRead(ctx, msg);
                }
            };
            this.originalChannel.pipeline().addBefore("decoder", "protocol_lib_decoder", (ChannelHandler)this);
            this.originalChannel.pipeline().addBefore("protocol_lib_decoder", "protocol_lib_finish", (ChannelHandler)finishHandler);
            this.originalChannel.pipeline().addAfter("encoder", "protocol_lib_encoder", (ChannelHandler)protocolEncoder);
            this.channelField.setValue(new ChannelProxy(this.originalChannel, MinecraftReflection.getPacketClass()){
                private final PipelineProxy pipelineProxy;
                {
                    this.pipelineProxy = new PipelineProxy(ChannelInjector.this.originalChannel.pipeline(), this){

                        @Override
                        public ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
                            if ("decoder".equals(baseName) && super.get("protocol_lib_decoder") != null && ChannelInjector.this.guessCompression(handler)) {
                                super.addBefore("protocol_lib_decoder", name, handler);
                                return this;
                            }
                            return super.addBefore(baseName, name, handler);
                        }
                    };
                }

                @Override
                public ChannelPipeline pipeline() {
                    return this.pipelineProxy;
                }

                @Override
                protected <T> Callable<T> onMessageScheduled(final Callable<T> callable, FieldAccessor packetAccessor) {
                    final PacketEvent event = this.handleScheduled(callable, packetAccessor);
                    if (event != null && event.isCancelled()) {
                        return null;
                    }
                    return new Callable<T>(){

                        @Override
                        public T call() throws Exception {
                            Object result = null;
                            ChannelInjector.this.currentEvent = event;
                            result = callable.call();
                            ChannelInjector.this.currentEvent = null;
                            return result;
                        }
                    };
                }

                @Override
                protected Runnable onMessageScheduled(final Runnable runnable, FieldAccessor packetAccessor) {
                    final PacketEvent event = this.handleScheduled(runnable, packetAccessor);
                    if (event != null && event.isCancelled()) {
                        return null;
                    }
                    return new Runnable(){

                        @Override
                        public void run() {
                            ChannelInjector.this.currentEvent = event;
                            runnable.run();
                            ChannelInjector.this.currentEvent = null;
                        }
                    };
                }

                protected PacketEvent handleScheduled(Object instance, FieldAccessor accessor) {
                    Object changed;
                    Object original = accessor.get(instance);
                    if (!((Boolean)ChannelInjector.this.scheduleProcessPackets.get()).booleanValue()) {
                        NetworkMarker marker = ChannelInjector.this.getMarker(original);
                        if (marker != null) {
                            PacketEvent result = new PacketEvent(ChannelInjector.class);
                            result.setNetworkMarker(marker);
                            return result;
                        }
                        return BYPASSED_PACKET;
                    }
                    PacketEvent event = ChannelInjector.this.processSending(original);
                    if (event != null && !event.isCancelled() && original != (changed = event.getPacket().getHandle())) {
                        accessor.set(instance, changed);
                    }
                    return event != null ? event : BYPASSED_PACKET;
                }
            });
            this.injected = true;
            return true;
        }
    }

    private boolean guessCompression(ChannelHandler handler) {
        String className = handler != null ? handler.getClass().getCanonicalName() : "";
        return className.contains("Compressor") || className.contains("Decompressor");
    }

    private PacketEvent processSending(Object message) {
        return this.channelListener.onPacketSending(this, message, this.getMarker(message));
    }

    private void patchEncoder(MessageToByteEncoder<Object> encoder) {
        if (ENCODER_TYPE_MATCHER == null) {
            ENCODER_TYPE_MATCHER = Accessors.getFieldAccessor(encoder.getClass(), "matcher", true);
        }
        ENCODER_TYPE_MATCHER.set(encoder, TypeParameterMatcher.get(MinecraftReflection.getPacketClass()));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.channelListener.isDebug()) {
            cause.printStackTrace();
        }
        super.exceptionCaught(ctx, cause);
    }

    protected void encodeWirePacket(WirePacket packet, ByteBuf output) throws Exception {
        packet.writeId(output);
        packet.writeBytes(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void encode(ChannelHandlerContext ctx, Object packet, ByteBuf output) throws Exception {
        PacketEvent event;
        block11: {
            NetworkMarker marker;
            block10: {
                marker = null;
                event = this.currentEvent;
                if (this.scheduleProcessPackets.get().booleanValue()) break block10;
                if (packet == null) return;
                ENCODE_BUFFER.invoke(this.vanillaEncoder, ctx, packet, output);
                this.finalEvent = event;
                return;
            }
            try {
                if (event == null) {
                    Class<?> clazz = packet.getClass();
                    if (this.channelListener.hasMainThreadListener(clazz)) {
                        this.scheduleMainThread(packet);
                        packet = null;
                    } else {
                        event = this.processSending(packet);
                        if (event != null) {
                            Object object = packet = !event.isCancelled() ? event.getPacket().getHandle() : null;
                        }
                    }
                }
                if (event != null) {
                    marker = NetworkMarker.getNetworkMarker(event);
                }
                if (packet == null || event == null || !NetworkMarker.hasOutputHandlers(marker)) break block11;
                ByteBuf packetBuffer = ctx.alloc().buffer();
                ENCODE_BUFFER.invoke(this.vanillaEncoder, ctx, packet, packetBuffer);
                byte[] data = this.processor.processOutput(event, marker, this.getBytes(packetBuffer));
                output.writeBytes(data);
                packet = null;
                this.finalEvent = event;
                if (packet == null) return;
            }
            catch (Exception e) {
                try {
                    this.channelListener.getReporter().reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_INTERCEPT_SERVER_PACKET).callerParam(packet).error(e).build());
                    if (packet == null) return;
                }
                catch (Throwable throwable) {
                    if (packet == null) throw throwable;
                    ENCODE_BUFFER.invoke(this.vanillaEncoder, ctx, packet, output);
                    this.finalEvent = event;
                    throw throwable;
                }
                ENCODE_BUFFER.invoke(this.vanillaEncoder, ctx, packet, output);
                this.finalEvent = event;
                return;
            }
            ENCODE_BUFFER.invoke(this.vanillaEncoder, ctx, packet, output);
            this.finalEvent = event;
            return;
        }
        if (packet == null) return;
        ENCODE_BUFFER.invoke(this.vanillaEncoder, ctx, packet, output);
        this.finalEvent = event;
        return;
    }

    protected void finalWrite(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) {
        PacketEvent event = this.finalEvent;
        if (event != null) {
            this.finalEvent = null;
            this.currentEvent = null;
            this.processor.invokePostEvent(event, NetworkMarker.getNetworkMarker(event));
        }
    }

    private void scheduleMainThread(final Object packetCopy) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.factory.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ChannelInjector.this.invokeSendPacket(packetCopy);
            }
        });
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuffer, List<Object> packets) throws Exception {
        byteBuffer.markReaderIndex();
        DECODE_BUFFER.invoke(this.vanillaDecoder, ctx, byteBuffer, packets);
        try {
            this.finishQueue.clear();
            ListIterator<Object> it = packets.listIterator();
            while (it.hasNext()) {
                PacketEvent output;
                Object input = it.next();
                Class<?> packetClass = input.getClass();
                NettyNetworkMarker marker = null;
                this.handleLogin(packetClass, input);
                if (this.channelListener.includeBuffer(packetClass)) {
                    byteBuffer.resetReaderIndex();
                    marker = new NettyNetworkMarker(ConnectionSide.CLIENT_SIDE, this.getBytes(byteBuffer));
                }
                if ((output = this.channelListener.onPacketReceiving(this, input, marker)) == null) continue;
                if (output.isCancelled()) {
                    it.remove();
                    continue;
                }
                if (output.getPacket().getHandle() != input) {
                    it.set(output.getPacket().getHandle());
                }
                this.finishQueue.addLast(output);
            }
        }
        catch (Exception e) {
            this.channelListener.getReporter().reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_INTERCEPT_CLIENT_PACKET).callerParam(byteBuffer).error(e).build());
        }
    }

    protected void finishRead(ChannelHandlerContext ctx, Object msg) {
        NetworkMarker marker;
        PacketEvent event = this.finishQueue.pollFirst();
        if (event != null && (marker = NetworkMarker.getNetworkMarker(event)) != null) {
            this.processor.invokePostEvent(event, marker);
        }
    }

    protected void handleLogin(Class<?> packetClass, Object packet) {
        if (PACKET_LOGIN_CLIENT == null) {
            PACKET_LOGIN_CLIENT = PacketType.Login.Client.START.getPacketClass();
        }
        if (PACKET_LOGIN_CLIENT == null) {
            throw new IllegalStateException("Failed to obtain login start packet. Did you build Spigot with BuildTools?");
        }
        if (LOGIN_GAME_PROFILE == null) {
            LOGIN_GAME_PROFILE = Accessors.getFieldAccessor(PACKET_LOGIN_CLIENT, MinecraftReflection.getGameProfileClass(), true);
        }
        if (PACKET_LOGIN_CLIENT.equals(packetClass)) {
            WrappedGameProfile profile = WrappedGameProfile.fromHandle(LOGIN_GAME_PROFILE.get(packet));
            this.factory.cacheInjector(profile.getName(), (Injector)this);
        }
        if (PACKET_SET_PROTOCOL == null) {
            try {
                PACKET_SET_PROTOCOL = PacketType.Handshake.Client.SET_PROTOCOL.getPacketClass();
            }
            catch (Throwable ex) {
                PACKET_SET_PROTOCOL = this.getClass();
            }
        }
        if (PACKET_SET_PROTOCOL.equals(packetClass)) {
            FuzzyReflection fuzzy = FuzzyReflection.fromObject(packet);
            try {
                int protocol = (Integer)fuzzy.invokeMethod(packet, "getProtocol", Integer.TYPE, new Object[0]);
                this.originalChannel.attr(PROTOCOL_KEY).set((Object)protocol);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (this.channelField != null) {
            this.channelField.refreshValue();
        }
    }

    private byte[] getBytes(ByteBuf buffer) {
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        return data;
    }

    private void disconnect(String message) {
        if (this.playerConnection == null || this.player instanceof Factory) {
            this.originalChannel.disconnect();
        } else {
            try {
                MinecraftMethods.getDisconnectMethod(this.playerConnection.getClass()).invoke(this.playerConnection, message);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to invoke disconnect method.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendServerPacket(Object packet, NetworkMarker marker, boolean filtered) {
        this.saveMarker(packet, marker);
        try {
            this.scheduleProcessPackets.set(filtered);
            this.invokeSendPacket(packet);
        }
        finally {
            this.scheduleProcessPackets.set(true);
        }
    }

    private void invokeSendPacket(Object packet) {
        try {
            if (this.player instanceof Factory) {
                MinecraftMethods.getNetworkManagerHandleMethod().invoke(this.networkManager, packet, new GenericFutureListener[0]);
            } else {
                MinecraftMethods.getSendPacketMethod().invoke(this.getPlayerConnection(), packet);
            }
        }
        catch (Throwable ex) {
            ProtocolLibrary.getErrorReporter().reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_SEND_PACKET).messageParam(packet, this.playerName).error(ex).build());
        }
    }

    @Override
    public void recieveClientPacket(final Object packet) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                try {
                    MinecraftMethods.getNetworkManagerReadPacketMethod().invoke(ChannelInjector.this.networkManager, null, packet);
                }
                catch (Exception e) {
                    ProtocolLibrary.getErrorReporter().reportMinimal(ChannelInjector.this.factory.getPlugin(), "recieveClientPacket", e);
                }
            }
        };
        if (this.originalChannel.eventLoop().inEventLoop()) {
            action.run();
        } else {
            this.originalChannel.eventLoop().execute(action);
        }
    }

    @Override
    public PacketType.Protocol getCurrentProtocol() {
        if (PROTOCOL_ACCESSOR == null) {
            PROTOCOL_ACCESSOR = Accessors.getFieldAccessor(this.networkManager.getClass(), MinecraftReflection.getEnumProtocolClass(), true);
        }
        return PacketType.Protocol.fromVanilla((Enum)PROTOCOL_ACCESSOR.get(this.networkManager));
    }

    private Object getPlayerConnection() {
        if (this.playerConnection == null) {
            this.playerConnection = MinecraftFields.getPlayerConnection(this.getPlayer());
        }
        return this.playerConnection;
    }

    @Override
    public NetworkMarker getMarker(Object packet) {
        return (NetworkMarker)this.packetMarker.get(packet);
    }

    @Override
    public void saveMarker(Object packet, NetworkMarker marker) {
        if (marker != null) {
            this.packetMarker.put(packet, marker);
        }
    }

    @Override
    public Player getPlayer() {
        if (this.player == null && this.playerName != null) {
            return Bukkit.getPlayer((String)this.playerName);
        }
        return this.player;
    }

    @Override
    public void setPlayer(Player player) {
        this.player = player;
        this.playerName = player.getName();
    }

    @Override
    public void setUpdatedPlayer(Player updated) {
        this.updated = updated;
        this.playerName = updated.getName();
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.injected) {
                this.channelField.revertValue();
                this.executeInChannelThread(new Runnable(){

                    @Override
                    public void run() {
                        String[] handlers;
                        for (String handler : handlers = new String[]{"protocol_lib_decoder", "protocol_lib_finish", "protocol_lib_encoder"}) {
                            try {
                                ChannelInjector.this.originalChannel.pipeline().remove(handler);
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                // empty catch block
                            }
                        }
                    }
                });
                this.factory.invalidate(this.player);
                this.player = null;
                this.updated = null;
            }
        }
    }

    private void executeInChannelThread(final Runnable command) {
        this.originalChannel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    command.run();
                }
                catch (Exception e) {
                    ProtocolLibrary.getErrorReporter().reportDetailed((Object)ChannelInjector.this, Report.newBuilder(REPORT_CANNOT_EXECUTE_IN_CHANNEL_THREAD).error(e).build());
                }
            }
        });
    }

    public static ChannelHandler findChannelHandler(Channel channel, Class<?> clazz) {
        for (Map.Entry entry : channel.pipeline()) {
            if (!clazz.isAssignableFrom(((ChannelHandler)entry.getValue()).getClass())) continue;
            return (ChannelHandler)entry.getValue();
        }
        return null;
    }

    public Channel getChannel() {
        return this.originalChannel;
    }

    static {
        try {
            PROTOCOL_KEY = AttributeKey.valueOf((String)"PROTOCOL");
        }
        catch (IllegalArgumentException ex) {
            PROTOCOL_KEY = AttributeKey.valueOf((String)("PROTOCOL-" + keyId.getAndIncrement()));
        }
    }

    public static class ChannelSocketInjector
    implements SocketInjector {
        private final ChannelInjector injector;

        public ChannelSocketInjector(ChannelInjector injector) {
            this.injector = (ChannelInjector)Preconditions.checkNotNull((Object)injector, (Object)"injector cannot be NULL");
        }

        @Override
        public Socket getSocket() throws IllegalAccessException {
            return SocketAdapter.adapt((SocketChannel)this.injector.originalChannel);
        }

        @Override
        public SocketAddress getAddress() throws IllegalAccessException {
            return this.injector.originalChannel.remoteAddress();
        }

        @Override
        public void disconnect(String message) throws InvocationTargetException {
            this.injector.disconnect(message);
        }

        @Override
        public void sendServerPacket(Object packet, NetworkMarker marker, boolean filtered) throws InvocationTargetException {
            this.injector.sendServerPacket(packet, marker, filtered);
        }

        @Override
        public Player getPlayer() {
            return this.injector.getPlayer();
        }

        @Override
        public Player getUpdatedPlayer() {
            return this.injector.updated != null ? this.injector.updated : this.getPlayer();
        }

        @Override
        public void transferState(SocketInjector delegate) {
        }

        @Override
        public void setUpdatedPlayer(Player updatedPlayer) {
            this.injector.setPlayer(updatedPlayer);
        }

        public ChannelInjector getChannelInjector() {
            return this.injector;
        }
    }
}

