/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.NetworkMarker;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class LegacyNetworkMarker
extends NetworkMarker {
    public LegacyNetworkMarker(@Nonnull ConnectionSide side, byte[] inputBuffer, PacketType type) {
        super(side, inputBuffer, type);
    }

    public LegacyNetworkMarker(@Nonnull ConnectionSide side, ByteBuffer inputBuffer, PacketType type) {
        super(side, inputBuffer, type);
    }

    @Override
    protected DataInputStream skipHeader(DataInputStream input) throws IOException {
        return input;
    }

    @Override
    protected ByteBuffer addHeader(ByteBuffer buffer, PacketType type) {
        return ByteBuffer.wrap(Bytes.concat((byte[][])new byte[][]{{(byte)type.getLegacyId()}, buffer.array()}));
    }

    @Override
    protected DataInputStream addHeader(final DataInputStream input, final PacketType type) {
        ByteSource header = new ByteSource(){

            public InputStream openStream() throws IOException {
                byte[] data = new byte[]{(byte)type.getLegacyId()};
                return new ByteArrayInputStream(data);
            }
        };
        ByteSource data = new ByteSource(){

            public InputStream openStream() throws IOException {
                return input;
            }
        };
        try {
            return new DataInputStream(ByteSource.concat((ByteSource[])new ByteSource[]{header, data}).openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot add header.", e);
        }
    }
}

