/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.metrics;

import com.comphenix.protocol.ProtocolLib;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.metrics.Metrics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.plugin.Plugin;

public class Statistics {
    private Metrics metrics;

    public Statistics(ProtocolLib plugin) throws IOException {
        this.metrics = new Metrics((Plugin)plugin);
        this.metrics.logFailedRequests(plugin.getProtocolConfig().isDebug());
        this.addPluginUserGraph(this.metrics);
    }

    private void addPluginUserGraph(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("Plugin Users", this::getPluginUsers));
        metrics.addCustomChart(new Metrics.SimplePie("buildVersion", () -> (String)Statistics.splitVersion().getRight()));
    }

    public static Pair<String, String> splitVersion() {
        String version = ProtocolLibrary.getPlugin().getDescription().getVersion();
        if (version.contains("-b")) {
            String[] split = version.split("-b");
            return Pair.of((Object)split[0], (Object)split[1]);
        }
        return Pair.of((Object)version, (Object)"Unknown");
    }

    private Map<String, Integer> getPluginUsers() {
        HashMap<String, Integer> users = new HashMap<String, Integer>();
        for (PacketListener listener : ProtocolLibrary.getProtocolManager().getPacketListeners()) {
            String name = PacketAdapter.getPluginName(listener);
            if (!users.containsKey(name)) {
                users.put(name, 1);
                continue;
            }
            users.put(name, (Integer)users.get(name) + 1);
        }
        return users;
    }
}

