/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ProtocolRegistry {
    protected Class<?> enumProtocol = MinecraftReflection.getEnumProtocolClass();
    protected volatile Register register;

    public ProtocolRegistry() {
        this.initialize();
    }

    public Map<PacketType, Class<?>> getPacketTypeLookup() {
        return Collections.unmodifiableMap(this.register.typeToClass);
    }

    public Map<Class<?>, PacketType> getPacketClassLookup() {
        return Collections.unmodifiableMap(this.register.typeToClass.inverse());
    }

    public Set<PacketType> getClientPackets() {
        return Collections.unmodifiableSet(this.register.clientPackets);
    }

    public Set<PacketType> getServerPackets() {
        return Collections.unmodifiableSet(this.register.serverPackets);
    }

    public synchronized void synchronize() {
        if (this.register.isOutdated()) {
            this.initialize();
        }
    }

    protected abstract void initialize();

    protected abstract void associatePackets(Register var1, Map<Integer, Class<?>> var2, PacketType.Protocol var3, PacketType.Sender var4);

    protected final int sum(Iterable<? extends Map<Integer, Class<?>>> maps) {
        int count = 0;
        for (Map<Integer, Class<?>> map : maps) {
            count += map.size();
        }
        return count;
    }

    protected static class Register {
        public BiMap<PacketType, Class<?>> typeToClass = HashBiMap.create();
        public volatile Set<PacketType> serverPackets = Sets.newHashSet();
        public volatile Set<PacketType> clientPackets = Sets.newHashSet();
        public List<MapContainer> containers = Lists.newArrayList();

        public boolean isOutdated() {
            for (MapContainer container : this.containers) {
                if (!container.hasChanged()) continue;
                return true;
            }
            return false;
        }
    }
}

