/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ObjectEnum<T>
implements Iterable<T> {
    protected BiMap<T, String> members = HashBiMap.create();

    public ObjectEnum(Class<T> fieldType) {
        this.registerAll(fieldType);
    }

    protected void registerAll(Class<T> fieldType) {
        try {
            for (Field entry : this.getClass().getFields()) {
                if (!Modifier.isStatic(entry.getModifiers()) || !fieldType.isAssignableFrom(entry.getType())) continue;
                Object value = entry.get(null);
                if (value == null) {
                    throw new IllegalArgumentException("Field " + entry + " was NULL. Remember to construct the object after the field has been declared.");
                }
                this.registerMember(value, entry.getName());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean registerMember(T instance, String name) {
        if (!this.members.containsKey(instance)) {
            this.members.put(instance, (Object)name);
            return true;
        }
        return false;
    }

    public boolean hasMember(T member) {
        return this.members.containsKey(member);
    }

    public T valueOf(String name) {
        return (T)this.members.inverse().get((Object)name);
    }

    public String getDeclaredName(T member) {
        return (String)this.members.get(member);
    }

    public Set<T> values() {
        return new HashSet(this.members.keySet());
    }

    @Override
    public Iterator<T> iterator() {
        return this.members.keySet().iterator();
    }
}

