/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.metrics;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.metrics.Metrics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class Statistics {
    private Metrics metrics;

    public Statistics(Plugin plugin) throws IOException {
        this.metrics = new Metrics(plugin);
        this.addPluginUserGraph(this.metrics);
        this.metrics.start();
    }

    private void addPluginUserGraph(Metrics metrics) {
        Metrics.Graph pluginUsers = metrics.createGraph("Plugin Users");
        for (Map.Entry<String, Integer> entry : this.getPluginUsers(ProtocolLibrary.getProtocolManager()).entrySet()) {
            final int count = entry.getValue();
            pluginUsers.addPlotter(new Metrics.Plotter(entry.getKey()){

                @Override
                public int getValue() {
                    return count;
                }
            });
        }
    }

    private Map<String, Integer> getPluginUsers(ProtocolManager manager) {
        HashMap<String, Integer> users = new HashMap<String, Integer>();
        for (PacketListener listener : manager.getPacketListeners()) {
            String name = PacketAdapter.getPluginName(listener);
            if (!users.containsKey(name)) {
                users.put(name, 1);
                continue;
            }
            users.put(name, (Integer)users.get(name) + 1);
        }
        return users;
    }
}

