/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;

public class ComponentParser {
    private ComponentParser() {
    }

    public static Object deserialize(Object gson, Class<?> component, StringReader str) {
        try {
            JsonReader reader = new JsonReader((Reader)str);
            reader.setLenient(true);
            return ((Gson)gson).getAdapter(component).read(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read JSON", ex);
        }
        catch (LinkageError er) {
            return ComponentParser.deserializeLegacy(gson, component, str);
        }
    }

    private static Object deserializeLegacy(Object gson, Class<?> component, StringReader str) {
        try {
            Class<?> readerClass = Class.forName("org.bukkit.craftbukkit.libs.com.google.gson.stream.JsonReader");
            Object reader = readerClass.getConstructor(StringReader.class).newInstance(str);
            Method setLenient = readerClass.getMethod("setLenienent", Boolean.TYPE);
            setLenient.invoke(reader, true);
            Method getAdapter = gson.getClass().getMethod("getAdapter", Class.class);
            Object adapter = getAdapter.invoke(gson, component);
            Method read = adapter.getClass().getMethod("read", readerClass);
            return read.invoke(adapter, reader);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Failed to read JSON", ex);
        }
    }
}

