/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedStatistic;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BukkitConverters {
    private static boolean hasWorldType = false;
    private static boolean hasAttributeSnapshot = false;
    private static Map<Class<?>, EquivalentConverter<Object>> specificConverters;
    private static Map<Class<?>, EquivalentConverter<Object>> genericConverters;
    private static List<PacketConstructor.Unwrapper> unwrappers;
    private static Method worldTypeName;
    private static Method worldTypeGetType;
    private static MethodAccessor GET_BLOCK;
    private static MethodAccessor GET_BLOCK_ID;
    private static volatile Constructor<?> mobEffectConstructor;
    private static volatile StructureModifier<Object> mobEffectModifier;
    private static FieldAccessor craftWorldField;
    private static Constructor<?> vec3dConstructor;
    private static StructureModifier<Object> vec3dModifier;
    private static MethodAccessor soundGetter;
    private static FieldAccessor soundKey;
    private static MethodAccessor getMobEffectId;
    private static MethodAccessor getMobEffect;

    public static <T, U> EquivalentConverter<Map<T, U>> getMapConverter(final Class<?> genericKeyType, final EquivalentConverter<T> keyConverter) {
        return new IgnoreNullConverter<Map<T, U>>(){

            @Override
            protected Map<T, U> getSpecificValue(Object generic) {
                if (generic instanceof Map) {
                    HashMap result = Maps.newHashMap();
                    for (Map.Entry entry : ((Map)generic).entrySet()) {
                        result.put(keyConverter.getSpecific(entry.getKey()), entry.getValue());
                    }
                    return result;
                }
                return null;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, Map<T, U> specific) {
                Map newContainer = (Map)DefaultInstances.DEFAULT.getDefault(genericType);
                for (Map.Entry entry : specific.entrySet()) {
                    newContainer.put(keyConverter.getGeneric(genericKeyType, entry.getKey()), entry.getValue());
                }
                return newContainer;
            }

            @Override
            public Class<Map<T, U>> getSpecificType() {
                Class<Map> dummy = Map.class;
                return dummy;
            }
        };
    }

    public static <T> EquivalentConverter<List<T>> getListConverter(final Class<?> genericItemType, final EquivalentConverter<T> itemConverter) {
        return new IgnoreNullConverter<List<T>>(){

            @Override
            protected List<T> getSpecificValue(Object generic) {
                if (generic instanceof Collection) {
                    ArrayList items = new ArrayList();
                    for (Object item : (Collection)generic) {
                        Object result = itemConverter.getSpecific(item);
                        if (item == null) continue;
                        items.add(result);
                    }
                    return items;
                }
                return null;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, List<T> specific) {
                Collection newContainer = (Collection)DefaultInstances.DEFAULT.getDefault(genericType);
                for (Object position : specific) {
                    Object converted = itemConverter.getGeneric(genericItemType, position);
                    if (position == null) {
                        newContainer.add(null);
                        continue;
                    }
                    if (converted == null) continue;
                    newContainer.add(converted);
                }
                return newContainer;
            }

            @Override
            public Class<List<T>> getSpecificType() {
                Class<List> dummy = List.class;
                return dummy;
            }
        };
    }

    public static <T> EquivalentConverter<Set<T>> getSetConverter(final Class<?> genericItemType, final EquivalentConverter<T> itemConverter) {
        return new IgnoreNullConverter<Set<T>>(){

            @Override
            protected Set<T> getSpecificValue(Object generic) {
                if (generic instanceof Collection) {
                    HashSet items = new HashSet();
                    for (Object item : (Collection)generic) {
                        Object result = itemConverter.getSpecific(item);
                        if (item == null) continue;
                        items.add(result);
                    }
                    return items;
                }
                return null;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, Set<T> specific) {
                Collection newContainer = (Collection)DefaultInstances.DEFAULT.getDefault(genericType);
                for (Object position : specific) {
                    Object converted = itemConverter.getGeneric(genericItemType, position);
                    if (position == null) {
                        newContainer.add(null);
                        continue;
                    }
                    if (converted == null) continue;
                    newContainer.add(converted);
                }
                return newContainer;
            }

            @Override
            public Class<Set<T>> getSpecificType() {
                Class<Set> dummy = Set.class;
                return dummy;
            }
        };
    }

    public static <T> EquivalentConverter<Iterable<? extends T>> getArrayConverter(final Class<?> genericItemType, final EquivalentConverter<T> itemConverter) {
        return new IgnoreNullConverter<Iterable<? extends T>>(){

            @Override
            protected List<T> getSpecificValue(Object generic) {
                if (generic instanceof Object[]) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Object item : (Object[])generic) {
                        Object result = itemConverter.getSpecific(item);
                        builder.add(result);
                    }
                    return builder.build();
                }
                return null;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, Iterable<? extends T> specific) {
                ArrayList list = Lists.newArrayList(specific);
                Object[] output = (Object[])Array.newInstance(genericItemType, list.size());
                for (int i = 0; i < output.length; ++i) {
                    Object converted;
                    output[i] = converted = itemConverter.getGeneric(genericItemType, list.get(i));
                }
                return output;
            }

            @Override
            public Class<Iterable<? extends T>> getSpecificType() {
                Class<Iterable> dummy = Iterable.class;
                return dummy;
            }
        };
    }

    public static EquivalentConverter<WrappedGameProfile> getWrappedGameProfileConverter() {
        return new IgnoreNullConverter<WrappedGameProfile>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedGameProfile specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedGameProfile getSpecificValue(Object generic) {
                return WrappedGameProfile.fromHandle(generic);
            }

            @Override
            public Class<WrappedGameProfile> getSpecificType() {
                return WrappedGameProfile.class;
            }
        };
    }

    public static EquivalentConverter<WrappedChatComponent> getWrappedChatComponentConverter() {
        return new IgnoreNullConverter<WrappedChatComponent>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedChatComponent specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedChatComponent getSpecificValue(Object generic) {
                return WrappedChatComponent.fromHandle(generic);
            }

            @Override
            public Class<WrappedChatComponent> getSpecificType() {
                return WrappedChatComponent.class;
            }
        };
    }

    public static EquivalentConverter<WrappedBlockData> getWrappedBlockDataConverter() {
        return new IgnoreNullConverter<WrappedBlockData>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedBlockData specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedBlockData getSpecificValue(Object generic) {
                return new WrappedBlockData(generic);
            }

            @Override
            public Class<WrappedBlockData> getSpecificType() {
                return WrappedBlockData.class;
            }
        };
    }

    public static EquivalentConverter<WrappedAttribute> getWrappedAttributeConverter() {
        return new IgnoreNullConverter<WrappedAttribute>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedAttribute specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedAttribute getSpecificValue(Object generic) {
                return WrappedAttribute.fromHandle(generic);
            }

            @Override
            public Class<WrappedAttribute> getSpecificType() {
                return WrappedAttribute.class;
            }
        };
    }

    public static EquivalentConverter<WrappedWatchableObject> getWatchableObjectConverter() {
        return new IgnoreNullConverter<WrappedWatchableObject>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedWatchableObject specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedWatchableObject getSpecificValue(Object generic) {
                if (MinecraftReflection.isWatchableObject(generic)) {
                    return new WrappedWatchableObject(generic);
                }
                if (generic instanceof WrappedWatchableObject) {
                    return (WrappedWatchableObject)generic;
                }
                throw new IllegalArgumentException("Unrecognized type " + generic.getClass());
            }

            @Override
            public Class<WrappedWatchableObject> getSpecificType() {
                return WrappedWatchableObject.class;
            }
        };
    }

    public static EquivalentConverter<WrappedDataWatcher> getDataWatcherConverter() {
        return new IgnoreNullConverter<WrappedDataWatcher>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedDataWatcher specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedDataWatcher getSpecificValue(Object generic) {
                if (MinecraftReflection.isDataWatcher(generic)) {
                    return new WrappedDataWatcher(generic);
                }
                if (generic instanceof WrappedDataWatcher) {
                    return (WrappedDataWatcher)generic;
                }
                throw new IllegalArgumentException("Unrecognized type " + generic.getClass());
            }

            @Override
            public Class<WrappedDataWatcher> getSpecificType() {
                return WrappedDataWatcher.class;
            }
        };
    }

    public static EquivalentConverter<WorldType> getWorldTypeConverter() {
        if (!hasWorldType) {
            return null;
        }
        final Class<?> worldType = MinecraftReflection.getWorldTypeClass();
        return new IgnoreNullConverter<WorldType>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WorldType specific) {
                try {
                    if (worldTypeGetType == null) {
                        worldTypeGetType = FuzzyReflection.fromClass(worldType).getMethodByParameters("getType", (Class<?>)worldType, (Class<?>[])new Class[]{String.class});
                    }
                    return worldTypeGetType.invoke((Object)this, specific.getName());
                }
                catch (Exception e) {
                    throw new FieldAccessException("Cannot find the WorldType.getType() method.", e);
                }
            }

            @Override
            protected WorldType getSpecificValue(Object generic) {
                try {
                    if (worldTypeName == null) {
                        try {
                            worldTypeName = worldType.getMethod("name", new Class[0]);
                        }
                        catch (Exception e) {
                            worldTypeName = FuzzyReflection.fromClass(worldType).getMethodByParameters("name", (Class<?>)String.class, (Class<?>[])new Class[0]);
                        }
                    }
                    String name = (String)worldTypeName.invoke(generic, new Object[0]);
                    return WorldType.getByName((String)name);
                }
                catch (Exception e) {
                    throw new FieldAccessException("Cannot call the name method in WorldType.", e);
                }
            }

            @Override
            public Class<WorldType> getSpecificType() {
                return WorldType.class;
            }
        };
    }

    public static EquivalentConverter<NbtBase<?>> getNbtConverter() {
        return new IgnoreNullConverter<NbtBase<?>>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, NbtBase<?> specific) {
                return NbtFactory.fromBase(specific).getHandle();
            }

            @Override
            protected NbtBase<?> getSpecificValue(Object generic) {
                return NbtFactory.fromNMS(generic, null);
            }

            @Override
            public Class<NbtBase<?>> getSpecificType() {
                Class<NbtBase> dummy = NbtBase.class;
                return dummy;
            }
        };
    }

    public static EquivalentConverter<Entity> getEntityConverter(World world) {
        final WeakReference<ProtocolManager> managerRef = new WeakReference<ProtocolManager>(ProtocolLibrary.getProtocolManager());
        return new WorldSpecificConverter<Entity>(world){

            @Override
            public Object getGenericValue(Class<?> genericType, Entity specific) {
                return specific.getEntityId();
            }

            @Override
            public Entity getSpecificValue(Object generic) {
                try {
                    Integer id = (Integer)generic;
                    ProtocolManager manager = (ProtocolManager)managerRef.get();
                    if (id != null && manager != null) {
                        return manager.getEntityFromID(this.world, id);
                    }
                    return null;
                }
                catch (FieldAccessException e) {
                    throw new RuntimeException("Cannot retrieve entity from ID.", e);
                }
            }

            @Override
            public Class<Entity> getSpecificType() {
                return Entity.class;
            }
        };
    }

    public static EquivalentConverter<ItemStack> getItemStackConverter() {
        return new EquivalentConverter<ItemStack>(){

            @Override
            public ItemStack getSpecific(Object generic) {
                return MinecraftReflection.getBukkitItemStack(generic);
            }

            @Override
            public Object getGeneric(Class<?> genericType, ItemStack specific) {
                return MinecraftReflection.getMinecraftItemStack(specific);
            }

            @Override
            public Class<ItemStack> getSpecificType() {
                return ItemStack.class;
            }
        };
    }

    public static EquivalentConverter<WrappedServerPing> getWrappedServerPingConverter() {
        return new IgnoreNullConverter<WrappedServerPing>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedServerPing specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedServerPing getSpecificValue(Object generic) {
                return WrappedServerPing.fromHandle(generic);
            }

            @Override
            public Class<WrappedServerPing> getSpecificType() {
                return WrappedServerPing.class;
            }
        };
    }

    public static EquivalentConverter<WrappedStatistic> getWrappedStatisticConverter() {
        return new IgnoreNullConverter<WrappedStatistic>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, WrappedStatistic specific) {
                return specific.getHandle();
            }

            @Override
            protected WrappedStatistic getSpecificValue(Object generic) {
                return WrappedStatistic.fromHandle(generic);
            }

            @Override
            public Class<WrappedStatistic> getSpecificType() {
                return WrappedStatistic.class;
            }
        };
    }

    public static EquivalentConverter<Material> getBlockConverter() {
        return new IgnoreNullConverter<Material>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, Material specific) {
                return BukkitConverters.getBlockIDConverter().getGeneric(genericType, specific.getId());
            }

            @Override
            protected Material getSpecificValue(Object generic) {
                return Material.getMaterial((int)BukkitConverters.getBlockIDConverter().getSpecific(generic));
            }

            @Override
            public Class<Material> getSpecificType() {
                return Material.class;
            }
        };
    }

    @Deprecated
    public static EquivalentConverter<Integer> getBlockIDConverter() {
        if (GET_BLOCK == null || GET_BLOCK_ID == null) {
            Class<?> block = MinecraftReflection.getBlockClass();
            FuzzyMethodContract getIdContract = FuzzyMethodContract.newBuilder().parameterExactArray(block).requireModifier(8).build();
            FuzzyMethodContract getBlockContract = FuzzyMethodContract.newBuilder().returnTypeExact(block).parameterExactArray(Integer.TYPE).requireModifier(8).build();
            GET_BLOCK = Accessors.getMethodAccessor(FuzzyReflection.fromClass(block).getMethod(getBlockContract));
            GET_BLOCK_ID = Accessors.getMethodAccessor(FuzzyReflection.fromClass(block).getMethod(getIdContract));
        }
        return new IgnoreNullConverter<Integer>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, Integer specific) {
                return GET_BLOCK.invoke(null, specific);
            }

            @Override
            protected Integer getSpecificValue(Object generic) {
                return (Integer)GET_BLOCK_ID.invoke(null, generic);
            }

            @Override
            public Class<Integer> getSpecificType() {
                return Integer.class;
            }
        };
    }

    public static EquivalentConverter<World> getWorldConverter() {
        return new IgnoreNullConverter<World>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, World specific) {
                return BukkitUnwrapper.getInstance().unwrapItem(specific);
            }

            @Override
            protected World getSpecificValue(Object generic) {
                return (World)craftWorldField.get(generic);
            }

            @Override
            public Class<World> getSpecificType() {
                return World.class;
            }
        };
    }

    public static EquivalentConverter<PotionEffect> getPotionEffectConverter() {
        return new IgnoreNullConverter<PotionEffect>(){

            @Override
            protected Object getGenericValue(Class<?> genericType, PotionEffect specific) {
                if (mobEffectConstructor == null) {
                    try {
                        mobEffectConstructor = MinecraftReflection.getMobEffectClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find mob effect constructor (int, int, int, boolean).", e);
                    }
                }
                try {
                    return mobEffectConstructor.newInstance(specific.getType().getId(), specific.getDuration(), specific.getAmplifier(), specific.isAmbient());
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot construct MobEffect.", e);
                }
            }

            @Override
            protected PotionEffect getSpecificValue(Object generic) {
                if (mobEffectModifier == null) {
                    mobEffectModifier = new StructureModifier(MinecraftReflection.getMobEffectClass(), false);
                }
                StructureModifier ints = mobEffectModifier.withTarget(generic).withType(Integer.TYPE);
                StructureModifier bools = mobEffectModifier.withTarget(generic).withType(Boolean.TYPE);
                return new PotionEffect(PotionEffectType.getById((int)((Integer)ints.read(0))), ((Integer)ints.read(1)).intValue(), ((Integer)ints.read(2)).intValue(), ((Boolean)bools.read(1)).booleanValue());
            }

            @Override
            public Class<PotionEffect> getSpecificType() {
                return PotionEffect.class;
            }
        };
    }

    public static EquivalentConverter<Vector> getVectorConverter() {
        return new IgnoreNullConverter<Vector>(){

            @Override
            public Class<Vector> getSpecificType() {
                return Vector.class;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, Vector specific) {
                if (vec3dConstructor == null) {
                    try {
                        vec3dConstructor = MinecraftReflection.getVec3DClass().getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Could not find Vec3d constructor (double, double, double)");
                    }
                }
                try {
                    return vec3dConstructor.newInstance(specific.getX(), specific.getY(), specific.getZ());
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not construct Vec3d.", ex);
                }
            }

            @Override
            protected Vector getSpecificValue(Object generic) {
                if (vec3dModifier == null) {
                    vec3dModifier = new StructureModifier(MinecraftReflection.getVec3DClass(), false);
                }
                StructureModifier doubles = vec3dModifier.withTarget(generic).withType(Double.TYPE);
                return new Vector(((Double)doubles.read(0)).doubleValue(), ((Double)doubles.read(1)).doubleValue(), ((Double)doubles.read(2)).doubleValue());
            }
        };
    }

    public static EquivalentConverter<Sound> getSoundConverter() {
        return new IgnoreNullConverter<Sound>(){

            @Override
            public Class<Sound> getSpecificType() {
                return Sound.class;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, Sound specific) {
                if (soundGetter == null) {
                    Class<?> soundEffects = MinecraftReflection.getMinecraftClass("SoundEffects");
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(soundEffects, true);
                    soundGetter = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getSound", MinecraftReflection.getSoundEffectClass(), (Class<?>[])new Class[]{String.class}));
                }
                MinecraftKey key = MinecraftKey.fromEnum(specific);
                return soundGetter.invoke(null, key.getFullKey());
            }

            @Override
            protected Sound getSpecificValue(Object generic) {
                if (soundKey == null) {
                    Class<?> soundEffect = generic.getClass();
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(soundEffect, true);
                    soundKey = Accessors.getFieldAccessor(fuzzy.getFieldByType("key", MinecraftReflection.getMinecraftKeyClass()));
                }
                MinecraftKey key = MinecraftKey.fromHandle(soundKey.get(generic));
                return Sound.valueOf((String)key.getEnumFormat());
            }
        };
    }

    public static <TType> EquivalentConverter<TType> getIgnoreNull(final EquivalentConverter<TType> delegate) {
        return new IgnoreNullConverter<TType>(){

            @Override
            public Object getGenericValue(Class<?> genericType, TType specific) {
                return delegate.getGeneric(genericType, specific);
            }

            @Override
            public TType getSpecificValue(Object generic) {
                return delegate.getSpecific(generic);
            }

            @Override
            public Class<TType> getSpecificType() {
                return delegate.getSpecificType();
            }
        };
    }

    public static PacketConstructor.Unwrapper asUnwrapper(final Class<?> nativeType, final EquivalentConverter<Object> converter) {
        return new PacketConstructor.Unwrapper(){

            @Override
            public Object unwrapItem(Object wrappedObject) {
                Class<?> type = PacketConstructor.getClass(wrappedObject);
                if (converter.getSpecificType().isAssignableFrom(type)) {
                    if (wrappedObject instanceof Class) {
                        return nativeType;
                    }
                    return converter.getGeneric(nativeType, wrappedObject);
                }
                return null;
            }
        };
    }

    public static Map<Class<?>, EquivalentConverter<Object>> getConvertersForSpecific() {
        if (specificConverters == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put(WrappedDataWatcher.class, BukkitConverters.getDataWatcherConverter()).put(ItemStack.class, BukkitConverters.getItemStackConverter()).put(NbtBase.class, BukkitConverters.getNbtConverter()).put(NbtCompound.class, BukkitConverters.getNbtConverter()).put(WrappedWatchableObject.class, BukkitConverters.getWatchableObjectConverter()).put(PotionEffect.class, BukkitConverters.getPotionEffectConverter()).put(World.class, BukkitConverters.getWorldConverter());
            if (MinecraftReflection.isUsingNetty()) {
                builder.put(Material.class, BukkitConverters.getBlockConverter());
                builder.put(WrappedGameProfile.class, BukkitConverters.getWrappedGameProfileConverter());
                builder.put(WrappedChatComponent.class, BukkitConverters.getWrappedChatComponentConverter());
                builder.put(WrappedServerPing.class, BukkitConverters.getWrappedServerPingConverter());
                builder.put(WrappedStatistic.class, BukkitConverters.getWrappedStatisticConverter());
                for (Map.Entry<Class<?>, EquivalentConverter<?>> entry : EnumWrappers.getFromWrapperMap().entrySet()) {
                    builder.put(entry.getKey(), entry.getValue());
                }
            }
            if (hasWorldType) {
                builder.put(WorldType.class, BukkitConverters.getWorldTypeConverter());
            }
            if (hasAttributeSnapshot) {
                builder.put(WrappedAttribute.class, BukkitConverters.getWrappedAttributeConverter());
            }
            specificConverters = builder.build();
        }
        return specificConverters;
    }

    public static Map<Class<?>, EquivalentConverter<Object>> getConvertersForGeneric() {
        if (genericConverters == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put(MinecraftReflection.getDataWatcherClass(), BukkitConverters.getDataWatcherConverter()).put(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter()).put(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter()).put(MinecraftReflection.getNBTCompoundClass(), BukkitConverters.getNbtConverter()).put(MinecraftReflection.getDataWatcherItemClass(), BukkitConverters.getWatchableObjectConverter()).put(MinecraftReflection.getMobEffectClass(), BukkitConverters.getPotionEffectConverter()).put(MinecraftReflection.getNmsWorldClass(), BukkitConverters.getWorldConverter());
            if (hasWorldType) {
                builder.put(MinecraftReflection.getWorldTypeClass(), BukkitConverters.getWorldTypeConverter());
            }
            if (hasAttributeSnapshot) {
                builder.put(MinecraftReflection.getAttributeSnapshotClass(), BukkitConverters.getWrappedAttributeConverter());
            }
            if (MinecraftReflection.isUsingNetty()) {
                builder.put(MinecraftReflection.getBlockClass(), BukkitConverters.getBlockConverter());
                builder.put(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
                builder.put(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
                builder.put(MinecraftReflection.getServerPingClass(), BukkitConverters.getWrappedServerPingConverter());
                builder.put(MinecraftReflection.getStatisticClass(), BukkitConverters.getWrappedStatisticConverter());
                for (Map.Entry<Class<?>, EquivalentConverter<?>> entry : EnumWrappers.getFromNativeMap().entrySet()) {
                    builder.put(entry.getKey(), entry.getValue());
                }
            }
            genericConverters = builder.build();
        }
        return genericConverters;
    }

    public static List<PacketConstructor.Unwrapper> getUnwrappers() {
        if (unwrappers == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry<Class<?>, EquivalentConverter<Object>> entry : BukkitConverters.getConvertersForGeneric().entrySet()) {
                builder.add((Object)BukkitConverters.asUnwrapper(entry.getKey(), entry.getValue()));
            }
            unwrappers = builder.build();
        }
        return unwrappers;
    }

    public static EquivalentConverter<PotionEffectType> getEffectTypeConverter() {
        return new IgnoreNullConverter<PotionEffectType>(){

            @Override
            public Class<PotionEffectType> getSpecificType() {
                return PotionEffectType.class;
            }

            @Override
            protected Object getGenericValue(Class<?> genericType, PotionEffectType specific) {
                if (getMobEffect == null) {
                    getMobEffect = Accessors.getMethodAccessor(genericType, "fromId", Integer.TYPE);
                }
                int id = specific.getId();
                return getMobEffect.invoke(null, id);
            }

            @Override
            protected PotionEffectType getSpecificValue(Object generic) {
                Class<?> clazz = MinecraftReflection.getMobEffectListClass();
                if (getMobEffectId == null) {
                    getMobEffectId = Accessors.getMethodAccessor(clazz, "getId", clazz);
                }
                int id = (Integer)getMobEffectId.invoke(null, generic);
                return PotionEffectType.getById((int)id);
            }
        };
    }

    static {
        try {
            MinecraftReflection.getWorldTypeClass();
            hasWorldType = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            MinecraftReflection.getAttributeSnapshotClass();
            hasAttributeSnapshot = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            craftWorldField = Accessors.getFieldAccessor(MinecraftReflection.getNmsWorldClass(), MinecraftReflection.getCraftWorldClass(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        soundGetter = null;
        soundKey = null;
        getMobEffectId = null;
        getMobEffect = null;
    }

    private static abstract class WorldSpecificConverter<TType>
    extends IgnoreNullConverter<TType> {
        protected World world;

        public WorldSpecificConverter(World world) {
            this.world = world;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WorldSpecificConverter && super.equals(obj)) {
                WorldSpecificConverter that = (WorldSpecificConverter)obj;
                return Objects.equal((Object)this.world, (Object)that.world);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSpecificType(), this.world});
        }
    }

    public static abstract class IgnoreNullConverter<TType>
    implements EquivalentConverter<TType> {
        @Override
        public final Object getGeneric(Class<?> genericType, TType specific) {
            if (specific != null) {
                return this.getGenericValue(genericType, specific);
            }
            return null;
        }

        protected abstract Object getGenericValue(Class<?> var1, TType var2);

        @Override
        public final TType getSpecific(Object generic) {
            if (generic != null) {
                return this.getSpecificValue(generic);
            }
            return null;
        }

        protected abstract TType getSpecificValue(Object var1);

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentConverter) {
                EquivalentConverter that = (EquivalentConverter)obj;
                return Objects.equal(this.getSpecificType(), that.getSpecificType());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getSpecificType()});
        }
    }
}

