/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.spigot;

import com.comphenix.net.sf.cglib.proxy.Callback;
import com.comphenix.net.sf.cglib.proxy.CallbackFilter;
import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.Factory;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.net.sf.cglib.proxy.NoOp;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrency.PacketTypeSet;
import com.comphenix.protocol.error.DelegatedErrorReporter;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.PlayerLoggedOutException;
import com.comphenix.protocol.injector.packet.LegacyNetworkMarker;
import com.comphenix.protocol.injector.packet.PacketInjector;
import com.comphenix.protocol.injector.player.NetworkObjectInjector;
import com.comphenix.protocol.injector.player.PlayerInjectionHandler;
import com.comphenix.protocol.injector.spigot.DummyPacketInjector;
import com.comphenix.protocol.injector.spigot.DummyPlayerHandler;
import com.comphenix.protocol.injector.spigot.SpigotPacketListener;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpigotPacketInjector
implements SpigotPacketListener {
    public static final ReportType REPORT_CANNOT_CLEANUP_SPIGOT = new ReportType("Cannot cleanup Spigot listener.");
    private static volatile Class<?> spigotListenerClass;
    private static volatile boolean classChecked;
    private static volatile Field playerConnectionPlayer;
    private Set<Object> ignoredPackets = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private static final int CLEANUP_DELAY = 100;
    private Object dynamicListener;
    private Plugin plugin;
    private PacketTypeSet queuedFilters;
    private PacketTypeSet reveivedFilters;
    private ConcurrentMap<Object, NetworkObjectInjector> networkManagerInjector = Maps.newConcurrentMap();
    private ConcurrentMap<Player, NetworkObjectInjector> playerInjector = Maps.newConcurrentMap();
    private Map<Object, byte[]> readBufferedPackets = new MapMaker().weakKeys().makeMap();
    private ListenerInvoker invoker;
    private ErrorReporter reporter;
    private Server server;
    private PacketInjector proxyPacketInjector;
    private static final int BACKGROUND_DELAY = 600;
    private int backgroundId;

    public SpigotPacketInjector(ErrorReporter reporter, ListenerInvoker invoker, Server server) {
        this.reporter = reporter;
        this.invoker = invoker;
        this.server = server;
        this.queuedFilters = new PacketTypeSet();
        this.reveivedFilters = new PacketTypeSet();
    }

    public ListenerInvoker getInvoker() {
        return this.invoker;
    }

    public void setProxyPacketInjector(PacketInjector proxyPacketInjector) {
        this.proxyPacketInjector = proxyPacketInjector;
    }

    public PacketInjector getProxyPacketInjector() {
        return this.proxyPacketInjector;
    }

    private static Class<?> getSpigotListenerClass() {
        if (!classChecked) {
            try {
                spigotListenerClass = SpigotPacketInjector.class.getClassLoader().loadClass("org.spigotmc.netty.PacketListener");
            }
            catch (ClassNotFoundException e) {
                Class<?> clazz = null;
                return clazz;
            }
            finally {
                classChecked = true;
            }
        }
        return spigotListenerClass;
    }

    private static Method getRegisterMethod() {
        Class<?> clazz = SpigotPacketInjector.getSpigotListenerClass();
        if (clazz != null) {
            try {
                return clazz.getMethod("register", clazz, Plugin.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Reflection is not allowed.", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find register() method in " + clazz, e);
            }
        }
        throw new IllegalStateException("Spigot could not be found!");
    }

    public static boolean canUseSpigotListener() {
        return SpigotPacketInjector.getSpigotListenerClass() != null;
    }

    public boolean register(Plugin plugin) {
        if (this.hasRegistered()) {
            return false;
        }
        this.plugin = plugin;
        Callback[] callbacks = new Callback[3];
        final boolean[] found = new boolean[3];
        callbacks[0] = new MethodInterceptor(){

            @Override
            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                return SpigotPacketInjector.this.packetReceived(args[0], args[1], args[2]);
            }
        };
        callbacks[1] = new MethodInterceptor(){

            @Override
            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                return SpigotPacketInjector.this.packetQueued(args[0], args[1], args[2]);
            }
        };
        callbacks[2] = NoOp.INSTANCE;
        Enhancer enhancer = EnhancerFactory.getInstance().createEnhancer();
        enhancer.setSuperclass(SpigotPacketInjector.getSpigotListenerClass());
        enhancer.setCallbacks(callbacks);
        enhancer.setCallbackFilter(new CallbackFilter(){

            @Override
            public int accept(Method method) {
                if (SpigotPacketInjector.this.matchMethod("packetReceived", method)) {
                    found[0] = true;
                    return 0;
                }
                if (SpigotPacketInjector.this.matchMethod("packetQueued", method)) {
                    found[1] = true;
                    return 1;
                }
                found[2] = true;
                return 2;
            }
        });
        this.dynamicListener = enhancer.create();
        if (!found[0]) {
            throw new IllegalStateException("Unable to find a valid packet receiver in Spigot.");
        }
        if (!found[1]) {
            throw new IllegalStateException("Unable to find a valid packet queue in Spigot.");
        }
        try {
            SpigotPacketInjector.getRegisterMethod().invoke(null, this.dynamicListener, plugin);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register Spigot packet listener.", e);
        }
        this.backgroundId = this.createBackgroundTask();
        return true;
    }

    private int createBackgroundTask() {
        return Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, new Runnable(){

            @Override
            public void run() {
                SpigotPacketInjector.this.cleanupInjectors();
            }
        }, 600L, 600L);
    }

    private void cleanupInjectors() {
        for (NetworkObjectInjector injector : this.networkManagerInjector.values()) {
            try {
                if (injector.getSocket() == null || !injector.getSocket().isClosed()) continue;
                this.cleanupInjector(injector);
            }
            catch (Exception e) {
                this.reporter.reportMinimal(this.plugin, "cleanupInjectors", e);
                this.cleanupInjector(injector);
            }
        }
    }

    private void cleanupInjector(NetworkObjectInjector injector) {
        this.playerInjector.remove(injector.getPlayer());
        this.playerInjector.remove(injector.getUpdatedPlayer());
        this.networkManagerInjector.remove(injector.getNetworkManager());
    }

    private boolean matchMethod(String methodName, Method method) {
        return FuzzyMethodContract.newBuilder().nameExact(methodName).parameterCount(3).parameterSuperOf(MinecraftReflection.getNetHandlerClass(), 1).parameterSuperOf(MinecraftReflection.getPacketClass(), 2).returnTypeExact(MinecraftReflection.getPacketClass()).build().isMatch(MethodInfo.fromMethod(method), (Object)null);
    }

    public boolean hasRegistered() {
        return this.dynamicListener != null;
    }

    public PlayerInjectionHandler getPlayerHandler() {
        return new DummyPlayerHandler(this, this.queuedFilters);
    }

    public PacketInjector getPacketInjector() {
        return new DummyPacketInjector(this, this.reveivedFilters);
    }

    NetworkObjectInjector getInjector(Player player, boolean createNew) {
        NetworkObjectInjector injector = (NetworkObjectInjector)this.playerInjector.get(player);
        if (injector == null && createNew) {
            if (player instanceof Factory) {
                throw new IllegalArgumentException("Cannot inject tempoary player " + player);
            }
            try {
                NetworkObjectInjector created = new NetworkObjectInjector(this.filterImpossibleWarnings(this.reporter), null, this.invoker, null);
                created.initializePlayer(player);
                if (created.getNetworkManager() == null) {
                    throw new PlayerLoggedOutException("Player " + player + " has logged out.");
                }
                injector = this.saveInjector(created.getNetworkManager(), created);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot create dummy injector.", e);
            }
        }
        return injector;
    }

    NetworkObjectInjector getInjector(Object networkManager, Object connection) {
        NetworkObjectInjector dummyInjector = (NetworkObjectInjector)this.networkManagerInjector.get(networkManager);
        if (dummyInjector == null) {
            try {
                NetworkObjectInjector created = new NetworkObjectInjector(this.filterImpossibleWarnings(this.reporter), null, this.invoker, null);
                if (MinecraftReflection.isLoginHandler(connection)) {
                    created.initialize(connection);
                    created.setPlayer(created.createTemporaryPlayer(this.server));
                } else if (MinecraftReflection.isServerHandler(connection)) {
                    if (playerConnectionPlayer == null) {
                        playerConnectionPlayer = FuzzyReflection.fromObject(connection).getFieldByType("player", MinecraftReflection.getEntityPlayerClass());
                    }
                    Object entityPlayer = playerConnectionPlayer.get(connection);
                    created.initialize(MinecraftReflection.getBukkitEntity(entityPlayer));
                } else {
                    throw new IllegalArgumentException("Unregonized connection in NetworkManager.");
                }
                dummyInjector = this.saveInjector(networkManager, created);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot create dummy injector.", e);
            }
        }
        return dummyInjector;
    }

    private ErrorReporter filterImpossibleWarnings(ErrorReporter reporter) {
        return new DelegatedErrorReporter(reporter){

            @Override
            protected Report filterReport(Object sender, Report report, boolean detailed) {
                if (report.getType() == NetworkObjectInjector.REPORT_DETECTED_CUSTOM_SERVER_HANDLER) {
                    return null;
                }
                return report;
            }
        };
    }

    private NetworkObjectInjector saveInjector(Object networkManager, NetworkObjectInjector created) {
        NetworkObjectInjector result = this.networkManagerInjector.putIfAbsent(networkManager, created);
        if (result == null) {
            result = created;
        }
        this.playerInjector.put(created.getPlayer(), created);
        return result;
    }

    public void saveBuffered(Object handle, byte[] buffered) {
        this.readBufferedPackets.put(handle, buffered);
    }

    @Override
    public Object packetReceived(Object networkManager, Object connection, Object packet) {
        if (this.reveivedFilters.contains(packet.getClass())) {
            Integer id = this.invoker.getPacketID(packet);
            if (this.ignoredPackets.remove(packet)) {
                return packet;
            }
            Player sender = this.getInjector(networkManager, connection).getUpdatedPlayer();
            PacketType type = PacketType.findLegacy(id, PacketType.Sender.CLIENT);
            PacketContainer container = new PacketContainer(type, packet);
            PacketEvent event = this.packetReceived(container, sender, this.readBufferedPackets.get(packet));
            if (!event.isCancelled()) {
                return event.getPacket().getHandle();
            }
            return null;
        }
        return packet;
    }

    @Override
    public Object packetQueued(Object networkManager, Object connection, Object packet) {
        if (this.queuedFilters.contains(packet.getClass())) {
            Integer id = this.invoker.getPacketID(packet);
            if (this.ignoredPackets.remove(packet)) {
                return packet;
            }
            Player reciever = this.getInjector(networkManager, connection).getUpdatedPlayer();
            PacketType type = PacketType.findLegacy(id, PacketType.Sender.SERVER);
            PacketContainer container = new PacketContainer(type, packet);
            PacketEvent event = this.packetQueued(container, reciever);
            if (!event.isCancelled()) {
                return event.getPacket().getHandle();
            }
            return null;
        }
        return packet;
    }

    PacketEvent packetQueued(PacketContainer packet, Player receiver) {
        PacketEvent event = PacketEvent.fromServer(this, packet, receiver);
        this.invoker.invokePacketSending(event);
        return event;
    }

    PacketEvent packetReceived(PacketContainer packet, Player sender, byte[] buffered) {
        LegacyNetworkMarker marker = buffered != null ? new LegacyNetworkMarker(ConnectionSide.CLIENT_SIDE, buffered, packet.getType()) : null;
        PacketEvent event = PacketEvent.fromClient(this, packet, marker, sender);
        this.invoker.invokePacketRecieving(event);
        return event;
    }

    void injectPlayer(Player player) {
        try {
            NetworkObjectInjector dummy = new NetworkObjectInjector(this.filterImpossibleWarnings(this.reporter), player, this.invoker, null);
            dummy.initializePlayer(player);
            NetworkObjectInjector realInjector = (NetworkObjectInjector)this.networkManagerInjector.get(dummy.getNetworkManager());
            if (realInjector != null) {
                realInjector.setUpdatedPlayer(player);
                this.playerInjector.put(player, realInjector);
            } else {
                this.saveInjector(dummy.getNetworkManager(), dummy);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot inject " + player);
        }
    }

    void uninjectPlayer(Player player) {
        final NetworkObjectInjector injector = this.getInjector(player, false);
        if (player != null && injector != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    SpigotPacketInjector.this.cleanupInjector(injector);
                }
            }, 100L);
        }
    }

    void sendServerPacket(Player receiver, PacketContainer packet, NetworkMarker marker, boolean filters) throws InvocationTargetException {
        NetworkObjectInjector networkObject = this.getInjector(receiver, true);
        if (filters) {
            this.ignoredPackets.remove(packet.getHandle());
        } else {
            this.ignoredPackets.add(packet.getHandle());
        }
        networkObject.sendServerPacket(packet.getHandle(), marker, filters);
    }

    void processPacket(Player player, Object mcPacket) throws IllegalAccessException, InvocationTargetException {
        NetworkObjectInjector networkObject = this.getInjector(player, true);
        this.ignoredPackets.add(mcPacket);
        networkObject.processPacket(mcPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupListener() {
        Class<?> listenerClass;
        Class<?> clazz = listenerClass = SpigotPacketInjector.getSpigotListenerClass();
        synchronized (clazz) {
            try {
                Field listenersField = FieldUtils.getField(listenerClass, "listeners", true);
                Field bakedField = FieldUtils.getField(listenerClass, "baked", true);
                Map listenerMap = (Map)listenersField.get(null);
                ArrayList listenerArray = Lists.newArrayList((Object[])((Object[])bakedField.get(null)));
                listenerMap.remove(this.dynamicListener);
                listenerArray.remove(this.dynamicListener);
                bakedField.set(null, Iterables.toArray((Iterable)listenerArray, listenerClass));
                this.dynamicListener = null;
            }
            catch (Exception e) {
                this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_CLEANUP_SPIGOT).callerParam(this.dynamicListener).error(e));
            }
        }
    }

    public void cleanupAll() {
        if (this.dynamicListener != null) {
            this.cleanupListener();
        }
        if (this.backgroundId >= 0) {
            Bukkit.getScheduler().cancelTask(this.backgroundId);
            this.backgroundId = -1;
        }
        if (this.proxyPacketInjector != null) {
            this.proxyPacketInjector.cleanupAll();
        }
    }
}

