/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.player;

import com.comphenix.net.sf.cglib.proxy.Callback;
import com.comphenix.net.sf.cglib.proxy.CallbackFilter;
import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.LazyLoader;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.protocol.concurrency.IntegerSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.GamePhase;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.PlayerInjectHooks;
import com.comphenix.protocol.injector.player.PlayerInjector;
import com.comphenix.protocol.injector.player.UnsupportedListener;
import com.comphenix.protocol.injector.server.TemporaryPlayerFactory;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class NetworkObjectInjector
extends PlayerInjector {
    private IntegerSet sendingFilters;
    private MinecraftVersion safeVersion = new MinecraftVersion("1.4.4");
    private static volatile CallbackFilter callbackFilter;
    private static volatile TemporaryPlayerFactory tempPlayerFactory;

    public NetworkObjectInjector(ErrorReporter reporter, Player player, ListenerInvoker invoker, IntegerSet sendingFilters) throws IllegalAccessException {
        super(reporter, player, invoker);
        this.sendingFilters = sendingFilters;
    }

    @Override
    protected boolean hasListener(int packetID) {
        return this.sendingFilters.contains(packetID);
    }

    public Player createTemporaryPlayer(Server server) {
        if (tempPlayerFactory == null) {
            tempPlayerFactory = new TemporaryPlayerFactory();
        }
        return tempPlayerFactory.createTemporaryPlayer(server, this);
    }

    @Override
    public void sendServerPacket(Object packet, NetworkMarker marker, boolean filtered) throws InvocationTargetException {
        Object networkDelegate;
        Object object = networkDelegate = filtered ? this.networkManagerRef.getValue() : this.networkManagerRef.getOldValue();
        if (networkDelegate != null) {
            try {
                if (marker != null) {
                    this.queuedMarkers.put(packet, marker);
                }
                queueMethod.invoke(networkDelegate, packet);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access queue method.", e);
            }
        } else {
            throw new IllegalStateException("Unable to load network mananager. Cannot send packet.");
        }
    }

    @Override
    public UnsupportedListener checkListener(MinecraftVersion version, PacketListener listener) {
        if (version != null && version.compareTo(this.safeVersion) > 0) {
            return null;
        }
        int[] unsupported = new int[]{51, 56};
        if (ListeningWhitelist.containsAny(listener.getSendingWhitelist(), unsupported)) {
            return new UnsupportedListener("The NETWORK_OBJECT_INJECTOR hook doesn't support map chunk listeners.", unsupported);
        }
        return null;
    }

    @Override
    public void injectManager() {
        if (this.networkManager != null) {
            Class<?> networkInterface = this.networkManagerRef.getField().getType();
            final Object networkDelegate = this.networkManagerRef.getOldValue();
            if (!networkInterface.isInterface()) {
                throw new UnsupportedOperationException("Must use CraftBukkit 1.3.0 or later to inject into into NetworkMananger.");
            }
            MethodInterceptor queueFilter = new MethodInterceptor(){

                @Override
                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    Object packet = args[0];
                    if (packet != null) {
                        if ((packet = NetworkObjectInjector.this.handlePacketSending(packet)) != null) {
                            args[0] = packet;
                        } else {
                            return null;
                        }
                    }
                    return proxy.invokeSuper(networkDelegate, args);
                }
            };
            LazyLoader dispatch = new LazyLoader(){

                @Override
                public Object loadObject() throws Exception {
                    return networkDelegate;
                }
            };
            if (callbackFilter == null) {
                callbackFilter = new CallbackFilter(){

                    @Override
                    public int accept(Method method) {
                        if (method.equals(PlayerInjector.queueMethod)) {
                            return 0;
                        }
                        return 1;
                    }
                };
            }
            Enhancer ex = EnhancerFactory.getInstance().createEnhancer();
            ex.setSuperclass(networkInterface);
            ex.setCallbacks(new Callback[]{queueFilter, dispatch});
            ex.setCallbackFilter(callbackFilter);
            this.networkManagerRef.setValue(ex.create());
        }
    }

    @Override
    protected void cleanHook() {
        if (this.networkManagerRef != null && this.networkManagerRef.isCurrentSet()) {
            this.networkManagerRef.revertValue();
        }
    }

    @Override
    public void handleDisconnect() {
    }

    @Override
    public boolean canInject(GamePhase phase) {
        return true;
    }

    @Override
    public PlayerInjectHooks getHookType() {
        return PlayerInjectHooks.NETWORK_MANAGER_OBJECT;
    }
}

