/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.util.Arrays;

public class WirePacket {
    private final int id;
    private final byte[] bytes;

    public WirePacket(PacketType type, byte[] bytes) {
        this.id = ((PacketType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null")).getCurrentId();
        this.bytes = bytes;
    }

    public WirePacket(int id, byte[] bytes) {
        this.id = id;
        this.bytes = bytes;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void writeId(ByteBuf output) {
        WirePacket.writeVarInt(output, this.id);
    }

    public void writeBytes(ByteBuf output) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null!");
        output.writeBytes(this.bytes);
    }

    public void writeFully(ByteBuf output) {
        this.writeId(output);
        this.writeBytes(output);
    }

    public ByteBuf serialize() {
        ByteBuf buffer = Unpooled.buffer();
        this.writeFully(buffer);
        return buffer;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WirePacket) {
            WirePacket that = (WirePacket)obj;
            return this.id == that.id && Arrays.equals(this.bytes, that.bytes);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return "WirePacket[id=" + this.id + ", bytes=" + Arrays.toString(this.bytes) + "]";
    }

    private static byte[] getBytes(ByteBuf buffer) {
        byte[] array = new byte[buffer.readableBytes()];
        buffer.readBytes(array);
        return array;
    }

    public static WirePacket fromPacket(PacketContainer packet) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be null!");
        int id = packet.getType().getCurrentId();
        ByteBuf buffer = PacketContainer.createPacketBuffer();
        Method write = MinecraftMethods.getPacketWriteByteBufMethod();
        try {
            write.invoke(packet.getHandle(), buffer);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Failed to serialize packet contents.", ex);
        }
        return new WirePacket(id, WirePacket.getBytes(buffer));
    }

    public static WirePacket fromPacket(Object packet) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be null!");
        Preconditions.checkArgument((boolean)MinecraftReflection.isPacketClass(packet), (Object)"packet must be a Minecraft packet");
        PacketType type = PacketType.fromClass(packet.getClass());
        int id = type.getCurrentId();
        ByteBuf buffer = PacketContainer.createPacketBuffer();
        Method write = MinecraftMethods.getPacketWriteByteBufMethod();
        try {
            write.invoke(packet, buffer);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Failed to serialize packet contents.", ex);
        }
        return new WirePacket(id, WirePacket.getBytes(buffer));
    }

    public static void writeVarInt(ByteBuf output, int i) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null!");
        while ((i & 0xFFFFFF80) != 0) {
            output.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        output.writeByte(i);
    }

    public static int readVarInt(ByteBuf input) {
        byte b0;
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null!");
        int i = 0;
        int j = 0;
        do {
            b0 = input.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }
}

