/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.net.sf.cglib.asm.ClassReader;
import com.comphenix.net.sf.cglib.asm.MethodVisitor;
import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.compiler.EmptyClassVisitor;
import com.comphenix.protocol.reflect.compiler.EmptyMethodVisitor;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.block.BlockState;

class TileEntityAccessor<T extends BlockState> {
    private static final TileEntityAccessor<BlockState> EMPTY_ACCESSOR = new TileEntityAccessor();
    private static final ConcurrentMap<Class<?>, TileEntityAccessor<?>> cachedAccessors = Maps.newConcurrentMap();
    private FieldAccessor tileEntityField;
    private MethodAccessor readCompound;
    private MethodAccessor writeCompound;
    private boolean writeDetected;
    private boolean readDetected;

    TileEntityAccessor() {
    }

    private TileEntityAccessor(FieldAccessor tileEntityField, T state) {
        if (tileEntityField != null) {
            this.tileEntityField = tileEntityField;
            Class<?> type = tileEntityField.getField().getType();
            this.findMethods(type, state);
        }
    }

    void findMethods(Class<?> type, T state) {
        try {
            this.findMethodsUsingASM();
        }
        catch (IOException ex1) {
            try {
                this.findMethodUsingCGLib(state);
            }
            catch (Exception ex2) {
                throw new RuntimeException("Cannot find read/write methods in " + type, ex2);
            }
        }
        if (this.readCompound == null) {
            throw new RuntimeException("Unable to find read method in " + type);
        }
        if (this.writeCompound == null) {
            throw new RuntimeException("Unable to find write method in " + type);
        }
    }

    private void findMethodsUsingASM() throws IOException {
        final Class<?> nbtCompoundClass = MinecraftReflection.getNBTCompoundClass();
        final Class<?> tileEntityClass = MinecraftReflection.getTileEntityClass();
        ClassReader reader = new ClassReader(tileEntityClass.getCanonicalName());
        final String tagCompoundName = TileEntityAccessor.getJarName(MinecraftReflection.getNBTCompoundClass());
        final String expectedDesc = "(L" + tagCompoundName + ";)";
        reader.accept(new EmptyClassVisitor(){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final String methodName = name;
                if (desc.startsWith(expectedDesc)) {
                    return new EmptyMethodVisitor(){
                        private int readMethods;
                        private int writeMethods;

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            if (opcode == 182 && tagCompoundName.equals(owner) && desc.startsWith("(Ljava/lang/String")) {
                                if (desc.endsWith(")V")) {
                                    ++this.writeMethods;
                                } else {
                                    ++this.readMethods;
                                }
                            }
                        }

                        @Override
                        public void visitEnd() {
                            if (this.readMethods > this.writeMethods) {
                                TileEntityAccessor.this.readCompound = Accessors.getMethodAccessor(tileEntityClass, methodName, nbtCompoundClass);
                            } else if (this.writeMethods > this.readMethods) {
                                TileEntityAccessor.this.writeCompound = Accessors.getMethodAccessor(tileEntityClass, methodName, nbtCompoundClass);
                            }
                            super.visitEnd();
                        }
                    };
                }
                return null;
            }
        }, 0);
    }

    private void findMethodUsingCGLib(T blockState) throws IOException {
        Class<?> nbtCompoundClass = MinecraftReflection.getNBTCompoundClass();
        Enhancer enhancer = EnhancerFactory.getInstance().createEnhancer();
        enhancer.setSuperclass(nbtCompoundClass);
        enhancer.setCallback(new MethodInterceptor(){

            @Override
            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (method.getReturnType().equals(Void.TYPE)) {
                    TileEntityAccessor.this.writeDetected = true;
                } else {
                    TileEntityAccessor.this.readDetected = true;
                }
                throw new RuntimeException("Stop execution.");
            }
        });
        Object compound = enhancer.create();
        Object tileEntity = this.tileEntityField.get(blockState);
        for (Method method : FuzzyReflection.fromObject(tileEntity, true).getMethodListByParameters(Void.TYPE, new Class[]{nbtCompoundClass})) {
            try {
                this.readDetected = false;
                this.writeDetected = false;
                method.invoke(tileEntity, compound);
            }
            catch (Exception e) {
                if (this.readDetected) {
                    this.readCompound = Accessors.getMethodAccessor(method, true);
                }
                if (!this.writeDetected) continue;
                this.writeCompound = Accessors.getMethodAccessor(method, true);
            }
        }
    }

    private static String getJarName(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '/');
    }

    public NbtCompound readBlockState(T state) {
        NbtCompound output = NbtFactory.ofCompound("");
        Object tileEntity = this.tileEntityField.get(state);
        this.writeCompound.invoke(tileEntity, NbtFactory.fromBase(output).getHandle());
        return output;
    }

    public void writeBlockState(T state, NbtCompound compound) {
        Object tileEntity = this.tileEntityField.get(state);
        this.readCompound.invoke(tileEntity, NbtFactory.fromBase(compound).getHandle());
    }

    public static <T extends BlockState> TileEntityAccessor<T> getAccessor(T state) {
        Class<?> craftBlockState = state.getClass();
        TileEntityAccessor<BlockState> accessor = (TileEntityAccessor<BlockState>)cachedAccessors.get(craftBlockState);
        if (accessor == null) {
            TileEntityAccessor<Object> created = null;
            FieldAccessor field = null;
            try {
                field = Accessors.getFieldAccessor(craftBlockState, MinecraftReflection.getTileEntityClass(), true);
            }
            catch (Exception e) {
                created = EMPTY_ACCESSOR;
            }
            if (field != null) {
                created = new TileEntityAccessor<T>(field, state);
            }
            if ((accessor = cachedAccessors.putIfAbsent(craftBlockState, created)) == null) {
                accessor = created;
            }
        }
        return accessor != EMPTY_ACCESSOR ? accessor : null;
    }
}

