/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.WrappedChunkCoordinate;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import org.bukkit.inventory.ItemStack;

public class WrappedWatchableObject
extends AbstractWrapper {
    private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherItemClass();
    private static ConstructorAccessor constructor;
    private final StructureModifier<Object> modifier;

    public WrappedWatchableObject(Object handle) {
        super(HANDLE_TYPE);
        this.setHandle(handle);
        this.modifier = new StructureModifier(this.handleType).withTarget(handle);
    }

    public WrappedWatchableObject(WrappedDataWatcher.WrappedDataWatcherObject watcherObject, Object value) {
        this(WrappedWatchableObject.newHandle(watcherObject, value));
    }

    private static Object newHandle(WrappedDataWatcher.WrappedDataWatcherObject watcherObject, Object value) {
        if (constructor == null) {
            constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
        }
        return constructor.invoke(watcherObject.getHandle(), value);
    }

    public WrappedDataWatcher.WrappedDataWatcherObject getWatcherObject() {
        return new WrappedDataWatcher.WrappedDataWatcherObject(this.modifier.read(0));
    }

    public int getIndex() {
        return this.getWatcherObject().getIndex();
    }

    public Object getValue() {
        return WrappedWatchableObject.getWrapped(this.getRawValue());
    }

    public Object getRawValue() {
        return this.modifier.readSafely(1);
    }

    static Object getWrapped(Object value) {
        if (MinecraftReflection.isItemStack(value)) {
            return BukkitConverters.getItemStackConverter().getSpecific(value);
        }
        if (MinecraftReflection.isChunkCoordinates(value)) {
            return new WrappedChunkCoordinate((Comparable)value);
        }
        return value;
    }

    static Class<?> getWrappedType(Class<?> unwrapped) {
        if (unwrapped.equals(MinecraftReflection.getChunkPositionClass())) {
            return ChunkPosition.class;
        }
        if (unwrapped.equals(MinecraftReflection.getBlockPositionClass())) {
            return BlockPosition.class;
        }
        if (unwrapped.equals(MinecraftReflection.getChunkCoordinatesClass())) {
            return WrappedChunkCoordinate.class;
        }
        if (unwrapped.equals(MinecraftReflection.getItemStackClass())) {
            return ItemStack.class;
        }
        return unwrapped;
    }

    public void setValue(Object value, boolean updateClient) {
        this.modifier.write(1, WrappedWatchableObject.getUnwrapped(value));
        if (updateClient) {
            this.setDirtyState(true);
        }
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    static Object getUnwrapped(Object wrapped) {
        if (wrapped instanceof ChunkPosition) {
            return ChunkPosition.getConverter().getGeneric(MinecraftReflection.getChunkPositionClass(), (ChunkPosition)wrapped);
        }
        if (wrapped instanceof BlockPosition) {
            return BlockPosition.getConverter().getGeneric(MinecraftReflection.getBlockPositionClass(), (BlockPosition)wrapped);
        }
        if (wrapped instanceof WrappedChunkCoordinate) {
            return ((WrappedChunkCoordinate)wrapped).getHandle();
        }
        if (wrapped instanceof ItemStack) {
            return BukkitConverters.getItemStackConverter().getGeneric(MinecraftReflection.getItemStackClass(), (ItemStack)wrapped);
        }
        return wrapped;
    }

    static Class<?> getUnwrappedType(Class<?> wrapped) {
        if (wrapped.equals(ChunkPosition.class)) {
            return MinecraftReflection.getChunkPositionClass();
        }
        if (wrapped.equals(BlockPosition.class)) {
            return MinecraftReflection.getBlockPositionClass();
        }
        if (wrapped.equals(WrappedChunkCoordinate.class)) {
            return MinecraftReflection.getChunkCoordinatesClass();
        }
        if (ItemStack.class.isAssignableFrom(wrapped)) {
            return MinecraftReflection.getItemStackClass();
        }
        return wrapped;
    }

    public boolean getDirtyState() {
        return (Boolean)this.modifier.read(2);
    }

    public void setDirtyState(boolean dirty) {
        this.modifier.write(2, dirty);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedWatchableObject) {
            WrappedWatchableObject other = (WrappedWatchableObject)obj;
            return this.getWatcherObject().equals(other.getWatcherObject()) && this.getRawValue().equals(other.getRawValue()) && this.getDirtyState() == other.getDirtyState();
        }
        return false;
    }

    public String toString() {
        return "DataWatcherItem[object=" + this.getWatcherObject() + ", value=" + this.getValue() + ", dirty=" + this.getDirtyState() + "]";
    }
}

