/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.Constructor;

public class MinecraftKey {
    private final String prefix;
    private final String key;
    private static Constructor<?> constructor = null;

    public MinecraftKey(String prefix, String key) {
        this.prefix = prefix;
        this.key = key;
    }

    public MinecraftKey(String key) {
        this("minecraft", key);
    }

    public static MinecraftKey fromHandle(Object handle) {
        StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle).withType(String.class);
        return new MinecraftKey((String)modifier.read(0), (String)modifier.read(1));
    }

    public static MinecraftKey fromEnum(Enum<?> value) {
        return new MinecraftKey(value.name().toLowerCase().replace("_", "."));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getKey() {
        return this.key;
    }

    public String getFullKey() {
        return this.prefix + ":" + this.key;
    }

    public String getEnumFormat() {
        return this.key.toUpperCase().replace(".", "_");
    }

    public static EquivalentConverter<MinecraftKey> getConverter() {
        return new EquivalentConverter<MinecraftKey>(){

            @Override
            public MinecraftKey getSpecific(Object generic) {
                return MinecraftKey.fromHandle(generic);
            }

            @Override
            public Object getGeneric(Class<?> genericType, MinecraftKey specific) {
                if (constructor == null) {
                    try {
                        constructor = MinecraftReflection.getMinecraftKeyClass().getConstructor(String.class, String.class);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException("Failed to obtain MinecraftKey constructor", e);
                    }
                }
                try {
                    return constructor.newInstance(specific.getPrefix(), specific.getKey());
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to create new MinecraftKey", e);
                }
            }

            @Override
            public Class<MinecraftKey> getSpecificType() {
                return MinecraftKey.class;
            }
        };
    }
}

