/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.updater;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.updater.Updater;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class BukkitUpdater
extends Updater {
    private URL url;
    private File file;
    private Thread thread;
    private int id = -1;
    private String apiKey = null;
    private static final String TITLE_VALUE = "name";
    private static final String LINK_VALUE = "downloadUrl";
    private static final String TYPE_VALUE = "releaseType";
    private static final String VERSION_VALUE = "gameVersion";
    private static final Object FILE_NAME = "fileName";
    private static final String QUERY = "/servermods/files?projectIds=";
    private static final String HOST = "https://api.curseforge.com";
    private static final int BYTE_SIZE = 1024;
    private YamlConfiguration config;
    private String updateFolder;

    public BukkitUpdater(Plugin plugin, int id, File file, Updater.UpdateType type, boolean announce) {
        super(plugin, type, announce);
        this.file = file;
        this.id = id;
        this.updateFolder = plugin.getServer().getUpdateFolder();
        File dataFolder = plugin.getDataFolder();
        if (dataFolder != null) {
            File pluginFile = plugin.getDataFolder().getParentFile();
            File updaterFile = new File(pluginFile, "Updater");
            File updaterConfigFile = new File(updaterFile, "config.yml");
            if (!updaterFile.exists()) {
                updaterFile.mkdir();
            }
            if (!updaterConfigFile.exists()) {
                try {
                    updaterConfigFile.createNewFile();
                }
                catch (IOException e) {
                    plugin.getLogger().severe("The updater could not create a configuration in " + updaterFile.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            this.config = YamlConfiguration.loadConfiguration((File)updaterConfigFile);
            this.config.options().header("This configuration file affects all plugins using the Updater system (version 2+ - http://forums.bukkit.org/threads/96681/ )\nIf you wish to use your API key, read http://wiki.bukkit.org/ServerMods_API and place it below.\nSome updating systems will not adhere to the disabled value, but these may be turned off in their plugin's configuration.");
            this.config.addDefault("api-key", (Object)"PUT_API_KEY_HERE");
            this.config.addDefault("disable", (Object)false);
            if (this.config.get("api-key", null) == null) {
                this.config.options().copyDefaults(true);
                try {
                    this.config.save(updaterConfigFile);
                }
                catch (IOException e) {
                    plugin.getLogger().severe("The updater could not save the configuration in " + updaterFile.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            if (this.config.getBoolean("disable")) {
                this.result = Updater.UpdateResult.DISABLED;
                return;
            }
            String key = this.config.getString("api-key");
            if (key.equalsIgnoreCase("PUT_API_KEY_HERE") || key.equals("")) {
                key = null;
            }
            this.apiKey = key;
        }
        try {
            this.url = new URL("https://api.curseforge.com/servermods/files?projectIds=" + id);
        }
        catch (MalformedURLException e) {
            plugin.getLogger().severe("The project ID provided for updating, " + id + " is invalid.");
            this.result = Updater.UpdateResult.FAIL_BADID;
            e.printStackTrace();
        }
    }

    @Override
    public void start(Updater.UpdateType type) {
        this.waitForThread();
        this.type = type;
        this.thread = new Thread(new UpdateRunnable());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(File folder, String file, String u) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL(u);
            int fileLength = url.openConnection().getContentLength();
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(folder.getAbsolutePath() + "/" + file);
            byte[] data = new byte[1024];
            if (this.announce) {
                this.plugin.getLogger().info("About to download a new update: " + this.versionName);
            }
            long downloaded = 0L;
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
                int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                if (!this.announce || percent % 10 != 0) continue;
                this.plugin.getLogger().info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
            }
            for (File xFile : new File(this.plugin.getDataFolder().getParent(), this.updateFolder).listFiles()) {
                if (!xFile.getName().endsWith(".zip")) continue;
                xFile.delete();
            }
            File dFile = new File(folder.getAbsolutePath() + "/" + file);
            if (dFile.getName().endsWith(".zip")) {
                this.unzip(dFile.getCanonicalPath());
            }
            if (this.announce) {
                this.plugin.getLogger().info("Finished updating.");
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("The auto-updater tried to download a new update, but was unsuccessful.");
            this.result = Updater.UpdateResult.FAIL_DOWNLOAD;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void unzip(String file) {
        try {
            File fSourceZip = new File(file);
            String zipPath = file.substring(0, file.length() - 4);
            ZipFile zipFile = new ZipFile(fSourceZip);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
                String name = destinationFilePath.getName();
                if (name.endsWith(".jar") && this.pluginFile(name)) {
                    destinationFilePath.renameTo(new File(this.plugin.getDataFolder().getParent(), this.updateFolder + "/" + name));
                }
                entry = null;
                destinationFilePath = null;
            }
            e = null;
            zipFile.close();
            zipFile = null;
            for (File dFile : new File(zipPath).listFiles()) {
                if (dFile.isDirectory() && this.pluginFile(dFile.getName())) {
                    File oFile = new File(this.plugin.getDataFolder().getParent(), dFile.getName());
                    File[] contents = oFile.listFiles();
                    for (File cFile : dFile.listFiles()) {
                        boolean found = false;
                        for (File xFile : contents) {
                            if (!xFile.getName().equals(cFile.getName())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            cFile.renameTo(new File(oFile.getCanonicalFile() + "/" + cFile.getName()));
                            continue;
                        }
                        cFile.delete();
                    }
                }
                dFile.delete();
            }
            new File(zipPath).delete();
            fSourceZip.delete();
        }
        catch (IOException ex) {
            this.plugin.getLogger().warning("The auto-updater tried to unzip a new update file, but was unsuccessful.");
            this.result = Updater.UpdateResult.FAIL_DOWNLOAD;
            ex.printStackTrace();
        }
        new File(file).delete();
    }

    private boolean pluginFile(String name) {
        for (File file : new File("plugins").listFiles()) {
            if (!file.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean read() {
        try {
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(5000);
            if (this.apiKey != null) {
                conn.addRequestProperty("X-API-Key", this.apiKey);
            }
            conn.addRequestProperty("User-Agent", "Updater (by Gravity)");
            conn.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String response = reader.readLine();
            JSONArray array = (JSONArray)JSONValue.parse((String)response);
            if (array.size() == 0) {
                this.plugin.getLogger().warning("The updater could not find any files for the project id " + this.id);
                this.result = Updater.UpdateResult.FAIL_BADID;
                return false;
            }
            JSONObject jsonObject = (JSONObject)array.get(array.size() - 1);
            this.versionFileName = (String)jsonObject.get(FILE_NAME);
            this.versionName = (String)jsonObject.get((Object)TITLE_VALUE);
            this.versionLink = (String)jsonObject.get((Object)LINK_VALUE);
            this.versionType = (String)jsonObject.get((Object)TYPE_VALUE);
            this.versionGameVersion = (String)jsonObject.get((Object)VERSION_VALUE);
            return true;
        }
        catch (IOException e) {
            if (e.getMessage().contains("HTTP response code: 403")) {
                this.plugin.getLogger().warning("dev.bukkit.org rejected the API key provided in plugins/Updater/config.yml");
                this.plugin.getLogger().warning("Please double-check your configuration to ensure it is correct.");
                this.result = Updater.UpdateResult.FAIL_APIKEY;
            } else {
                this.plugin.getLogger().warning("The updater could not contact dev.bukkit.org for updating.");
                this.plugin.getLogger().warning("If you have not recently modified your configuration and this is the first time you are seeing this message, the site may be experiencing temporary downtime.");
                this.result = Updater.UpdateResult.FAIL_DBO;
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getRemoteVersion() {
        return this.getLatestName();
    }

    private class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            block6: {
                try {
                    if (BukkitUpdater.this.url == null || !BukkitUpdater.this.read() || !BukkitUpdater.this.versionCheck(BukkitUpdater.this.versionName)) break block6;
                    this.performUpdate();
                }
                catch (Exception e) {
                    ProtocolLibrary.getErrorReporter().reportDetailed((Object)BukkitUpdater.this, Report.newBuilder(Updater.REPORT_CANNOT_UPDATE_PLUGIN).error(e).callerParam(this));
                }
                finally {
                    for (Runnable listener : BukkitUpdater.this.listeners) {
                        BukkitUpdater.this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(BukkitUpdater.this.plugin, listener);
                    }
                }
            }
        }

        private void performUpdate() {
            if (BukkitUpdater.this.versionLink != null && BukkitUpdater.this.type != Updater.UpdateType.NO_DOWNLOAD) {
                File pluginFolder = BukkitUpdater.this.plugin.getDataFolder().getParentFile();
                File destinationFolder = new File(pluginFolder, BukkitUpdater.this.updateFolder);
                String name = BukkitUpdater.this.file.getName();
                if (BukkitUpdater.this.versionLink.endsWith(".zip")) {
                    name = BukkitUpdater.this.versionFileName;
                }
                BukkitUpdater.this.saveFile(destinationFolder, name, BukkitUpdater.this.versionLink);
            } else {
                BukkitUpdater.this.result = Updater.UpdateResult.UPDATE_AVAILABLE;
            }
        }
    }
}

