/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.ProtocolConfig;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.error.BasicErrorReporter;
import com.comphenix.protocol.error.ErrorReporter;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;

public class ProtocolLibrary {
    public static final String MINIMUM_MINECRAFT_VERSION = "1.9";
    public static final String MAXIMUM_MINECRAFT_VERSION = "1.9.4";
    public static final String MINECRAFT_LAST_RELEASE_DATE = "2016-05-10";
    public static final List<String> INCOMPATIBLE = Arrays.asList("TagAPI");
    private static Plugin plugin;
    private static ProtocolConfig config;
    private static ProtocolManager manager;
    private static ErrorReporter reporter;
    private static ListeningScheduledExecutorService executorAsync;
    private static ListeningScheduledExecutorService executorSync;
    private static boolean updatesDisabled;
    private static boolean initialized;

    protected static void init(Plugin plugin, ProtocolConfig config, ProtocolManager manager, ErrorReporter reporter, ListeningScheduledExecutorService executorAsync, ListeningScheduledExecutorService executorSync) {
        Validate.isTrue((!initialized ? 1 : 0) != 0, (String)"ProtocolLib has already been initialized.");
        ProtocolLibrary.plugin = plugin;
        ProtocolLibrary.config = config;
        ProtocolLibrary.manager = manager;
        ProtocolLibrary.reporter = reporter;
        ProtocolLibrary.executorAsync = executorAsync;
        ProtocolLibrary.executorSync = executorSync;
        ProtocolLogger.init(plugin);
        initialized = true;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static ProtocolConfig getConfig() {
        return config;
    }

    public static ProtocolManager getProtocolManager() {
        return manager;
    }

    public static ErrorReporter getErrorReporter() {
        return reporter;
    }

    public static ListeningScheduledExecutorService getExecutorAsync() {
        return executorAsync;
    }

    public static ListeningScheduledExecutorService getExecutorSync() {
        return executorSync;
    }

    public static void disableUpdates() {
        updatesDisabled = true;
    }

    public static boolean updatesDisabled() {
        return updatesDisabled;
    }

    static {
        reporter = new BasicErrorReporter();
    }
}

