/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.executors.BukkitExecutors;
import com.comphenix.protocol.Application;
import com.comphenix.protocol.CommandFilter;
import com.comphenix.protocol.CommandPacket;
import com.comphenix.protocol.CommandProtocol;
import com.comphenix.protocol.ProtocolConfig;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.async.AsyncFilterManager;
import com.comphenix.protocol.error.BasicErrorReporter;
import com.comphenix.protocol.error.DelegatedErrorReporter;
import com.comphenix.protocol.error.DetailedErrorReporter;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.DelayedSingleTask;
import com.comphenix.protocol.injector.InternalManager;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.injector.PlayerInjectHooks;
import com.comphenix.protocol.metrics.Statistics;
import com.comphenix.protocol.reflect.compiler.BackgroundCompiler;
import com.comphenix.protocol.updater.Updater;
import com.comphenix.protocol.utility.ChatExtensions;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ProtocolLib
extends JavaPlugin {
    public static final ReportType REPORT_CANNOT_LOAD_CONFIG = new ReportType("Cannot load configuration");
    public static final ReportType REPORT_CANNOT_DELETE_CONFIG = new ReportType("Cannot delete old ProtocolLib configuration.");
    public static final ReportType REPORT_CANNOT_PARSE_INJECTION_METHOD = new ReportType("Cannot parse injection method. Using default.");
    public static final ReportType REPORT_PLUGIN_LOAD_ERROR = new ReportType("Cannot load ProtocolLib.");
    public static final ReportType REPORT_PLUGIN_ENABLE_ERROR = new ReportType("Cannot enable ProtocolLib.");
    public static final ReportType REPORT_METRICS_IO_ERROR = new ReportType("Unable to enable metrics due to network problems.");
    public static final ReportType REPORT_METRICS_GENERIC_ERROR = new ReportType("Unable to enable metrics due to network problems.");
    public static final ReportType REPORT_CANNOT_PARSE_MINECRAFT_VERSION = new ReportType("Unable to retrieve current Minecraft version. Assuming %s");
    public static final ReportType REPORT_CANNOT_DETECT_CONFLICTING_PLUGINS = new ReportType("Unable to detect conflicting plugin versions.");
    public static final ReportType REPORT_CANNOT_REGISTER_COMMAND = new ReportType("Cannot register command %s: %s");
    public static final ReportType REPORT_CANNOT_CREATE_TIMEOUT_TASK = new ReportType("Unable to create packet timeout task.");
    public static final ReportType REPORT_CANNOT_UPDATE_PLUGIN = new ReportType("Cannot perform automatic updates.");
    static final String BUKKIT_DEV_SLUG = "protocollib";
    static final int BUKKIT_DEV_ID = 45564;
    static final long MILLI_PER_SECOND = 1000L;
    private static final String PERMISSION_INFO = "protocol.info";
    private static InternalManager protocolManager;
    private static ErrorReporter reporter;
    private static ProtocolConfig config;
    private Statistics statistics;
    private static ListeningScheduledExecutorService executorAsync;
    private static ListeningScheduledExecutorService executorSync;
    private BackgroundCompiler backgroundCompiler;
    private int packetTask = -1;
    private int tickCounter = 0;
    private static final int ASYNC_MANAGER_DELAY = 1;
    private DelayedSingleTask unhookTask;
    private int configExpectedMod = -1;
    private Updater updater;
    public static boolean UPDATES_DISABLED;
    private static Logger logger;
    private Handler redirectHandler;
    private CommandProtocol commandProtocol;
    private CommandPacket commandPacket;
    private CommandFilter commandFilter;
    private boolean skipDisable;

    public void onLoad() {
        logger = this.getLoggerSafely();
        Application.registerPrimaryThread();
        EnhancerFactory.getInstance().setClassLoader(this.getClassLoader());
        executorAsync = BukkitExecutors.newAsynchronous((Plugin)this);
        executorSync = BukkitExecutors.newSynchronous((Plugin)this);
        DetailedErrorReporter detailedReporter = new DetailedErrorReporter((Plugin)this);
        reporter = this.getFilteredReporter(detailedReporter);
        this.saveDefaultConfig();
        this.reloadConfig();
        try {
            config = new ProtocolConfig((Plugin)this);
        }
        catch (Exception e) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_LOAD_CONFIG).error(e));
            if (this.deleteConfig()) {
                config = new ProtocolConfig((Plugin)this);
            }
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_DELETE_CONFIG));
        }
        if (config.isDebug()) {
            logger.warning("Debug mode is enabled!");
        }
        if (config.isDetailedErrorReporting()) {
            detailedReporter.setDetailedReporting(true);
            logger.warning("Detailed error reporting enabled!");
        }
        try {
            this.checkConflictingVersions();
            MinecraftVersion version = this.verifyMinecraftVersion();
            this.updater = Updater.create(this, 45564, this.getFile(), Updater.UpdateType.NO_DOWNLOAD, true);
            this.unhookTask = new DelayedSingleTask((Plugin)this);
            protocolManager = PacketFilterManager.newBuilder().classLoader(this.getClassLoader()).server(this.getServer()).library((Plugin)this).minecraftVersion(version).unhookTask(this.unhookTask).reporter(reporter).build();
            ProtocolLibrary.init((Plugin)this, config, protocolManager, reporter, executorAsync, executorSync);
            detailedReporter.addGlobalParameter("manager", protocolManager);
            try {
                PlayerInjectHooks hook = config.getInjectionMethod();
                if (!protocolManager.getPlayerHook().equals((Object)hook)) {
                    logger.info("Changing player hook from " + (Object)((Object)protocolManager.getPlayerHook()) + " to " + (Object)((Object)hook));
                    protocolManager.setPlayerHook(hook);
                }
            }
            catch (IllegalArgumentException e) {
                reporter.reportWarning((Object)config, Report.newBuilder(REPORT_CANNOT_PARSE_INJECTION_METHOD).error(e));
            }
            this.initializeCommands();
            this.setupBroadcastUsers(PERMISSION_INFO);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_PLUGIN_LOAD_ERROR).error(e).callerParam(protocolManager));
            this.disablePlugin();
        }
    }

    private void initializeCommands() {
        for (ProtocolCommand command : ProtocolCommand.values()) {
            try {
                switch (command) {
                    case PROTOCOL: {
                        this.commandProtocol = new CommandProtocol(reporter, (Plugin)this, this.updater, config);
                        break;
                    }
                    case FILTER: {
                        this.commandFilter = new CommandFilter(reporter, (Plugin)this, config);
                        break;
                    }
                    case PACKET: {
                        this.commandPacket = new CommandPacket(reporter, (Plugin)this, logger, this.commandFilter, protocolManager);
                    }
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (LinkageError e) {
                logger.warning("Failed to register command " + command.name() + ": " + e);
            }
            catch (Throwable e) {
                reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_REGISTER_COMMAND).messageParam(command.name(), e.getMessage()).error(e));
            }
        }
    }

    private ErrorReporter getFilteredReporter(ErrorReporter reporter) {
        return new DelegatedErrorReporter(reporter){
            private int lastModCount;
            private Set<String> reports;
            {
                this.lastModCount = -1;
                this.reports = Sets.newHashSet();
            }

            @Override
            protected Report filterReport(Object sender, Report report, boolean detailed) {
                try {
                    String canonicalName = ReportType.getReportName(sender, report.getType());
                    String reportName = ((String)Iterables.getLast((Iterable)Splitter.on((String)"#").split((CharSequence)canonicalName))).toUpperCase();
                    if (config != null && config.getModificationCount() != this.lastModCount) {
                        this.reports = Sets.newHashSet(config.getSuppressedReports());
                        this.lastModCount = config.getModificationCount();
                    }
                    if (this.reports.contains(canonicalName) || this.reports.contains(reportName)) {
                        return null;
                    }
                }
                catch (Exception e) {
                    logger.warning("Error filtering reports: " + e.toString());
                }
                return report;
            }
        };
    }

    private boolean deleteConfig() {
        return config.getFile().delete();
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (config != null) {
            config.reloadConfig();
        }
    }

    private void setupBroadcastUsers(final String permission) {
        if (this.redirectHandler != null) {
            return;
        }
        this.redirectHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                    ProtocolLib.this.commandPacket.broadcastMessageSilently(record.getMessage(), permission);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        logger.addHandler(this.redirectHandler);
    }

    public void onEnable() {
        try {
            Server server = this.getServer();
            PluginManager manager = server.getPluginManager();
            if (manager == null) {
                return;
            }
            if (protocolManager == null) {
                Logger directLogging = Logger.getLogger("Minecraft");
                String[] message = new String[]{" ProtocolLib does not support plugin reloaders! ", " Please use the built-in reload command! "};
                for (String line : ChatExtensions.toFlowerBox(message, "*", 3, 1)) {
                    directLogging.severe(line);
                }
                this.disablePlugin();
                return;
            }
            this.checkForIncompatibility(manager);
            if (this.backgroundCompiler == null && config.isBackgroundCompilerEnabled()) {
                this.backgroundCompiler = new BackgroundCompiler(this.getClassLoader(), reporter);
                BackgroundCompiler.setInstance(this.backgroundCompiler);
                logger.info("Started structure compiler thread.");
            } else {
                logger.info("Structure compiler thread has been disabled.");
            }
            this.registerCommand("protocol", this.commandProtocol);
            this.registerCommand("packet", this.commandPacket);
            this.registerCommand("filter", this.commandFilter);
            protocolManager.registerEvents(manager, (Plugin)this);
            this.createPacketTask(server);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_PLUGIN_ENABLE_ERROR).error(e));
            this.disablePlugin();
            return;
        }
        try {
            if (config.isMetricsEnabled()) {
                this.statistics = new Statistics((Plugin)this);
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (IOException e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_METRICS_IO_ERROR).error(e).callerParam(this.statistics));
        }
        catch (Throwable e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_METRICS_GENERIC_ERROR).error(e).callerParam(this.statistics));
        }
    }

    private void checkForIncompatibility(PluginManager manager) {
        for (String plugin : ProtocolLibrary.INCOMPATIBLE) {
            if (manager.getPlugin(plugin) == null) continue;
            if (plugin.equals("TagAPI")) {
                Plugin iTag = manager.getPlugin("iTag");
                if (iTag != null && !iTag.getDescription().getVersion().startsWith("1.0")) continue;
                logger.severe("Detected incompatible plugin: TagAPI");
                continue;
            }
            logger.severe("Detected incompatible plugin: " + plugin);
        }
    }

    private MinecraftVersion verifyMinecraftVersion() {
        MinecraftVersion minimum = new MinecraftVersion("1.9");
        MinecraftVersion maximum = new MinecraftVersion("1.9.4");
        try {
            MinecraftVersion current = new MinecraftVersion(this.getServer());
            if (!config.getIgnoreVersionCheck().equals(current.getVersion())) {
                if (current.compareTo(minimum) < 0) {
                    logger.warning("Version " + current + " is lower than the minimum " + minimum);
                }
                if (current.compareTo(maximum) > 0) {
                    logger.warning("Version " + current + " has not yet been tested! Proceed with caution.");
                }
            }
            return current;
        }
        catch (Exception e) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_PARSE_MINECRAFT_VERSION).error(e).messageParam(maximum));
            return maximum;
        }
    }

    private void checkConflictingVersions() {
        Pattern ourPlugin = Pattern.compile("ProtocolLib-(.*)\\.jar");
        MinecraftVersion currentVersion = new MinecraftVersion(this.getDescription().getVersion());
        MinecraftVersion newestVersion = null;
        File loadedFile = this.getFile();
        try {
            File pluginFolder = this.getDataFolder().getParentFile();
            File[] candidates = pluginFolder.listFiles();
            if (candidates != null) {
                for (File candidate : pluginFolder.listFiles()) {
                    Matcher match;
                    if (!candidate.isFile() || candidate.equals(loadedFile) || !(match = ourPlugin.matcher(candidate.getName())).matches()) continue;
                    MinecraftVersion version = new MinecraftVersion(match.group(1));
                    if (candidate.length() == 0L) {
                        logger.info((candidate.delete() ? "Deleted " : "Could not delete ") + candidate);
                        continue;
                    }
                    if (newestVersion != null && newestVersion.compareTo(version) >= 0) continue;
                    newestVersion = version;
                }
            }
        }
        catch (Exception e) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_DETECT_CONFLICTING_PLUGINS).error(e));
        }
        if (newestVersion != null && currentVersion.compareTo(newestVersion) < 0) {
            this.skipDisable = true;
            throw new IllegalStateException(String.format("Detected a newer version of ProtocolLib (%s) in plugin folder than the current (%s). Disabling.", newestVersion.getVersion(), currentVersion.getVersion()));
        }
    }

    private void registerCommand(String name, CommandExecutor executor) {
        try {
            if (executor == null) {
                return;
            }
            PluginCommand command = this.getCommand(name);
            if (command == null) {
                throw new RuntimeException("plugin.yml might be corrupt.");
            }
            command.setExecutor(executor);
        }
        catch (RuntimeException e) {
            reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_REGISTER_COMMAND).messageParam(name, e.getMessage()).error(e));
        }
    }

    private void disablePlugin() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    private void createPacketTask(Server server) {
        block5: {
            try {
                if (this.packetTask >= 0) {
                    throw new IllegalStateException("Packet task has already been created");
                }
                this.packetTask = server.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        AsyncFilterManager manager = (AsyncFilterManager)protocolManager.getAsynchronousManager();
                        manager.sendProcessedPackets(ProtocolLib.this.tickCounter++, true);
                        ProtocolLib.this.updateConfiguration();
                        if (!UPDATES_DISABLED && ProtocolLib.this.tickCounter % 20 == 0) {
                            ProtocolLib.this.checkUpdates();
                        }
                    }
                }, 1L, 1L);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                if (this.packetTask != -1) break block5;
                reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_CREATE_TIMEOUT_TASK).error(e));
            }
        }
    }

    private void updateConfiguration() {
        if (config != null && config.getModificationCount() != this.configExpectedMod) {
            this.configExpectedMod = config.getModificationCount();
            protocolManager.setDebug(config.isDebug());
        }
    }

    private void checkUpdates() {
        long currentTime = System.currentTimeMillis() / 1000L;
        try {
            long updateTime = config.getAutoLastTime() + config.getAutoDelay();
            if (currentTime > updateTime && !this.updater.isChecking()) {
                if (config.isAutoDownload()) {
                    this.commandProtocol.updateVersion((CommandSender)this.getServer().getConsoleSender(), false);
                } else if (config.isAutoNotify()) {
                    this.commandProtocol.checkVersion((CommandSender)this.getServer().getConsoleSender(), false);
                } else {
                    this.commandProtocol.updateFinished();
                }
            }
        }
        catch (Exception e) {
            reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_UPDATE_PLUGIN).error(e));
            UPDATES_DISABLED = true;
        }
    }

    public void onDisable() {
        if (this.skipDisable) {
            return;
        }
        if (this.backgroundCompiler != null) {
            this.backgroundCompiler.shutdownAll();
            this.backgroundCompiler = null;
            BackgroundCompiler.setInstance(null);
        }
        if (this.packetTask >= 0) {
            this.getServer().getScheduler().cancelTask(this.packetTask);
            this.packetTask = -1;
        }
        if (this.redirectHandler != null) {
            logger.removeHandler(this.redirectHandler);
        }
        if (protocolManager == null) {
            return;
        }
        protocolManager.close();
        if (this.unhookTask != null) {
            this.unhookTask.close();
        }
        protocolManager = null;
        this.statistics = null;
        reporter = new BasicErrorReporter();
    }

    private Logger getLoggerSafely() {
        Logger log = null;
        try {
            log = this.getLogger();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (log == null) {
            log = Logger.getLogger("Minecraft");
        }
        return log;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    static {
        reporter = new BasicErrorReporter();
    }

    private static enum ProtocolCommand {
        FILTER,
        PACKET,
        PROTOCOL;

    }
}

