/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.WrappedChunkCoordinate;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import org.bukkit.inventory.ItemStack;

public class WrappedWatchableObject
extends AbstractWrapper {
    private static boolean hasInitialized;
    private static StructureModifier<Object> baseModifier;
    private static Constructor<?> watchableConstructor;
    private static Class<?> watchableObjectClass;
    protected StructureModifier<Object> modifier;
    private Class<?> typeClass;

    public WrappedWatchableObject(Object handle) {
        super(MinecraftReflection.getWatchableObjectClass());
        this.load(handle);
    }

    public WrappedWatchableObject(int index, Object value) {
        super(MinecraftReflection.getWatchableObjectClass());
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be NULL.");
        }
        Integer typeID = WrappedDataWatcher.getTypeID(value.getClass());
        if (typeID != null) {
            if (watchableConstructor == null) {
                try {
                    watchableConstructor = MinecraftReflection.getWatchableObjectClass().getConstructor(Integer.TYPE, Integer.TYPE, Object.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot get the WatchableObject(int, int, Object) constructor.", e);
                }
            }
            try {
                this.load(watchableConstructor.newInstance(typeID, index, WrappedWatchableObject.getUnwrapped(value)));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot construct underlying WatchableObject.", e);
            }
        }
        throw new IllegalArgumentException("Cannot watch the type " + value.getClass());
    }

    private void load(Object handle) {
        WrappedWatchableObject.initialize();
        this.handle = handle;
        this.modifier = baseModifier.withTarget(handle);
        if (!watchableObjectClass.isAssignableFrom(handle.getClass())) {
            throw new ClassCastException("Cannot cast the class " + handle.getClass().getName() + " to " + watchableObjectClass.getName());
        }
    }

    private static void initialize() {
        if (!hasInitialized) {
            hasInitialized = true;
            watchableObjectClass = MinecraftReflection.getWatchableObjectClass();
            baseModifier = new StructureModifier(watchableObjectClass, null, false);
        }
    }

    public Class<?> getType() throws FieldAccessException {
        return WrappedWatchableObject.getWrappedType(this.getTypeRaw());
    }

    private Class<?> getTypeRaw() throws FieldAccessException {
        if (this.typeClass == null) {
            this.typeClass = WrappedDataWatcher.getTypeClass(this.getTypeID());
            if (this.typeClass == null) {
                throw new IllegalStateException("Unrecognized data type: " + this.getTypeID());
            }
        }
        return this.typeClass;
    }

    public int getIndex() throws FieldAccessException {
        return (Integer)this.modifier.withType(Integer.TYPE).read(1);
    }

    public void setIndex(int index) throws FieldAccessException {
        this.modifier.withType(Integer.TYPE).write(1, index);
    }

    public int getTypeID() throws FieldAccessException {
        return (Integer)this.modifier.withType(Integer.TYPE).read(0);
    }

    public void setTypeID(int id) throws FieldAccessException {
        this.modifier.withType(Integer.TYPE).write(0, id);
    }

    public void setValue(Object newValue) throws FieldAccessException {
        this.setValue(newValue, true);
    }

    public void setValue(Object newValue, boolean updateClient) throws FieldAccessException {
        if (newValue == null) {
            throw new IllegalArgumentException("Cannot watch a NULL value.");
        }
        if (!this.getType().isAssignableFrom(newValue.getClass())) {
            throw new IllegalArgumentException("Object " + newValue + " must be of type " + this.getType().getName());
        }
        if (updateClient) {
            this.setDirtyState(true);
        }
        this.modifier.withType(Object.class).write(0, WrappedWatchableObject.getUnwrapped(newValue));
    }

    private Object getNMSValue() {
        return this.modifier.withType(Object.class).read(0);
    }

    public Object getValue() throws FieldAccessException {
        return WrappedWatchableObject.getWrapped(this.modifier.withType(Object.class).read(0));
    }

    public void setDirtyState(boolean dirty) throws FieldAccessException {
        this.modifier.withType(Boolean.TYPE).write(0, dirty);
    }

    public boolean getDirtyState() throws FieldAccessException {
        return (Boolean)this.modifier.withType(Boolean.TYPE).read(0);
    }

    static Object getWrapped(Object value) {
        if (MinecraftReflection.isItemStack(value)) {
            return BukkitConverters.getItemStackConverter().getSpecific(value);
        }
        if (MinecraftReflection.isChunkCoordinates(value)) {
            return new WrappedChunkCoordinate((Comparable)value);
        }
        return value;
    }

    static Class<?> getWrappedType(Class<?> unwrapped) {
        if (unwrapped.equals(MinecraftReflection.getChunkPositionClass())) {
            return ChunkPosition.class;
        }
        if (unwrapped.equals(MinecraftReflection.getBlockPositionClass())) {
            return BlockPosition.class;
        }
        if (unwrapped.equals(MinecraftReflection.getChunkCoordinatesClass())) {
            return WrappedChunkCoordinate.class;
        }
        if (unwrapped.equals(MinecraftReflection.getItemStackClass())) {
            return ItemStack.class;
        }
        return unwrapped;
    }

    static Object getUnwrapped(Object wrapped) {
        if (wrapped instanceof ChunkPosition) {
            return ChunkPosition.getConverter().getGeneric(MinecraftReflection.getChunkPositionClass(), (ChunkPosition)wrapped);
        }
        if (wrapped instanceof BlockPosition) {
            return BlockPosition.getConverter().getGeneric(MinecraftReflection.getBlockPositionClass(), (BlockPosition)wrapped);
        }
        if (wrapped instanceof WrappedChunkCoordinate) {
            return ((WrappedChunkCoordinate)wrapped).getHandle();
        }
        if (wrapped instanceof ItemStack) {
            return BukkitConverters.getItemStackConverter().getGeneric(MinecraftReflection.getItemStackClass(), (ItemStack)wrapped);
        }
        return wrapped;
    }

    static Class<?> getUnwrappedType(Class<?> wrapped) {
        if (wrapped.equals(ChunkPosition.class)) {
            return MinecraftReflection.getChunkPositionClass();
        }
        if (wrapped.equals(BlockPosition.class)) {
            return MinecraftReflection.getBlockPositionClass();
        }
        if (wrapped.equals(WrappedChunkCoordinate.class)) {
            return MinecraftReflection.getChunkCoordinatesClass();
        }
        if (ItemStack.class.isAssignableFrom(wrapped)) {
            return MinecraftReflection.getItemStackClass();
        }
        return wrapped;
    }

    public WrappedWatchableObject deepClone() throws FieldAccessException {
        WrappedWatchableObject clone = new WrappedWatchableObject(DefaultInstances.DEFAULT.getDefault(MinecraftReflection.getWatchableObjectClass()));
        clone.setDirtyState(this.getDirtyState());
        clone.setIndex(this.getIndex());
        clone.setTypeID(this.getTypeID());
        clone.setValue(this.getClonedValue(), false);
        return clone;
    }

    Object getClonedValue() throws FieldAccessException {
        Object value = this.getNMSValue();
        if (MinecraftReflection.isBlockPosition(value)) {
            EquivalentConverter<BlockPosition> converter = BlockPosition.getConverter();
            return converter.getGeneric(MinecraftReflection.getBlockPositionClass(), converter.getSpecific(value));
        }
        if (MinecraftReflection.isChunkPosition(value)) {
            EquivalentConverter<ChunkPosition> converter = ChunkPosition.getConverter();
            return converter.getGeneric(MinecraftReflection.getChunkPositionClass(), converter.getSpecific(value));
        }
        if (MinecraftReflection.isItemStack(value)) {
            return MinecraftReflection.getMinecraftItemStack(MinecraftReflection.getBukkitItemStack(value).clone());
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedWatchableObject) {
            WrappedWatchableObject other = (WrappedWatchableObject)obj;
            return Objects.equal((Object)this.getIndex(), (Object)other.getIndex()) && Objects.equal((Object)this.getTypeID(), (Object)other.getTypeID()) && Objects.equal((Object)this.getValue(), (Object)other.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getIndex(), this.getTypeID(), this.getValue()});
    }

    public String toString() {
        return String.format("[%s: %s (%s)]", this.getIndex(), this.getValue(), this.getType().getSimpleName());
    }
}

